package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response from the list Members request
 */
@Generated(from = "_ListMembersResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListMembersResponse extends org.cloudfoundry.uaa.groups._ListMembersResponse {
  private final List<Member> members;

  private ListMembersResponse(ListMembersResponse.Builder builder) {
    this.members = createUnmodifiableList(true, builder.members);
  }

  /**
   * The members
   */
  @JsonProperty("members")
  @Override
  public List<Member> getMembers() {
    return members;
  }

  /**
   * This instance is equal to all instances of {@code ListMembersResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListMembersResponse
        && equalTo(0, (ListMembersResponse) another);
  }

  private boolean equalTo(int synthetic, ListMembersResponse another) {
    return members.equals(another.members);
  }

  /**
   * Computes a hash code from attributes: {@code members}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + members.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListMembersResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListMembersResponse{"
        + "members=" + members
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListMembersResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._ListMembersResponse {
    List<Member> members = Collections.emptyList();
    @JsonProperty("members")
    public void setMembers(List<Member> members) {
      this.members = members;
    }
    @Override
    public List<Member> getMembers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListMembersResponse fromJson(Json json) {
    ListMembersResponse.Builder builder = ListMembersResponse.builder();
    if (json.members != null) {
      builder.addAllMembers(json.members);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListMembersResponse ListMembersResponse}.
   * <pre>
   * ListMembersResponse.builder()
   *    .member|addAllMembers(Member) // {@link ListMembersResponse#getMembers() members} elements
   *    .build();
   * </pre>
   * @return A new ListMembersResponse builder
   */
  public static ListMembersResponse.Builder builder() {
    return new ListMembersResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListMembersResponse ListMembersResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListMembersResponse", generator = "Immutables")
  public static final class Builder {
    private List<Member> members = new ArrayList<Member>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListMembersResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListMembersResponse instance) {
      return from((_ListMembersResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListMembersResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListMembersResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllMembers(instance.getMembers());
      return this;
    }

    /**
     * Adds one element to {@link ListMembersResponse#getMembers() members} list.
     * @param element A members element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(Member element) {
      this.members.add(Objects.requireNonNull(element, "members element"));
      return this;
    }

    /**
     * Adds elements to {@link ListMembersResponse#getMembers() members} list.
     * @param elements An array of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder members(Member... elements) {
      for (Member element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListMembersResponse#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("members")
    public final Builder members(Iterable<? extends Member> elements) {
      this.members.clear();
      return addAllMembers(elements);
    }

    /**
     * Adds elements to {@link ListMembersResponse#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMembers(Iterable<? extends Member> elements) {
      for (Member element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListMembersResponse ListMembersResponse}.
     * @return An immutable instance of ListMembersResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListMembersResponse build() {
      return new ListMembersResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
