package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the create identity provider
 */
@Generated(from = "_CreateIdentityProviderRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateIdentityProviderRequest
    extends org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final @Nullable Boolean active;
  private final IdentityProviderConfiguration configuration;
  private final String name;
  private final String originKey;
  private final Type type;

  private CreateIdentityProviderRequest(CreateIdentityProviderRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.active = builder.active;
    this.configuration = builder.configuration;
    this.name = builder.name;
    this.originKey = builder.originKey;
    this.type = builder.type;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * Whether the identity provider is active
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The configuration of this identity provider according to its type.
   */
  @JsonProperty("config")
  @Override
  public IdentityProviderConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * Human-readable name for this provider
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * A unique alias for the provider
   */
  @JsonProperty("originKey")
  @Override
  public String getOriginKey() {
    return originKey;
  }

  /**
   * The type of the identity provider.
   */
  @JsonProperty("type")
  @Override
  public Type getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code CreateIdentityProviderRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateIdentityProviderRequest
        && equalTo(0, (CreateIdentityProviderRequest) another);
  }

  private boolean equalTo(int synthetic, CreateIdentityProviderRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && Objects.equals(active, another.active)
        && configuration.equals(another.configuration)
        && name.equals(another.name)
        && originKey.equals(another.originKey)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code active}, {@code configuration}, {@code name}, {@code originKey}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + configuration.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + originKey.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateIdentityProviderRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateIdentityProviderRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", active=" + active
        + ", configuration=" + configuration
        + ", name=" + name
        + ", originKey=" + originKey
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateIdentityProviderRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    Boolean active;
    IdentityProviderConfiguration configuration;
    String name;
    String originKey;
    Type type;
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty("config")
    public void setConfiguration(IdentityProviderConfiguration configuration) {
      this.configuration = configuration;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("originKey")
    public void setOriginKey(String originKey) {
      this.originKey = originKey;
    }
    @JsonProperty("type")
    public void setType(Type type) {
      this.type = type;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public IdentityProviderConfiguration getConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOriginKey() { throw new UnsupportedOperationException(); }
    @Override
    public Type getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateIdentityProviderRequest fromJson(Json json) {
    CreateIdentityProviderRequest.Builder builder = CreateIdentityProviderRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.configuration != null) {
      builder.configuration(json.configuration);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.originKey != null) {
      builder.originKey(json.originKey);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateIdentityProviderRequest CreateIdentityProviderRequest}.
   * <pre>
   * CreateIdentityProviderRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link CreateIdentityProviderRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link CreateIdentityProviderRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .active(Boolean | null) // nullable {@link CreateIdentityProviderRequest#getActive() active}
   *    .configuration(org.cloudfoundry.uaa.identityproviders.IdentityProviderConfiguration) // required {@link CreateIdentityProviderRequest#getConfiguration() configuration}
   *    .name(String) // required {@link CreateIdentityProviderRequest#getName() name}
   *    .originKey(String) // required {@link CreateIdentityProviderRequest#getOriginKey() originKey}
   *    .type(org.cloudfoundry.uaa.identityproviders.Type) // required {@link CreateIdentityProviderRequest#getType() type}
   *    .build();
   * </pre>
   * @return A new CreateIdentityProviderRequest builder
   */
  public static CreateIdentityProviderRequest.Builder builder() {
    return new CreateIdentityProviderRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateIdentityProviderRequest CreateIdentityProviderRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateIdentityProviderRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONFIGURATION = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_ORIGIN_KEY = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private Boolean active;
    private IdentityProviderConfiguration configuration;
    private String name;
    private String originKey;
    private Type type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateIdentityProviderRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateIdentityProviderRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_CreateIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest) {
        org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest instance = (org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest) object;
        this.name(instance.getName());
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        this.type(instance.getType());
        this.configuration(instance.getConfiguration());
        this.originKey(instance.getOriginKey());
      }
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link CreateIdentityProviderRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityProviderRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityProviderRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityProviderRequest#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configuration(IdentityProviderConfiguration configuration) {
      this.configuration = Objects.requireNonNull(configuration, "configuration");
      initBits &= ~INIT_BIT_CONFIGURATION;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityProviderRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityProviderRequest#getOriginKey() originKey} attribute.
     * @param originKey The value for originKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder originKey(String originKey) {
      this.originKey = Objects.requireNonNull(originKey, "originKey");
      initBits &= ~INIT_BIT_ORIGIN_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityProviderRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link CreateIdentityProviderRequest CreateIdentityProviderRequest}.
     * @return An immutable instance of CreateIdentityProviderRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateIdentityProviderRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateIdentityProviderRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONFIGURATION) != 0) attributes.add("configuration");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORIGIN_KEY) != 0) attributes.add("originKey");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build CreateIdentityProviderRequest, some of required attributes are not set " + attributes;
    }
  }
}
