package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response from the get identity provider request
 */
@Generated(from = "_GetIdentityProviderResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetIdentityProviderResponse
    extends org.cloudfoundry.uaa.identityproviders._GetIdentityProviderResponse {
  private final Boolean active;
  private final @Nullable IdentityProviderConfiguration configuration;
  private final Long createdAt;
  private final String id;
  private final @Nullable String aliasId;
  private final @Nullable String aliasZid;
  private final String identityZoneId;
  private final Long lastModified;
  private final String name;
  private final String originKey;
  private final Type type;
  private final Integer version;

  private GetIdentityProviderResponse(GetIdentityProviderResponse.Builder builder) {
    this.active = builder.active;
    this.configuration = builder.configuration;
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.aliasId = builder.aliasId;
    this.aliasZid = builder.aliasZid;
    this.identityZoneId = builder.identityZoneId;
    this.lastModified = builder.lastModified;
    this.name = builder.name;
    this.originKey = builder.originKey;
    this.type = builder.type;
    this.version = builder.version;
  }

  /**
   * Whether the identity provider is active
   */
  @JsonProperty("active")
  @Override
  public Boolean getActive() {
    return active;
  }

  /**
   * The configuration of this identity provider
   */
  @JsonProperty("config")
  @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
  @JsonSubTypes({@JsonSubTypes.Type(name = "keystone", value = KeystoneConfiguration.class), @JsonSubTypes.Type(name = "ldap", value = LdapConfiguration.class), @JsonSubTypes.Type(name = "oauth2.0", value = OAuth2Configuration.class), @JsonSubTypes.Type(name = "oidc1.0", value = OpenIdConnectConfiguration.class), @JsonSubTypes.Type(name = "saml", value = SamlConfiguration.class), @JsonSubTypes.Type(name = "uaa", value = InternalConfiguration.class)})
  @Override
  public @Nullable IdentityProviderConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * The creation date of the identity provider
   */
  @JsonProperty("created")
  @Override
  public Long getCreatedAt() {
    return createdAt;
  }

  /**
   * The id
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The alias id
   */
  @JsonProperty("aliasId")
  @Override
  public @Nullable String getAliasId() {
    return aliasId;
  }

  /**
   * The alias Zone id
   */
  @JsonProperty("aliasZid")
  @Override
  public @Nullable String getAliasZid() {
    return aliasZid;
  }

  /**
   * Set to the zone that this provider will be active in. Determined either by the Host header or the zone switch header.
   */
  @JsonProperty("identityZoneId")
  @Override
  public String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * The last modification date of the identity provider
   */
  @JsonProperty("last_modified")
  @Override
  public Long getLastModified() {
    return lastModified;
  }

  /**
   * Human-readable name for this provider
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * A unique alias for the provider
   */
  @JsonProperty("originKey")
  @Override
  public String getOriginKey() {
    return originKey;
  }

  /**
   * The type of identity provider
   */
  @JsonProperty("type")
  @Override
  public Type getType() {
    return type;
  }

  /**
   * Version of the identity provider data. Clients can use this to protect against conflicting updates
   */
  @JsonProperty("version")
  @Override
  public Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code GetIdentityProviderResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetIdentityProviderResponse
        && equalTo(0, (GetIdentityProviderResponse) another);
  }

  private boolean equalTo(int synthetic, GetIdentityProviderResponse another) {
    return active.equals(another.active)
        && Objects.equals(configuration, another.configuration)
        && createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && Objects.equals(aliasId, another.aliasId)
        && Objects.equals(aliasZid, another.aliasZid)
        && identityZoneId.equals(another.identityZoneId)
        && lastModified.equals(another.lastModified)
        && name.equals(another.name)
        && originKey.equals(another.originKey)
        && type.equals(another.type)
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code configuration}, {@code createdAt}, {@code id}, {@code aliasId}, {@code aliasZid}, {@code identityZoneId}, {@code lastModified}, {@code name}, {@code originKey}, {@code type}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + active.hashCode();
    h += (h << 5) + Objects.hashCode(configuration);
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(aliasId);
    h += (h << 5) + Objects.hashCode(aliasZid);
    h += (h << 5) + identityZoneId.hashCode();
    h += (h << 5) + lastModified.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + originKey.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetIdentityProviderResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetIdentityProviderResponse{"
        + "active=" + active
        + ", configuration=" + configuration
        + ", createdAt=" + createdAt
        + ", id=" + id
        + ", aliasId=" + aliasId
        + ", aliasZid=" + aliasZid
        + ", identityZoneId=" + identityZoneId
        + ", lastModified=" + lastModified
        + ", name=" + name
        + ", originKey=" + originKey
        + ", type=" + type
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetIdentityProviderResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._GetIdentityProviderResponse {
    Boolean active;
    IdentityProviderConfiguration configuration;
    Long createdAt;
    String id;
    String aliasId;
    String aliasZid;
    String identityZoneId;
    Long lastModified;
    String name;
    String originKey;
    Type type;
    Integer version;
    @JsonProperty("active")
    public void setActive(Boolean active) {
      this.active = active;
    }
    @JsonProperty("config")
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
    @JsonSubTypes({@JsonSubTypes.Type(name = "keystone", value = KeystoneConfiguration.class), @JsonSubTypes.Type(name = "ldap", value = LdapConfiguration.class), @JsonSubTypes.Type(name = "oauth2.0", value = OAuth2Configuration.class), @JsonSubTypes.Type(name = "oidc1.0", value = OpenIdConnectConfiguration.class), @JsonSubTypes.Type(name = "saml", value = SamlConfiguration.class), @JsonSubTypes.Type(name = "uaa", value = InternalConfiguration.class)})
    public void setConfiguration(@Nullable IdentityProviderConfiguration configuration) {
      this.configuration = configuration;
    }
    @JsonProperty("created")
    public void setCreatedAt(Long createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("aliasId")
    public void setAliasId(@Nullable String aliasId) {
      this.aliasId = aliasId;
    }
    @JsonProperty("aliasZid")
    public void setAliasZid(@Nullable String aliasZid) {
      this.aliasZid = aliasZid;
    }
    @JsonProperty("identityZoneId")
    public void setIdentityZoneId(String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("last_modified")
    public void setLastModified(Long lastModified) {
      this.lastModified = lastModified;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("originKey")
    public void setOriginKey(String originKey) {
      this.originKey = originKey;
    }
    @JsonProperty("type")
    public void setType(Type type) {
      this.type = type;
    }
    @JsonProperty("version")
    public void setVersion(Integer version) {
      this.version = version;
    }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public IdentityProviderConfiguration getConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public Long getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getAliasId() { throw new UnsupportedOperationException(); }
    @Override
    public String getAliasZid() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOriginKey() { throw new UnsupportedOperationException(); }
    @Override
    public Type getType() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetIdentityProviderResponse fromJson(Json json) {
    GetIdentityProviderResponse.Builder builder = GetIdentityProviderResponse.builder();
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.configuration != null) {
      builder.configuration(json.configuration);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.aliasId != null) {
      builder.aliasId(json.aliasId);
    }
    if (json.aliasZid != null) {
      builder.aliasZid(json.aliasZid);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.lastModified != null) {
      builder.lastModified(json.lastModified);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.originKey != null) {
      builder.originKey(json.originKey);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetIdentityProviderResponse GetIdentityProviderResponse}.
   * <pre>
   * GetIdentityProviderResponse.builder()
   *    .active(Boolean) // required {@link GetIdentityProviderResponse#getActive() active}
   *    .configuration(org.cloudfoundry.uaa.identityproviders.IdentityProviderConfiguration | null) // nullable {@link GetIdentityProviderResponse#getConfiguration() configuration}
   *    .createdAt(Long) // required {@link GetIdentityProviderResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetIdentityProviderResponse#getId() id}
   *    .aliasId(String | null) // nullable {@link GetIdentityProviderResponse#getAliasId() aliasId}
   *    .aliasZid(String | null) // nullable {@link GetIdentityProviderResponse#getAliasZid() aliasZid}
   *    .identityZoneId(String) // required {@link GetIdentityProviderResponse#getIdentityZoneId() identityZoneId}
   *    .lastModified(Long) // required {@link GetIdentityProviderResponse#getLastModified() lastModified}
   *    .name(String) // required {@link GetIdentityProviderResponse#getName() name}
   *    .originKey(String) // required {@link GetIdentityProviderResponse#getOriginKey() originKey}
   *    .type(org.cloudfoundry.uaa.identityproviders.Type) // required {@link GetIdentityProviderResponse#getType() type}
   *    .version(Integer) // required {@link GetIdentityProviderResponse#getVersion() version}
   *    .build();
   * </pre>
   * @return A new GetIdentityProviderResponse builder
   */
  public static GetIdentityProviderResponse.Builder builder() {
    return new GetIdentityProviderResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetIdentityProviderResponse GetIdentityProviderResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetIdentityProviderResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ACTIVE = 0x1L;
    private static final long INIT_BIT_CREATED_AT = 0x2L;
    private static final long INIT_BIT_ID = 0x4L;
    private static final long INIT_BIT_IDENTITY_ZONE_ID = 0x8L;
    private static final long INIT_BIT_LAST_MODIFIED = 0x10L;
    private static final long INIT_BIT_NAME = 0x20L;
    private static final long INIT_BIT_ORIGIN_KEY = 0x40L;
    private static final long INIT_BIT_TYPE = 0x80L;
    private static final long INIT_BIT_VERSION = 0x100L;
    private long initBits = 0x1ffL;

    private Boolean active;
    private IdentityProviderConfiguration configuration;
    private Long createdAt;
    private String id;
    private String aliasId;
    private String aliasZid;
    private String identityZoneId;
    private Long lastModified;
    private String name;
    private String originKey;
    private Type type;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractIdentityProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetIdentityProviderResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetIdentityProviderResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetIdentityProviderResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetIdentityProviderResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractIdentityProvider) {
        AbstractIdentityProvider instance = (AbstractIdentityProvider) object;
        this.createdAt(instance.getCreatedAt());
        IdentityProviderConfiguration configurationValue = instance.getConfiguration();
        if (configurationValue != null) {
          configuration(configurationValue);
        }
        String aliasIdValue = instance.getAliasId();
        if (aliasIdValue != null) {
          aliasId(aliasIdValue);
        }
        this.originKey(instance.getOriginKey());
        this.name(instance.getName());
        this.active(instance.getActive());
        String aliasZidValue = instance.getAliasZid();
        if (aliasZidValue != null) {
          aliasZid(aliasZidValue);
        }
        this.id(instance.getId());
        this.lastModified(instance.getLastModified());
        this.type(instance.getType());
        this.version(instance.getVersion());
        this.identityZoneId(instance.getIdentityZoneId());
      }
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getActive() active} attribute.
     * @param active The value for active 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("active")
    public final Builder active(Boolean active) {
      this.active = Objects.requireNonNull(active, "active");
      initBits &= ~INIT_BIT_ACTIVE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("config")
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
    @JsonSubTypes({@JsonSubTypes.Type(name = "keystone", value = KeystoneConfiguration.class), @JsonSubTypes.Type(name = "ldap", value = LdapConfiguration.class), @JsonSubTypes.Type(name = "oauth2.0", value = OAuth2Configuration.class), @JsonSubTypes.Type(name = "oidc1.0", value = OpenIdConnectConfiguration.class), @JsonSubTypes.Type(name = "saml", value = SamlConfiguration.class), @JsonSubTypes.Type(name = "uaa", value = InternalConfiguration.class)})
    public final Builder configuration(@Nullable IdentityProviderConfiguration configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder createdAt(Long createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getAliasId() aliasId} attribute.
     * @param aliasId The value for aliasId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("aliasId")
    public final Builder aliasId(@Nullable String aliasId) {
      this.aliasId = aliasId;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getAliasZid() aliasZid} attribute.
     * @param aliasZid The value for aliasZid (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("aliasZid")
    public final Builder aliasZid(@Nullable String aliasZid) {
      this.aliasZid = aliasZid;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("identityZoneId")
    public final Builder identityZoneId(String identityZoneId) {
      this.identityZoneId = Objects.requireNonNull(identityZoneId, "identityZoneId");
      initBits &= ~INIT_BIT_IDENTITY_ZONE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("last_modified")
    public final Builder lastModified(Long lastModified) {
      this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
      initBits &= ~INIT_BIT_LAST_MODIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getOriginKey() originKey} attribute.
     * @param originKey The value for originKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("originKey")
    public final Builder originKey(String originKey) {
      this.originKey = Objects.requireNonNull(originKey, "originKey");
      initBits &= ~INIT_BIT_ORIGIN_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityProviderResponse#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Builds a new {@link GetIdentityProviderResponse GetIdentityProviderResponse}.
     * @return An immutable instance of GetIdentityProviderResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetIdentityProviderResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetIdentityProviderResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACTIVE) != 0) attributes.add("active");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_IDENTITY_ZONE_ID) != 0) attributes.add("identityZoneId");
      if ((initBits & INIT_BIT_LAST_MODIFIED) != 0) attributes.add("lastModified");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORIGIN_KEY) != 0) attributes.add("originKey");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build GetIdentityProviderResponse, some of required attributes are not set " + attributes;
    }
  }
}
