package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for the OAuth2 identity provider configuration
 */
@Generated(from = "_OAuth2Configuration", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OAuth2Configuration extends org.cloudfoundry.uaa.identityproviders._OAuth2Configuration {
  private final @Nullable List<String> emailDomains;
  private final @Nullable String providerDescription;
  private final @Nullable String authMethod;
  private final @Nullable AttributeMappings attributeMappings;
  private final @Nullable List<String> externalGroupsWhitelist;
  private final @Nullable Boolean storeCustomAttributes;
  private final @Nullable Boolean addShadowUserOnLogin;
  private final String authUrl;
  private final @Nullable Boolean linkText;
  private final String relyingPartyId;
  private final @Nullable String relyingPartySecret;
  private final @Nullable List<String> scopes;
  private final @Nullable Boolean showLinkText;
  private final @Nullable Boolean skipSslVerification;
  private final @Nullable String tokenKey;
  private final @Nullable String tokenKeyUrl;
  private final String tokenUrl;
  private final @Nullable String checkTokenUrl;
  private final @Nullable Boolean clientAuthInBody;
  private final @Nullable String issuer;
  private final @Nullable String responseType;
  private final @Nullable String userInfoUrl;
  private final @Nullable String userPropagationParameter;
  private final @Nullable Boolean cacheJwks;
  private final @Nullable Boolean pkce;
  private final @Nullable String logoutUrl;
  private final @Nullable Boolean performRpInitiatedLogout;

  private OAuth2Configuration(OAuth2Configuration.Builder builder) {
    this.emailDomains = builder.emailDomains == null ? null : createUnmodifiableList(true, builder.emailDomains);
    this.providerDescription = builder.providerDescription;
    this.authMethod = builder.authMethod;
    this.attributeMappings = builder.attributeMappings;
    this.externalGroupsWhitelist = builder.externalGroupsWhitelist == null ? null : createUnmodifiableList(true, builder.externalGroupsWhitelist);
    this.storeCustomAttributes = builder.storeCustomAttributes;
    this.addShadowUserOnLogin = builder.addShadowUserOnLogin;
    this.authUrl = builder.authUrl;
    this.linkText = builder.linkText;
    this.relyingPartyId = builder.relyingPartyId;
    this.relyingPartySecret = builder.relyingPartySecret;
    this.scopes = builder.scopes == null ? null : createUnmodifiableList(true, builder.scopes);
    this.showLinkText = builder.showLinkText;
    this.skipSslVerification = builder.skipSslVerification;
    this.tokenKey = builder.tokenKey;
    this.tokenKeyUrl = builder.tokenKeyUrl;
    this.tokenUrl = builder.tokenUrl;
    this.checkTokenUrl = builder.checkTokenUrl;
    this.clientAuthInBody = builder.clientAuthInBody;
    this.issuer = builder.issuer;
    this.responseType = builder.responseType;
    this.userInfoUrl = builder.userInfoUrl;
    this.userPropagationParameter = builder.userPropagationParameter;
    this.cacheJwks = builder.cacheJwks;
    this.pkce = builder.pkce;
    this.logoutUrl = builder.logoutUrl;
    this.performRpInitiatedLogout = builder.performRpInitiatedLogout;
  }

  /**
   * List of email domains associated with the provider for the purpose of associating users to the correct origin upon invitation. If empty list, no invitations are accepted. Wildcards supported.
   */
  @JsonProperty("emailDomain")
  @Override
  public @Nullable List<String> getEmailDomains() {
    return emailDomains;
  }

  /**
   * Human readable name/description of this provider
   */
  @JsonProperty("providerDescription")
  @Override
  public @Nullable String getProviderDescription() {
    return providerDescription;
  }

  /**
   * explicit method to authenticate against the identity provider.
   */
  @JsonProperty("authMethod")
  @Override
  public @Nullable String getAuthMethod() {
    return authMethod;
  }

  /**
   * @return The value of the {@code attributeMappings} attribute
   */
  @JsonProperty("attributeMappings")
  @Override
  public @Nullable AttributeMappings getAttributeMappings() {
    return attributeMappings;
  }

  /**
   * The external group white list
   */
  @JsonProperty("externalGroupsWhitelist")
  @Override
  public @Nullable List<String> getExternalGroupsWhitelist() {
    return externalGroupsWhitelist;
  }

  /**
   * Set to true, to store custom user attributes to be fetched from the /userinfo endpoint
   */
  @JsonProperty("storeCustomAttributes")
  @Override
  public @Nullable Boolean getStoreCustomAttributes() {
    return storeCustomAttributes;
  }

  /**
   * Determines whether or not shadow users must be created before login by an administrator.
   */
  @JsonProperty("addShadowUserOnLogin")
  @Override
  public @Nullable Boolean getAddShadowUserOnLogin() {
    return addShadowUserOnLogin;
  }

  /**
   * The OAuth 2.0 authorization endpoint URL
   */
  @JsonProperty("authUrl")
  @Override
  public String getAuthUrl() {
    return authUrl;
  }

  /**
   * Text to use for the login link to the provider
   */
  @JsonProperty("linkText")
  @Override
  public @Nullable Boolean getLinkText() {
    return linkText;
  }

  /**
   * The client ID which is registered with the external OAuth provider for use by the UAA
   */
  @JsonProperty("relyingPartyId")
  @Override
  public String getRelyingPartyId() {
    return relyingPartyId;
  }

  /**
   * The client secret of the relying party at the external OAuth provider
   */
  @JsonProperty("relyingPartySecret")
  @Override
  public @Nullable String getRelyingPartySecret() {
    return relyingPartySecret;
  }

  /**
   * What scopes to request on a call to the external OAuth/OpenID provider. For example, can provide openid, roles, or profile to request ID token, scopes populated in the ID token external groups
   * attribute mappings, or the user profile information, respectively.
   */
  @JsonProperty("scopes")
  @Override
  public @Nullable List<String> getScopes() {
    return scopes;
  }

  /**
   * A flag controlling whether a link to this provider’s login will be shown on the UAA login page
   */
  @JsonProperty("showLinkText")
  @Override
  public @Nullable Boolean getShowLinkText() {
    return showLinkText;
  }

  /**
   * Skips validation of the LDAP cert if set to true.
   */
  @JsonProperty("skipSslValidation")
  @Override
  public @Nullable Boolean getSkipSslVerification() {
    return skipSslVerification;
  }

  /**
   * A verification key for validating token signatures
   */
  @JsonProperty("tokenKey")
  @Override
  public @Nullable String getTokenKey() {
    return tokenKey;
  }

  /**
   * The URL of the token key endpoint which renders a verification key for validating token signatures
   */
  @JsonProperty("tokenKeyUrl")
  @Override
  public @Nullable String getTokenKeyUrl() {
    return tokenKeyUrl;
  }

  /**
   * The OAuth 2.0 authorization endpoint URL
   */
  @JsonProperty("tokenUrl")
  @Override
  public String getTokenUrl() {
    return tokenUrl;
  }

  /**
   * The OAuth check token endpoint URL. Reserved for future OAuth use.
   */
  @JsonProperty("checkTokenUrl")
  @Override
  public @Nullable String getCheckTokenUrl() {
    return checkTokenUrl;
  }

  /**
   * Send the client credentials in the token retrieval call as body parameters instead of a Basic Authorization header.
   */
  @JsonProperty("clientAuthInBody")
  @Override
  public @Nullable Boolean getClientAuthInBody() {
    return clientAuthInBody;
  }

  /**
   * The OAuth 2.0 token issuer.
   */
  @JsonProperty("issuer")
  @Override
  public @Nullable String getIssuer() {
    return issuer;
  }

  /**
   * The OAuth 2.0 response type.
   */
  @JsonProperty("responseType")
  @Override
  public @Nullable String getResponseType() {
    return responseType;
  }

  /**
   * A URL for fetching user info attributes when queried with the obtained token authorization.
   */
  @JsonProperty("userInfoUrl")
  @Override
  public @Nullable String getUserInfoUrl() {
    return userInfoUrl;
  }

  /**
   * Name of the request parameter that is used to pass a known username when redirecting to this identity provider from the account chooser
   */
  @JsonProperty("userPropagationParameter")
  @Override
  public @Nullable String getUserPropagationParameter() {
    return userPropagationParameter;
  }

  /**
   * A flag controlling whether PKCE (RFC 7636) is active in authorization code flow when requesting tokens from the external provider.
   */
  @JsonProperty("cacheJwks")
  @Override
  public @Nullable Boolean getCacheJwks() {
    return cacheJwks;
  }

  /**
   * Option to enable caching for the JWKS (verification key for validating token signatures)
   */
  @JsonProperty("pkce")
  @Override
  public @Nullable Boolean getPkce() {
    return pkce;
  }

  /**
   * OAuth 2.0 logout endpoint.
   */
  @JsonProperty("logoutUrl")
  @Override
  public @Nullable String getLogoutUrl() {
    return logoutUrl;
  }

  /**
   * A flag controlling whether to log out of the external provider after a successful UAA logout
   */
  @JsonProperty("performRpInitiatedLogout")
  @Override
  public @Nullable Boolean getPerformRpInitiatedLogout() {
    return performRpInitiatedLogout;
  }

  /**
   * This instance is equal to all instances of {@code OAuth2Configuration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OAuth2Configuration
        && equalTo(0, (OAuth2Configuration) another);
  }

  private boolean equalTo(int synthetic, OAuth2Configuration another) {
    return Objects.equals(emailDomains, another.emailDomains)
        && Objects.equals(providerDescription, another.providerDescription)
        && Objects.equals(authMethod, another.authMethod)
        && Objects.equals(attributeMappings, another.attributeMappings)
        && Objects.equals(externalGroupsWhitelist, another.externalGroupsWhitelist)
        && Objects.equals(storeCustomAttributes, another.storeCustomAttributes)
        && Objects.equals(addShadowUserOnLogin, another.addShadowUserOnLogin)
        && authUrl.equals(another.authUrl)
        && Objects.equals(linkText, another.linkText)
        && relyingPartyId.equals(another.relyingPartyId)
        && Objects.equals(relyingPartySecret, another.relyingPartySecret)
        && Objects.equals(scopes, another.scopes)
        && Objects.equals(showLinkText, another.showLinkText)
        && Objects.equals(skipSslVerification, another.skipSslVerification)
        && Objects.equals(tokenKey, another.tokenKey)
        && Objects.equals(tokenKeyUrl, another.tokenKeyUrl)
        && tokenUrl.equals(another.tokenUrl)
        && Objects.equals(checkTokenUrl, another.checkTokenUrl)
        && Objects.equals(clientAuthInBody, another.clientAuthInBody)
        && Objects.equals(issuer, another.issuer)
        && Objects.equals(responseType, another.responseType)
        && Objects.equals(userInfoUrl, another.userInfoUrl)
        && Objects.equals(userPropagationParameter, another.userPropagationParameter)
        && Objects.equals(cacheJwks, another.cacheJwks)
        && Objects.equals(pkce, another.pkce)
        && Objects.equals(logoutUrl, another.logoutUrl)
        && Objects.equals(performRpInitiatedLogout, another.performRpInitiatedLogout);
  }

  /**
   * Computes a hash code from attributes: {@code emailDomains}, {@code providerDescription}, {@code authMethod}, {@code attributeMappings}, {@code externalGroupsWhitelist}, {@code storeCustomAttributes}, {@code addShadowUserOnLogin}, {@code authUrl}, {@code linkText}, {@code relyingPartyId}, {@code relyingPartySecret}, {@code scopes}, {@code showLinkText}, {@code skipSslVerification}, {@code tokenKey}, {@code tokenKeyUrl}, {@code tokenUrl}, {@code checkTokenUrl}, {@code clientAuthInBody}, {@code issuer}, {@code responseType}, {@code userInfoUrl}, {@code userPropagationParameter}, {@code cacheJwks}, {@code pkce}, {@code logoutUrl}, {@code performRpInitiatedLogout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(emailDomains);
    h += (h << 5) + Objects.hashCode(providerDescription);
    h += (h << 5) + Objects.hashCode(authMethod);
    h += (h << 5) + Objects.hashCode(attributeMappings);
    h += (h << 5) + Objects.hashCode(externalGroupsWhitelist);
    h += (h << 5) + Objects.hashCode(storeCustomAttributes);
    h += (h << 5) + Objects.hashCode(addShadowUserOnLogin);
    h += (h << 5) + authUrl.hashCode();
    h += (h << 5) + Objects.hashCode(linkText);
    h += (h << 5) + relyingPartyId.hashCode();
    h += (h << 5) + Objects.hashCode(relyingPartySecret);
    h += (h << 5) + Objects.hashCode(scopes);
    h += (h << 5) + Objects.hashCode(showLinkText);
    h += (h << 5) + Objects.hashCode(skipSslVerification);
    h += (h << 5) + Objects.hashCode(tokenKey);
    h += (h << 5) + Objects.hashCode(tokenKeyUrl);
    h += (h << 5) + tokenUrl.hashCode();
    h += (h << 5) + Objects.hashCode(checkTokenUrl);
    h += (h << 5) + Objects.hashCode(clientAuthInBody);
    h += (h << 5) + Objects.hashCode(issuer);
    h += (h << 5) + Objects.hashCode(responseType);
    h += (h << 5) + Objects.hashCode(userInfoUrl);
    h += (h << 5) + Objects.hashCode(userPropagationParameter);
    h += (h << 5) + Objects.hashCode(cacheJwks);
    h += (h << 5) + Objects.hashCode(pkce);
    h += (h << 5) + Objects.hashCode(logoutUrl);
    h += (h << 5) + Objects.hashCode(performRpInitiatedLogout);
    return h;
  }

  /**
   * Prints the immutable value {@code OAuth2Configuration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OAuth2Configuration{"
        + "emailDomains=" + emailDomains
        + ", providerDescription=" + providerDescription
        + ", authMethod=" + authMethod
        + ", attributeMappings=" + attributeMappings
        + ", externalGroupsWhitelist=" + externalGroupsWhitelist
        + ", storeCustomAttributes=" + storeCustomAttributes
        + ", addShadowUserOnLogin=" + addShadowUserOnLogin
        + ", authUrl=" + authUrl
        + ", linkText=" + linkText
        + ", relyingPartyId=" + relyingPartyId
        + ", relyingPartySecret=" + relyingPartySecret
        + ", scopes=" + scopes
        + ", showLinkText=" + showLinkText
        + ", skipSslVerification=" + skipSslVerification
        + ", tokenKey=" + tokenKey
        + ", tokenKeyUrl=" + tokenKeyUrl
        + ", tokenUrl=" + tokenUrl
        + ", checkTokenUrl=" + checkTokenUrl
        + ", clientAuthInBody=" + clientAuthInBody
        + ", issuer=" + issuer
        + ", responseType=" + responseType
        + ", userInfoUrl=" + userInfoUrl
        + ", userPropagationParameter=" + userPropagationParameter
        + ", cacheJwks=" + cacheJwks
        + ", pkce=" + pkce
        + ", logoutUrl=" + logoutUrl
        + ", performRpInitiatedLogout=" + performRpInitiatedLogout
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_OAuth2Configuration", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._OAuth2Configuration {
    List<String> emailDomains = null;
    String providerDescription;
    String authMethod;
    AttributeMappings attributeMappings;
    List<String> externalGroupsWhitelist = null;
    Boolean storeCustomAttributes;
    Boolean addShadowUserOnLogin;
    String authUrl;
    Boolean linkText;
    String relyingPartyId;
    String relyingPartySecret;
    List<String> scopes = null;
    Boolean showLinkText;
    Boolean skipSslVerification;
    String tokenKey;
    String tokenKeyUrl;
    String tokenUrl;
    String checkTokenUrl;
    Boolean clientAuthInBody;
    String issuer;
    String responseType;
    String userInfoUrl;
    String userPropagationParameter;
    Boolean cacheJwks;
    Boolean pkce;
    String logoutUrl;
    Boolean performRpInitiatedLogout;
    @JsonProperty("emailDomain")
    public void setEmailDomains(@Nullable List<String> emailDomains) {
      this.emailDomains = emailDomains;
    }
    @JsonProperty("providerDescription")
    public void setProviderDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
    }
    @JsonProperty("authMethod")
    public void setAuthMethod(@Nullable String authMethod) {
      this.authMethod = authMethod;
    }
    @JsonProperty("attributeMappings")
    public void setAttributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
    }
    @JsonProperty("externalGroupsWhitelist")
    public void setExternalGroupsWhitelist(@Nullable List<String> externalGroupsWhitelist) {
      this.externalGroupsWhitelist = externalGroupsWhitelist;
    }
    @JsonProperty("storeCustomAttributes")
    public void setStoreCustomAttributes(@Nullable Boolean storeCustomAttributes) {
      this.storeCustomAttributes = storeCustomAttributes;
    }
    @JsonProperty("addShadowUserOnLogin")
    public void setAddShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
    }
    @JsonProperty("authUrl")
    public void setAuthUrl(String authUrl) {
      this.authUrl = authUrl;
    }
    @JsonProperty("linkText")
    public void setLinkText(@Nullable Boolean linkText) {
      this.linkText = linkText;
    }
    @JsonProperty("relyingPartyId")
    public void setRelyingPartyId(String relyingPartyId) {
      this.relyingPartyId = relyingPartyId;
    }
    @JsonProperty("relyingPartySecret")
    public void setRelyingPartySecret(@Nullable String relyingPartySecret) {
      this.relyingPartySecret = relyingPartySecret;
    }
    @JsonProperty("scopes")
    public void setScopes(@Nullable List<String> scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("showLinkText")
    public void setShowLinkText(@Nullable Boolean showLinkText) {
      this.showLinkText = showLinkText;
    }
    @JsonProperty("skipSslValidation")
    public void setSkipSslVerification(@Nullable Boolean skipSslVerification) {
      this.skipSslVerification = skipSslVerification;
    }
    @JsonProperty("tokenKey")
    public void setTokenKey(@Nullable String tokenKey) {
      this.tokenKey = tokenKey;
    }
    @JsonProperty("tokenKeyUrl")
    public void setTokenKeyUrl(@Nullable String tokenKeyUrl) {
      this.tokenKeyUrl = tokenKeyUrl;
    }
    @JsonProperty("tokenUrl")
    public void setTokenUrl(String tokenUrl) {
      this.tokenUrl = tokenUrl;
    }
    @JsonProperty("checkTokenUrl")
    public void setCheckTokenUrl(@Nullable String checkTokenUrl) {
      this.checkTokenUrl = checkTokenUrl;
    }
    @JsonProperty("clientAuthInBody")
    public void setClientAuthInBody(@Nullable Boolean clientAuthInBody) {
      this.clientAuthInBody = clientAuthInBody;
    }
    @JsonProperty("issuer")
    public void setIssuer(@Nullable String issuer) {
      this.issuer = issuer;
    }
    @JsonProperty("responseType")
    public void setResponseType(@Nullable String responseType) {
      this.responseType = responseType;
    }
    @JsonProperty("userInfoUrl")
    public void setUserInfoUrl(@Nullable String userInfoUrl) {
      this.userInfoUrl = userInfoUrl;
    }
    @JsonProperty("userPropagationParameter")
    public void setUserPropagationParameter(@Nullable String userPropagationParameter) {
      this.userPropagationParameter = userPropagationParameter;
    }
    @JsonProperty("cacheJwks")
    public void setCacheJwks(@Nullable Boolean cacheJwks) {
      this.cacheJwks = cacheJwks;
    }
    @JsonProperty("pkce")
    public void setPkce(@Nullable Boolean pkce) {
      this.pkce = pkce;
    }
    @JsonProperty("logoutUrl")
    public void setLogoutUrl(@Nullable String logoutUrl) {
      this.logoutUrl = logoutUrl;
    }
    @JsonProperty("performRpInitiatedLogout")
    public void setPerformRpInitiatedLogout(@Nullable Boolean performRpInitiatedLogout) {
      this.performRpInitiatedLogout = performRpInitiatedLogout;
    }
    @Override
    public List<String> getEmailDomains() { throw new UnsupportedOperationException(); }
    @Override
    public String getProviderDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthMethod() { throw new UnsupportedOperationException(); }
    @Override
    public AttributeMappings getAttributeMappings() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getExternalGroupsWhitelist() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getStoreCustomAttributes() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAddShadowUserOnLogin() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getLinkText() { throw new UnsupportedOperationException(); }
    @Override
    public String getRelyingPartyId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRelyingPartySecret() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getShowLinkText() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getSkipSslVerification() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenKey() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenKeyUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getCheckTokenUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getClientAuthInBody() { throw new UnsupportedOperationException(); }
    @Override
    public String getIssuer() { throw new UnsupportedOperationException(); }
    @Override
    public String getResponseType() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserInfoUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserPropagationParameter() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getCacheJwks() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPkce() { throw new UnsupportedOperationException(); }
    @Override
    public String getLogoutUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPerformRpInitiatedLogout() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static OAuth2Configuration fromJson(Json json) {
    OAuth2Configuration.Builder builder = OAuth2Configuration.builder();
    if (json.emailDomains != null) {
      builder.addAllEmailDomains(json.emailDomains);
    }
    if (json.providerDescription != null) {
      builder.providerDescription(json.providerDescription);
    }
    if (json.authMethod != null) {
      builder.authMethod(json.authMethod);
    }
    if (json.attributeMappings != null) {
      builder.attributeMappings(json.attributeMappings);
    }
    if (json.externalGroupsWhitelist != null) {
      builder.addAllExternalGroupsWhitelist(json.externalGroupsWhitelist);
    }
    if (json.storeCustomAttributes != null) {
      builder.storeCustomAttributes(json.storeCustomAttributes);
    }
    if (json.addShadowUserOnLogin != null) {
      builder.addShadowUserOnLogin(json.addShadowUserOnLogin);
    }
    if (json.authUrl != null) {
      builder.authUrl(json.authUrl);
    }
    if (json.linkText != null) {
      builder.linkText(json.linkText);
    }
    if (json.relyingPartyId != null) {
      builder.relyingPartyId(json.relyingPartyId);
    }
    if (json.relyingPartySecret != null) {
      builder.relyingPartySecret(json.relyingPartySecret);
    }
    if (json.scopes != null) {
      builder.addAllScopes(json.scopes);
    }
    if (json.showLinkText != null) {
      builder.showLinkText(json.showLinkText);
    }
    if (json.skipSslVerification != null) {
      builder.skipSslVerification(json.skipSslVerification);
    }
    if (json.tokenKey != null) {
      builder.tokenKey(json.tokenKey);
    }
    if (json.tokenKeyUrl != null) {
      builder.tokenKeyUrl(json.tokenKeyUrl);
    }
    if (json.tokenUrl != null) {
      builder.tokenUrl(json.tokenUrl);
    }
    if (json.checkTokenUrl != null) {
      builder.checkTokenUrl(json.checkTokenUrl);
    }
    if (json.clientAuthInBody != null) {
      builder.clientAuthInBody(json.clientAuthInBody);
    }
    if (json.issuer != null) {
      builder.issuer(json.issuer);
    }
    if (json.responseType != null) {
      builder.responseType(json.responseType);
    }
    if (json.userInfoUrl != null) {
      builder.userInfoUrl(json.userInfoUrl);
    }
    if (json.userPropagationParameter != null) {
      builder.userPropagationParameter(json.userPropagationParameter);
    }
    if (json.cacheJwks != null) {
      builder.cacheJwks(json.cacheJwks);
    }
    if (json.pkce != null) {
      builder.pkce(json.pkce);
    }
    if (json.logoutUrl != null) {
      builder.logoutUrl(json.logoutUrl);
    }
    if (json.performRpInitiatedLogout != null) {
      builder.performRpInitiatedLogout(json.performRpInitiatedLogout);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link OAuth2Configuration OAuth2Configuration}.
   * <pre>
   * OAuth2Configuration.builder()
   *    .emailDomains(List&amp;lt;String&amp;gt; | null) // nullable {@link OAuth2Configuration#getEmailDomains() emailDomains}
   *    .providerDescription(String | null) // nullable {@link OAuth2Configuration#getProviderDescription() providerDescription}
   *    .authMethod(String | null) // nullable {@link OAuth2Configuration#getAuthMethod() authMethod}
   *    .attributeMappings(org.cloudfoundry.uaa.identityproviders.AttributeMappings | null) // nullable {@link OAuth2Configuration#getAttributeMappings() attributeMappings}
   *    .externalGroupsWhitelist(List&amp;lt;String&amp;gt; | null) // nullable {@link OAuth2Configuration#getExternalGroupsWhitelist() externalGroupsWhitelist}
   *    .storeCustomAttributes(Boolean | null) // nullable {@link OAuth2Configuration#getStoreCustomAttributes() storeCustomAttributes}
   *    .addShadowUserOnLogin(Boolean | null) // nullable {@link OAuth2Configuration#getAddShadowUserOnLogin() addShadowUserOnLogin}
   *    .authUrl(String) // required {@link OAuth2Configuration#getAuthUrl() authUrl}
   *    .linkText(Boolean | null) // nullable {@link OAuth2Configuration#getLinkText() linkText}
   *    .relyingPartyId(String) // required {@link OAuth2Configuration#getRelyingPartyId() relyingPartyId}
   *    .relyingPartySecret(String | null) // nullable {@link OAuth2Configuration#getRelyingPartySecret() relyingPartySecret}
   *    .scopes(List&amp;lt;String&amp;gt; | null) // nullable {@link OAuth2Configuration#getScopes() scopes}
   *    .showLinkText(Boolean | null) // nullable {@link OAuth2Configuration#getShowLinkText() showLinkText}
   *    .skipSslVerification(Boolean | null) // nullable {@link OAuth2Configuration#getSkipSslVerification() skipSslVerification}
   *    .tokenKey(String | null) // nullable {@link OAuth2Configuration#getTokenKey() tokenKey}
   *    .tokenKeyUrl(String | null) // nullable {@link OAuth2Configuration#getTokenKeyUrl() tokenKeyUrl}
   *    .tokenUrl(String) // required {@link OAuth2Configuration#getTokenUrl() tokenUrl}
   *    .checkTokenUrl(String | null) // nullable {@link OAuth2Configuration#getCheckTokenUrl() checkTokenUrl}
   *    .clientAuthInBody(Boolean | null) // nullable {@link OAuth2Configuration#getClientAuthInBody() clientAuthInBody}
   *    .issuer(String | null) // nullable {@link OAuth2Configuration#getIssuer() issuer}
   *    .responseType(String | null) // nullable {@link OAuth2Configuration#getResponseType() responseType}
   *    .userInfoUrl(String | null) // nullable {@link OAuth2Configuration#getUserInfoUrl() userInfoUrl}
   *    .userPropagationParameter(String | null) // nullable {@link OAuth2Configuration#getUserPropagationParameter() userPropagationParameter}
   *    .cacheJwks(Boolean | null) // nullable {@link OAuth2Configuration#getCacheJwks() cacheJwks}
   *    .pkce(Boolean | null) // nullable {@link OAuth2Configuration#getPkce() pkce}
   *    .logoutUrl(String | null) // nullable {@link OAuth2Configuration#getLogoutUrl() logoutUrl}
   *    .performRpInitiatedLogout(Boolean | null) // nullable {@link OAuth2Configuration#getPerformRpInitiatedLogout() performRpInitiatedLogout}
   *    .build();
   * </pre>
   * @return A new OAuth2Configuration builder
   */
  public static OAuth2Configuration.Builder builder() {
    return new OAuth2Configuration.Builder();
  }

  /**
   * Builds instances of type {@link OAuth2Configuration OAuth2Configuration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OAuth2Configuration", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AUTH_URL = 0x1L;
    private static final long INIT_BIT_RELYING_PARTY_ID = 0x2L;
    private static final long INIT_BIT_TOKEN_URL = 0x4L;
    private long initBits = 0x7L;

    private List<String> emailDomains = null;
    private String providerDescription;
    private String authMethod;
    private AttributeMappings attributeMappings;
    private List<String> externalGroupsWhitelist = null;
    private Boolean storeCustomAttributes;
    private Boolean addShadowUserOnLogin;
    private String authUrl;
    private Boolean linkText;
    private String relyingPartyId;
    private String relyingPartySecret;
    private List<String> scopes = null;
    private Boolean showLinkText;
    private Boolean skipSslVerification;
    private String tokenKey;
    private String tokenKeyUrl;
    private String tokenUrl;
    private String checkTokenUrl;
    private Boolean clientAuthInBody;
    private String issuer;
    private String responseType;
    private String userInfoUrl;
    private String userPropagationParameter;
    private Boolean cacheJwks;
    private Boolean pkce;
    private String logoutUrl;
    private Boolean performRpInitiatedLogout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OAuth2Configuration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OAuth2Configuration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _OAuth2Configuration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_OAuth2Configuration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractAuthenticationConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractAuthenticationConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractExternalIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractExternalIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof org.cloudfoundry.uaa.identityproviders._OAuth2Configuration) {
        org.cloudfoundry.uaa.identityproviders._OAuth2Configuration instance = (org.cloudfoundry.uaa.identityproviders._OAuth2Configuration) object;
        if ((bits & 0x1L) == 0) {
          Boolean showLinkTextValue = instance.getShowLinkText();
          if (showLinkTextValue != null) {
            showLinkText(showLinkTextValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String relyingPartySecretValue = instance.getRelyingPartySecret();
          if (relyingPartySecretValue != null) {
            relyingPartySecret(relyingPartySecretValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          this.tokenUrl(instance.getTokenUrl());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          this.relyingPartyId(instance.getRelyingPartyId());
          bits |= 0x10L;
        }
        String issuerValue = instance.getIssuer();
        if (issuerValue != null) {
          issuer(issuerValue);
        }
        Boolean clientAuthInBodyValue = instance.getClientAuthInBody();
        if (clientAuthInBodyValue != null) {
          clientAuthInBody(clientAuthInBodyValue);
        }
        if ((bits & 0x20L) == 0) {
          this.authUrl(instance.getAuthUrl());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          String tokenKeyValue = instance.getTokenKey();
          if (tokenKeyValue != null) {
            tokenKey(tokenKeyValue);
          }
          bits |= 0x40L;
        }
        String responseTypeValue = instance.getResponseType();
        if (responseTypeValue != null) {
          responseType(responseTypeValue);
        }
        if ((bits & 0x80L) == 0) {
          Boolean skipSslVerificationValue = instance.getSkipSslVerification();
          if (skipSslVerificationValue != null) {
            skipSslVerification(skipSslVerificationValue);
          }
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x100L;
        }
        String userInfoUrlValue = instance.getUserInfoUrl();
        if (userInfoUrlValue != null) {
          userInfoUrl(userInfoUrlValue);
        }
        if ((bits & 0x200L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x200L;
        }
        Boolean pkceValue = instance.getPkce();
        if (pkceValue != null) {
          pkce(pkceValue);
        }
        if ((bits & 0x400L) == 0) {
          Boolean linkTextValue = instance.getLinkText();
          if (linkTextValue != null) {
            linkText(linkTextValue);
          }
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x800L;
        }
        Boolean cacheJwksValue = instance.getCacheJwks();
        if (cacheJwksValue != null) {
          cacheJwks(cacheJwksValue);
        }
        if ((bits & 0x1000L) == 0) {
          Boolean addShadowUserOnLoginValue = instance.getAddShadowUserOnLogin();
          if (addShadowUserOnLoginValue != null) {
            addShadowUserOnLogin(addShadowUserOnLoginValue);
          }
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          String tokenKeyUrlValue = instance.getTokenKeyUrl();
          if (tokenKeyUrlValue != null) {
            tokenKeyUrl(tokenKeyUrlValue);
          }
          bits |= 0x2000L;
        }
        Boolean performRpInitiatedLogoutValue = instance.getPerformRpInitiatedLogout();
        if (performRpInitiatedLogoutValue != null) {
          performRpInitiatedLogout(performRpInitiatedLogoutValue);
        }
        String userPropagationParameterValue = instance.getUserPropagationParameter();
        if (userPropagationParameterValue != null) {
          userPropagationParameter(userPropagationParameterValue);
        }
        String logoutUrlValue = instance.getLogoutUrl();
        if (logoutUrlValue != null) {
          logoutUrl(logoutUrlValue);
        }
        if ((bits & 0x4000L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x4000L;
        }
        if ((bits & 0x8000L) == 0) {
          List<String> scopesValue = instance.getScopes();
          if (scopesValue != null) {
            addAllScopes(scopesValue);
          }
          bits |= 0x8000L;
        }
        if ((bits & 0x10000L) == 0) {
          String authMethodValue = instance.getAuthMethod();
          if (authMethodValue != null) {
            authMethod(authMethodValue);
          }
          bits |= 0x10000L;
        }
        String checkTokenUrlValue = instance.getCheckTokenUrl();
        if (checkTokenUrlValue != null) {
          checkTokenUrl(checkTokenUrlValue);
        }
      }
      if (object instanceof AbstractIdentityProviderConfiguration) {
        AbstractIdentityProviderConfiguration instance = (AbstractIdentityProviderConfiguration) object;
        if ((bits & 0x10000L) == 0) {
          String authMethodValue = instance.getAuthMethod();
          if (authMethodValue != null) {
            authMethod(authMethodValue);
          }
          bits |= 0x10000L;
        }
        if ((bits & 0x200L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x4000L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x4000L;
        }
      }
      if (object instanceof AbstractAuthenticationConfiguration) {
        AbstractAuthenticationConfiguration instance = (AbstractAuthenticationConfiguration) object;
        if ((bits & 0x100L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x100L;
        }
        if ((bits & 0x1L) == 0) {
          Boolean showLinkTextValue = instance.getShowLinkText();
          if (showLinkTextValue != null) {
            showLinkText(showLinkTextValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String relyingPartySecretValue = instance.getRelyingPartySecret();
          if (relyingPartySecretValue != null) {
            relyingPartySecret(relyingPartySecretValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          this.tokenUrl(instance.getTokenUrl());
          bits |= 0x8L;
        }
        if ((bits & 0x200L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x10L) == 0) {
          this.relyingPartyId(instance.getRelyingPartyId());
          bits |= 0x10L;
        }
        if ((bits & 0x400L) == 0) {
          Boolean linkTextValue = instance.getLinkText();
          if (linkTextValue != null) {
            linkText(linkTextValue);
          }
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          Boolean addShadowUserOnLoginValue = instance.getAddShadowUserOnLogin();
          if (addShadowUserOnLoginValue != null) {
            addShadowUserOnLogin(addShadowUserOnLoginValue);
          }
          bits |= 0x1000L;
        }
        if ((bits & 0x20L) == 0) {
          this.authUrl(instance.getAuthUrl());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          String tokenKeyValue = instance.getTokenKey();
          if (tokenKeyValue != null) {
            tokenKey(tokenKeyValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x2000L) == 0) {
          String tokenKeyUrlValue = instance.getTokenKeyUrl();
          if (tokenKeyUrlValue != null) {
            tokenKeyUrl(tokenKeyUrlValue);
          }
          bits |= 0x2000L;
        }
        if ((bits & 0x80L) == 0) {
          Boolean skipSslVerificationValue = instance.getSkipSslVerification();
          if (skipSslVerificationValue != null) {
            skipSslVerification(skipSslVerificationValue);
          }
          bits |= 0x80L;
        }
        if ((bits & 0x4000L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x4000L;
        }
        if ((bits & 0x8000L) == 0) {
          List<String> scopesValue = instance.getScopes();
          if (scopesValue != null) {
            addAllScopes(scopesValue);
          }
          bits |= 0x8000L;
        }
        if ((bits & 0x10000L) == 0) {
          String authMethodValue = instance.getAuthMethod();
          if (authMethodValue != null) {
            authMethod(authMethodValue);
          }
          bits |= 0x10000L;
        }
      }
      if (object instanceof AbstractExternalIdentityProviderConfiguration) {
        AbstractExternalIdentityProviderConfiguration instance = (AbstractExternalIdentityProviderConfiguration) object;
        if ((bits & 0x100L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x4000L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x4000L;
        }
        if ((bits & 0x2L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x800L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x800L;
        }
        if ((bits & 0x10000L) == 0) {
          String authMethodValue = instance.getAuthMethod();
          if (authMethodValue != null) {
            authMethod(authMethodValue);
          }
          bits |= 0x10000L;
        }
      }
    }

    /**
     * Adds one element to {@link OAuth2Configuration#getEmailDomains() emailDomains} list.
     * @param element A emailDomains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String element) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      return this;
    }

    /**
     * Adds elements to {@link OAuth2Configuration#getEmailDomains() emailDomains} list.
     * @param elements An array of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomains(String... elements) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OAuth2Configuration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("emailDomain")
    public final Builder emailDomains(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.emailDomains = null;
        return this;
      }
      this.emailDomains = new ArrayList<String>();
      return addAllEmailDomains(elements);
    }

    /**
     * Adds elements to {@link OAuth2Configuration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmailDomains(Iterable<String> elements) {
      Objects.requireNonNull(elements, "emailDomains element");
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getProviderDescription() providerDescription} attribute.
     * @param providerDescription The value for providerDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("providerDescription")
    public final Builder providerDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getAuthMethod() authMethod} attribute.
     * @param authMethod The value for authMethod (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authMethod")
    public final Builder authMethod(@Nullable String authMethod) {
      this.authMethod = authMethod;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getAttributeMappings() attributeMappings} attribute.
     * @param attributeMappings The value for attributeMappings (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("attributeMappings")
    public final Builder attributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
      return this;
    }

    /**
     * Adds one element to {@link OAuth2Configuration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param element A externalGroupsWhitelist element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String element) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      return this;
    }

    /**
     * Adds elements to {@link OAuth2Configuration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An array of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String... elements) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OAuth2Configuration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("externalGroupsWhitelist")
    public final Builder externalGroupsWhitelist(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.externalGroupsWhitelist = null;
        return this;
      }
      this.externalGroupsWhitelist = new ArrayList<String>();
      return addAllExternalGroupsWhitelist(elements);
    }

    /**
     * Adds elements to {@link OAuth2Configuration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExternalGroupsWhitelist(Iterable<String> elements) {
      Objects.requireNonNull(elements, "externalGroupsWhitelist element");
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getStoreCustomAttributes() storeCustomAttributes} attribute.
     * @param storeCustomAttributes The value for storeCustomAttributes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("storeCustomAttributes")
    public final Builder storeCustomAttributes(@Nullable Boolean storeCustomAttributes) {
      this.storeCustomAttributes = storeCustomAttributes;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getAddShadowUserOnLogin() addShadowUserOnLogin} attribute.
     * @param addShadowUserOnLogin The value for addShadowUserOnLogin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("addShadowUserOnLogin")
    public final Builder addShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getAuthUrl() authUrl} attribute.
     * @param authUrl The value for authUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authUrl")
    public final Builder authUrl(String authUrl) {
      this.authUrl = Objects.requireNonNull(authUrl, "authUrl");
      initBits &= ~INIT_BIT_AUTH_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getLinkText() linkText} attribute.
     * @param linkText The value for linkText (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("linkText")
    public final Builder linkText(@Nullable Boolean linkText) {
      this.linkText = linkText;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getRelyingPartyId() relyingPartyId} attribute.
     * @param relyingPartyId The value for relyingPartyId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relyingPartyId")
    public final Builder relyingPartyId(String relyingPartyId) {
      this.relyingPartyId = Objects.requireNonNull(relyingPartyId, "relyingPartyId");
      initBits &= ~INIT_BIT_RELYING_PARTY_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getRelyingPartySecret() relyingPartySecret} attribute.
     * @param relyingPartySecret The value for relyingPartySecret (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relyingPartySecret")
    public final Builder relyingPartySecret(@Nullable String relyingPartySecret) {
      this.relyingPartySecret = relyingPartySecret;
      return this;
    }

    /**
     * Adds one element to {@link OAuth2Configuration#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String element) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link OAuth2Configuration#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(String... elements) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OAuth2Configuration#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scopes")
    public final Builder scopes(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.scopes = null;
        return this;
      }
      this.scopes = new ArrayList<String>();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link OAuth2Configuration#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "scopes element");
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getShowLinkText() showLinkText} attribute.
     * @param showLinkText The value for showLinkText (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("showLinkText")
    public final Builder showLinkText(@Nullable Boolean showLinkText) {
      this.showLinkText = showLinkText;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getSkipSslVerification() skipSslVerification} attribute.
     * @param skipSslVerification The value for skipSslVerification (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("skipSslValidation")
    public final Builder skipSslVerification(@Nullable Boolean skipSslVerification) {
      this.skipSslVerification = skipSslVerification;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getTokenKey() tokenKey} attribute.
     * @param tokenKey The value for tokenKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tokenKey")
    public final Builder tokenKey(@Nullable String tokenKey) {
      this.tokenKey = tokenKey;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getTokenKeyUrl() tokenKeyUrl} attribute.
     * @param tokenKeyUrl The value for tokenKeyUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tokenKeyUrl")
    public final Builder tokenKeyUrl(@Nullable String tokenKeyUrl) {
      this.tokenKeyUrl = tokenKeyUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getTokenUrl() tokenUrl} attribute.
     * @param tokenUrl The value for tokenUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tokenUrl")
    public final Builder tokenUrl(String tokenUrl) {
      this.tokenUrl = Objects.requireNonNull(tokenUrl, "tokenUrl");
      initBits &= ~INIT_BIT_TOKEN_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getCheckTokenUrl() checkTokenUrl} attribute.
     * @param checkTokenUrl The value for checkTokenUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("checkTokenUrl")
    public final Builder checkTokenUrl(@Nullable String checkTokenUrl) {
      this.checkTokenUrl = checkTokenUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getClientAuthInBody() clientAuthInBody} attribute.
     * @param clientAuthInBody The value for clientAuthInBody (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("clientAuthInBody")
    public final Builder clientAuthInBody(@Nullable Boolean clientAuthInBody) {
      this.clientAuthInBody = clientAuthInBody;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getIssuer() issuer} attribute.
     * @param issuer The value for issuer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("issuer")
    public final Builder issuer(@Nullable String issuer) {
      this.issuer = issuer;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getResponseType() responseType} attribute.
     * @param responseType The value for responseType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("responseType")
    public final Builder responseType(@Nullable String responseType) {
      this.responseType = responseType;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getUserInfoUrl() userInfoUrl} attribute.
     * @param userInfoUrl The value for userInfoUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userInfoUrl")
    public final Builder userInfoUrl(@Nullable String userInfoUrl) {
      this.userInfoUrl = userInfoUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getUserPropagationParameter() userPropagationParameter} attribute.
     * @param userPropagationParameter The value for userPropagationParameter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userPropagationParameter")
    public final Builder userPropagationParameter(@Nullable String userPropagationParameter) {
      this.userPropagationParameter = userPropagationParameter;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getCacheJwks() cacheJwks} attribute.
     * @param cacheJwks The value for cacheJwks (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cacheJwks")
    public final Builder cacheJwks(@Nullable Boolean cacheJwks) {
      this.cacheJwks = cacheJwks;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getPkce() pkce} attribute.
     * @param pkce The value for pkce (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("pkce")
    public final Builder pkce(@Nullable Boolean pkce) {
      this.pkce = pkce;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getLogoutUrl() logoutUrl} attribute.
     * @param logoutUrl The value for logoutUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("logoutUrl")
    public final Builder logoutUrl(@Nullable String logoutUrl) {
      this.logoutUrl = logoutUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OAuth2Configuration#getPerformRpInitiatedLogout() performRpInitiatedLogout} attribute.
     * @param performRpInitiatedLogout The value for performRpInitiatedLogout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("performRpInitiatedLogout")
    public final Builder performRpInitiatedLogout(@Nullable Boolean performRpInitiatedLogout) {
      this.performRpInitiatedLogout = performRpInitiatedLogout;
      return this;
    }

    /**
     * Builds a new {@link OAuth2Configuration OAuth2Configuration}.
     * @return An immutable instance of OAuth2Configuration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OAuth2Configuration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OAuth2Configuration(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUTH_URL) != 0) attributes.add("authUrl");
      if ((initBits & INIT_BIT_RELYING_PARTY_ID) != 0) attributes.add("relyingPartyId");
      if ((initBits & INIT_BIT_TOKEN_URL) != 0) attributes.add("tokenUrl");
      return "Cannot build OAuth2Configuration, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
