package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The payload for the CORS policy configuration
 */
@Generated(from = "_CorsConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CorsConfiguration extends org.cloudfoundry.uaa.identityzones._CorsConfiguration {
  private final Boolean allowedCredentials;
  private final List<String> allowedHeaders;
  private final List<String> allowedMethods;
  private final List<String> allowedOriginPatterns;
  private final List<String> allowedOrigins;
  private final List<String> allowedUriPatterns;
  private final List<String> allowedUris;
  private final Long maxAge;

  private CorsConfiguration(CorsConfiguration.Builder builder) {
    this.allowedCredentials = builder.allowedCredentials;
    this.allowedHeaders = createUnmodifiableList(true, builder.allowedHeaders);
    this.allowedMethods = createUnmodifiableList(true, builder.allowedMethods);
    this.allowedOriginPatterns = createUnmodifiableList(true, builder.allowedOriginPatterns);
    this.allowedOrigins = createUnmodifiableList(true, builder.allowedOrigins);
    this.allowedUriPatterns = createUnmodifiableList(true, builder.allowedUriPatterns);
    this.allowedUris = createUnmodifiableList(true, builder.allowedUris);
    this.maxAge = builder.maxAge;
  }

  /**
   * Access-Control-Allow-Credentials header. Indicates whether the response to request can be exposed when the omit credentials flag is unset. When part of the response to a preflight request it
   * indicates that the actual request can include user credentials.
   */
  @JsonProperty("allowedCredentials")
  @Override
  public Boolean getAllowedCredentials() {
    return allowedCredentials;
  }

  /**
   * Access-Control-Allow-Headers header. Indicates which header field names can be used during the actual response
   */
  @JsonProperty("allowedHeaders")
  @Override
  public List<String> getAllowedHeaders() {
    return allowedHeaders;
  }

  /**
   * Access-Control-Allow-Methods header. Indicates which method will be used in the actual request as part of the preflight request.
   */
  @JsonProperty("allowedMethods")
  @Override
  public List<String> getAllowedMethods() {
    return allowedMethods;
  }

  /**
   * Indicates whether a resource can be shared based by returning the value of the Origin patterns.
   */
  @JsonProperty("allowedOriginPatterns")
  @Override
  public List<String> getAllowedOriginPatterns() {
    return allowedOriginPatterns;
  }

  /**
   * Access-Control-Allow-Origin header. Indicates whether a resource can be shared based by returning the value of the Origin request header, “*”, or “null” in the response.
   */
  @JsonProperty("allowedOrigins")
  @Override
  public List<String> getAllowedOrigins() {
    return allowedOrigins;
  }

  /**
   * The list of allowed URI patterns.
   */
  @JsonProperty("allowedUriPatterns")
  @Override
  public List<String> getAllowedUriPatterns() {
    return allowedUriPatterns;
  }

  /**
   * The list of allowed URIs.
   */
  @JsonProperty("allowedUris")
  @Override
  public List<String> getAllowedUris() {
    return allowedUris;
  }

  /**
   * Access-Control-Max-Age header. Indicates how long the results of a preflight request can be cached in a preflight result cache
   */
  @JsonProperty("maxAge")
  @Override
  public Long getMaxAge() {
    return maxAge;
  }

  /**
   * This instance is equal to all instances of {@code CorsConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CorsConfiguration
        && equalTo(0, (CorsConfiguration) another);
  }

  private boolean equalTo(int synthetic, CorsConfiguration another) {
    return allowedCredentials.equals(another.allowedCredentials)
        && allowedHeaders.equals(another.allowedHeaders)
        && allowedMethods.equals(another.allowedMethods)
        && allowedOriginPatterns.equals(another.allowedOriginPatterns)
        && allowedOrigins.equals(another.allowedOrigins)
        && allowedUriPatterns.equals(another.allowedUriPatterns)
        && allowedUris.equals(another.allowedUris)
        && maxAge.equals(another.maxAge);
  }

  /**
   * Computes a hash code from attributes: {@code allowedCredentials}, {@code allowedHeaders}, {@code allowedMethods}, {@code allowedOriginPatterns}, {@code allowedOrigins}, {@code allowedUriPatterns}, {@code allowedUris}, {@code maxAge}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + allowedCredentials.hashCode();
    h += (h << 5) + allowedHeaders.hashCode();
    h += (h << 5) + allowedMethods.hashCode();
    h += (h << 5) + allowedOriginPatterns.hashCode();
    h += (h << 5) + allowedOrigins.hashCode();
    h += (h << 5) + allowedUriPatterns.hashCode();
    h += (h << 5) + allowedUris.hashCode();
    h += (h << 5) + maxAge.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CorsConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CorsConfiguration{"
        + "allowedCredentials=" + allowedCredentials
        + ", allowedHeaders=" + allowedHeaders
        + ", allowedMethods=" + allowedMethods
        + ", allowedOriginPatterns=" + allowedOriginPatterns
        + ", allowedOrigins=" + allowedOrigins
        + ", allowedUriPatterns=" + allowedUriPatterns
        + ", allowedUris=" + allowedUris
        + ", maxAge=" + maxAge
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CorsConfiguration", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._CorsConfiguration {
    Boolean allowedCredentials;
    List<String> allowedHeaders = Collections.emptyList();
    List<String> allowedMethods = Collections.emptyList();
    List<String> allowedOriginPatterns = Collections.emptyList();
    List<String> allowedOrigins = Collections.emptyList();
    List<String> allowedUriPatterns = Collections.emptyList();
    List<String> allowedUris = Collections.emptyList();
    Long maxAge;
    @JsonProperty("allowedCredentials")
    public void setAllowedCredentials(Boolean allowedCredentials) {
      this.allowedCredentials = allowedCredentials;
    }
    @JsonProperty("allowedHeaders")
    public void setAllowedHeaders(List<String> allowedHeaders) {
      this.allowedHeaders = allowedHeaders;
    }
    @JsonProperty("allowedMethods")
    public void setAllowedMethods(List<String> allowedMethods) {
      this.allowedMethods = allowedMethods;
    }
    @JsonProperty("allowedOriginPatterns")
    public void setAllowedOriginPatterns(List<String> allowedOriginPatterns) {
      this.allowedOriginPatterns = allowedOriginPatterns;
    }
    @JsonProperty("allowedOrigins")
    public void setAllowedOrigins(List<String> allowedOrigins) {
      this.allowedOrigins = allowedOrigins;
    }
    @JsonProperty("allowedUriPatterns")
    public void setAllowedUriPatterns(List<String> allowedUriPatterns) {
      this.allowedUriPatterns = allowedUriPatterns;
    }
    @JsonProperty("allowedUris")
    public void setAllowedUris(List<String> allowedUris) {
      this.allowedUris = allowedUris;
    }
    @JsonProperty("maxAge")
    public void setMaxAge(Long maxAge) {
      this.maxAge = maxAge;
    }
    @Override
    public Boolean getAllowedCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAllowedHeaders() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAllowedMethods() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAllowedOriginPatterns() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAllowedOrigins() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAllowedUriPatterns() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAllowedUris() { throw new UnsupportedOperationException(); }
    @Override
    public Long getMaxAge() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CorsConfiguration fromJson(Json json) {
    CorsConfiguration.Builder builder = CorsConfiguration.builder();
    if (json.allowedCredentials != null) {
      builder.allowedCredentials(json.allowedCredentials);
    }
    if (json.allowedHeaders != null) {
      builder.addAllAllowedHeaders(json.allowedHeaders);
    }
    if (json.allowedMethods != null) {
      builder.addAllAllowedMethods(json.allowedMethods);
    }
    if (json.allowedOriginPatterns != null) {
      builder.addAllAllowedOriginPatterns(json.allowedOriginPatterns);
    }
    if (json.allowedOrigins != null) {
      builder.addAllAllowedOrigins(json.allowedOrigins);
    }
    if (json.allowedUriPatterns != null) {
      builder.addAllAllowedUriPatterns(json.allowedUriPatterns);
    }
    if (json.allowedUris != null) {
      builder.addAllAllowedUris(json.allowedUris);
    }
    if (json.maxAge != null) {
      builder.maxAge(json.maxAge);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CorsConfiguration CorsConfiguration}.
   * <pre>
   * CorsConfiguration.builder()
   *    .allowedCredentials(Boolean) // required {@link CorsConfiguration#getAllowedCredentials() allowedCredentials}
   *    .allowedHeader|addAllAllowedHeaders(String) // {@link CorsConfiguration#getAllowedHeaders() allowedHeaders} elements
   *    .allowedMethod|addAllAllowedMethods(String) // {@link CorsConfiguration#getAllowedMethods() allowedMethods} elements
   *    .allowedOriginPattern|addAllAllowedOriginPatterns(String) // {@link CorsConfiguration#getAllowedOriginPatterns() allowedOriginPatterns} elements
   *    .allowedOrigin|addAllAllowedOrigins(String) // {@link CorsConfiguration#getAllowedOrigins() allowedOrigins} elements
   *    .allowedUriPattern|addAllAllowedUriPatterns(String) // {@link CorsConfiguration#getAllowedUriPatterns() allowedUriPatterns} elements
   *    .allowedUri|addAllAllowedUris(String) // {@link CorsConfiguration#getAllowedUris() allowedUris} elements
   *    .maxAge(Long) // required {@link CorsConfiguration#getMaxAge() maxAge}
   *    .build();
   * </pre>
   * @return A new CorsConfiguration builder
   */
  public static CorsConfiguration.Builder builder() {
    return new CorsConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link CorsConfiguration CorsConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CorsConfiguration", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ALLOWED_CREDENTIALS = 0x1L;
    private static final long INIT_BIT_MAX_AGE = 0x2L;
    private long initBits = 0x3L;

    private Boolean allowedCredentials;
    private List<String> allowedHeaders = new ArrayList<String>();
    private List<String> allowedMethods = new ArrayList<String>();
    private List<String> allowedOriginPatterns = new ArrayList<String>();
    private List<String> allowedOrigins = new ArrayList<String>();
    private List<String> allowedUriPatterns = new ArrayList<String>();
    private List<String> allowedUris = new ArrayList<String>();
    private Long maxAge;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CorsConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CorsConfiguration instance) {
      return from((_CorsConfiguration) instance);
    }

    /**
     * Copy abstract value type {@code _CorsConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CorsConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      this.allowedCredentials(instance.getAllowedCredentials());
      addAllAllowedHeaders(instance.getAllowedHeaders());
      addAllAllowedMethods(instance.getAllowedMethods());
      addAllAllowedOriginPatterns(instance.getAllowedOriginPatterns());
      addAllAllowedOrigins(instance.getAllowedOrigins());
      addAllAllowedUriPatterns(instance.getAllowedUriPatterns());
      addAllAllowedUris(instance.getAllowedUris());
      this.maxAge(instance.getMaxAge());
      return this;
    }

    /**
     * Initializes the value for the {@link CorsConfiguration#getAllowedCredentials() allowedCredentials} attribute.
     * @param allowedCredentials The value for allowedCredentials 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedCredentials")
    public final Builder allowedCredentials(Boolean allowedCredentials) {
      this.allowedCredentials = Objects.requireNonNull(allowedCredentials, "allowedCredentials");
      initBits &= ~INIT_BIT_ALLOWED_CREDENTIALS;
      return this;
    }

    /**
     * Adds one element to {@link CorsConfiguration#getAllowedHeaders() allowedHeaders} list.
     * @param element A allowedHeaders element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedHeader(String element) {
      this.allowedHeaders.add(Objects.requireNonNull(element, "allowedHeaders element"));
      return this;
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedHeaders() allowedHeaders} list.
     * @param elements An array of allowedHeaders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedHeaders(String... elements) {
      for (String element : elements) {
        this.allowedHeaders.add(Objects.requireNonNull(element, "allowedHeaders element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CorsConfiguration#getAllowedHeaders() allowedHeaders} list.
     * @param elements An iterable of allowedHeaders elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedHeaders")
    public final Builder allowedHeaders(Iterable<String> elements) {
      this.allowedHeaders.clear();
      return addAllAllowedHeaders(elements);
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedHeaders() allowedHeaders} list.
     * @param elements An iterable of allowedHeaders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedHeaders(Iterable<String> elements) {
      for (String element : elements) {
        this.allowedHeaders.add(Objects.requireNonNull(element, "allowedHeaders element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CorsConfiguration#getAllowedMethods() allowedMethods} list.
     * @param element A allowedMethods element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedMethod(String element) {
      this.allowedMethods.add(Objects.requireNonNull(element, "allowedMethods element"));
      return this;
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedMethods() allowedMethods} list.
     * @param elements An array of allowedMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedMethods(String... elements) {
      for (String element : elements) {
        this.allowedMethods.add(Objects.requireNonNull(element, "allowedMethods element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CorsConfiguration#getAllowedMethods() allowedMethods} list.
     * @param elements An iterable of allowedMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedMethods")
    public final Builder allowedMethods(Iterable<String> elements) {
      this.allowedMethods.clear();
      return addAllAllowedMethods(elements);
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedMethods() allowedMethods} list.
     * @param elements An iterable of allowedMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedMethods(Iterable<String> elements) {
      for (String element : elements) {
        this.allowedMethods.add(Objects.requireNonNull(element, "allowedMethods element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CorsConfiguration#getAllowedOriginPatterns() allowedOriginPatterns} list.
     * @param element A allowedOriginPatterns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedOriginPattern(String element) {
      this.allowedOriginPatterns.add(Objects.requireNonNull(element, "allowedOriginPatterns element"));
      return this;
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedOriginPatterns() allowedOriginPatterns} list.
     * @param elements An array of allowedOriginPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedOriginPatterns(String... elements) {
      for (String element : elements) {
        this.allowedOriginPatterns.add(Objects.requireNonNull(element, "allowedOriginPatterns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CorsConfiguration#getAllowedOriginPatterns() allowedOriginPatterns} list.
     * @param elements An iterable of allowedOriginPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedOriginPatterns")
    public final Builder allowedOriginPatterns(Iterable<String> elements) {
      this.allowedOriginPatterns.clear();
      return addAllAllowedOriginPatterns(elements);
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedOriginPatterns() allowedOriginPatterns} list.
     * @param elements An iterable of allowedOriginPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedOriginPatterns(Iterable<String> elements) {
      for (String element : elements) {
        this.allowedOriginPatterns.add(Objects.requireNonNull(element, "allowedOriginPatterns element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CorsConfiguration#getAllowedOrigins() allowedOrigins} list.
     * @param element A allowedOrigins element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedOrigin(String element) {
      this.allowedOrigins.add(Objects.requireNonNull(element, "allowedOrigins element"));
      return this;
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedOrigins() allowedOrigins} list.
     * @param elements An array of allowedOrigins elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedOrigins(String... elements) {
      for (String element : elements) {
        this.allowedOrigins.add(Objects.requireNonNull(element, "allowedOrigins element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CorsConfiguration#getAllowedOrigins() allowedOrigins} list.
     * @param elements An iterable of allowedOrigins elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedOrigins")
    public final Builder allowedOrigins(Iterable<String> elements) {
      this.allowedOrigins.clear();
      return addAllAllowedOrigins(elements);
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedOrigins() allowedOrigins} list.
     * @param elements An iterable of allowedOrigins elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedOrigins(Iterable<String> elements) {
      for (String element : elements) {
        this.allowedOrigins.add(Objects.requireNonNull(element, "allowedOrigins element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CorsConfiguration#getAllowedUriPatterns() allowedUriPatterns} list.
     * @param element A allowedUriPatterns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedUriPattern(String element) {
      this.allowedUriPatterns.add(Objects.requireNonNull(element, "allowedUriPatterns element"));
      return this;
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedUriPatterns() allowedUriPatterns} list.
     * @param elements An array of allowedUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedUriPatterns(String... elements) {
      for (String element : elements) {
        this.allowedUriPatterns.add(Objects.requireNonNull(element, "allowedUriPatterns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CorsConfiguration#getAllowedUriPatterns() allowedUriPatterns} list.
     * @param elements An iterable of allowedUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedUriPatterns")
    public final Builder allowedUriPatterns(Iterable<String> elements) {
      this.allowedUriPatterns.clear();
      return addAllAllowedUriPatterns(elements);
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedUriPatterns() allowedUriPatterns} list.
     * @param elements An iterable of allowedUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedUriPatterns(Iterable<String> elements) {
      for (String element : elements) {
        this.allowedUriPatterns.add(Objects.requireNonNull(element, "allowedUriPatterns element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CorsConfiguration#getAllowedUris() allowedUris} list.
     * @param element A allowedUris element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedUri(String element) {
      this.allowedUris.add(Objects.requireNonNull(element, "allowedUris element"));
      return this;
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedUris() allowedUris} list.
     * @param elements An array of allowedUris elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedUris(String... elements) {
      for (String element : elements) {
        this.allowedUris.add(Objects.requireNonNull(element, "allowedUris element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CorsConfiguration#getAllowedUris() allowedUris} list.
     * @param elements An iterable of allowedUris elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedUris")
    public final Builder allowedUris(Iterable<String> elements) {
      this.allowedUris.clear();
      return addAllAllowedUris(elements);
    }

    /**
     * Adds elements to {@link CorsConfiguration#getAllowedUris() allowedUris} list.
     * @param elements An iterable of allowedUris elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedUris(Iterable<String> elements) {
      for (String element : elements) {
        this.allowedUris.add(Objects.requireNonNull(element, "allowedUris element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CorsConfiguration#getMaxAge() maxAge} attribute.
     * @param maxAge The value for maxAge 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maxAge")
    public final Builder maxAge(Long maxAge) {
      this.maxAge = Objects.requireNonNull(maxAge, "maxAge");
      initBits &= ~INIT_BIT_MAX_AGE;
      return this;
    }

    /**
     * Builds a new {@link CorsConfiguration CorsConfiguration}.
     * @return An immutable instance of CorsConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CorsConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CorsConfiguration(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ALLOWED_CREDENTIALS) != 0) attributes.add("allowedCredentials");
      if ((initBits & INIT_BIT_MAX_AGE) != 0) attributes.add("maxAge");
      return "Cannot build CorsConfiguration, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
