package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the create identity zone operation
 */
@Generated(from = "_CreateIdentityZoneRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateIdentityZoneRequest
    extends org.cloudfoundry.uaa.identityzones._CreateIdentityZoneRequest {
  private final @Nullable IdentityZoneConfiguration configuration;
  private final @Nullable Long createdAt;
  private final @Nullable String description;
  private final @Nullable String identityZoneId;
  private final @Nullable Long lastModified;
  private final String name;
  private final String subdomain;
  private final @Nullable Integer version;
  private final @Nullable Boolean active;

  private CreateIdentityZoneRequest(CreateIdentityZoneRequest.Builder builder) {
    this.configuration = builder.configuration;
    this.createdAt = builder.createdAt;
    this.description = builder.description;
    this.identityZoneId = builder.identityZoneId;
    this.lastModified = builder.lastModified;
    this.name = builder.name;
    this.subdomain = builder.subdomain;
    this.version = builder.version;
    this.active = builder.active;
  }

  /**
   * The configuration
   */
  @JsonProperty("config")
  @Override
  public @Nullable IdentityZoneConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * The creation date of the identity zone
   */
  @JsonProperty("created")
  @Override
  public @Nullable Long getCreatedAt() {
    return createdAt;
  }

  /**
   * The description of the identity zone
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The id of the identity zone. When not provided, an identifier will be generated
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * The last modification date of the identity zone
   */
  @JsonProperty("last_modified")
  @Override
  public @Nullable Long getLastModified() {
    return lastModified;
  }

  /**
   * The name of the identity zone
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The unique subdomain. It will be converted into lowercase upon creation.
   */
  @JsonProperty("subdomain")
  @Override
  public String getSubdomain() {
    return subdomain;
  }

  /**
   * The version of the identity zone
   */
  @JsonProperty("version")
  @Override
  public @Nullable Integer getVersion() {
    return version;
  }

  /**
   * Whether the identity zone is active
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * This instance is equal to all instances of {@code CreateIdentityZoneRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateIdentityZoneRequest
        && equalTo(0, (CreateIdentityZoneRequest) another);
  }

  private boolean equalTo(int synthetic, CreateIdentityZoneRequest another) {
    return Objects.equals(configuration, another.configuration)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(description, another.description)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(lastModified, another.lastModified)
        && name.equals(another.name)
        && subdomain.equals(another.subdomain)
        && Objects.equals(version, another.version)
        && Objects.equals(active, another.active);
  }

  /**
   * Computes a hash code from attributes: {@code configuration}, {@code createdAt}, {@code description}, {@code identityZoneId}, {@code lastModified}, {@code name}, {@code subdomain}, {@code version}, {@code active}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(configuration);
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(lastModified);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + subdomain.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(active);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateIdentityZoneRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateIdentityZoneRequest{"
        + "configuration=" + configuration
        + ", createdAt=" + createdAt
        + ", description=" + description
        + ", identityZoneId=" + identityZoneId
        + ", lastModified=" + lastModified
        + ", name=" + name
        + ", subdomain=" + subdomain
        + ", version=" + version
        + ", active=" + active
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateIdentityZoneRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._CreateIdentityZoneRequest {
    IdentityZoneConfiguration configuration;
    Long createdAt;
    String description;
    String identityZoneId;
    Long lastModified;
    String name;
    String subdomain;
    Integer version;
    Boolean active;
    @JsonProperty("config")
    public void setConfiguration(@Nullable IdentityZoneConfiguration configuration) {
      this.configuration = configuration;
    }
    @JsonProperty("created")
    public void setCreatedAt(@Nullable Long createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("id")
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("last_modified")
    public void setLastModified(@Nullable Long lastModified) {
      this.lastModified = lastModified;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("subdomain")
    public void setSubdomain(String subdomain) {
      this.subdomain = subdomain;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable Integer version) {
      this.version = version;
    }
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @Override
    public IdentityZoneConfiguration getConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public Long getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateIdentityZoneRequest fromJson(Json json) {
    CreateIdentityZoneRequest.Builder builder = CreateIdentityZoneRequest.builder();
    if (json.configuration != null) {
      builder.configuration(json.configuration);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.lastModified != null) {
      builder.lastModified(json.lastModified);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.subdomain != null) {
      builder.subdomain(json.subdomain);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.active != null) {
      builder.active(json.active);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateIdentityZoneRequest CreateIdentityZoneRequest}.
   * <pre>
   * CreateIdentityZoneRequest.builder()
   *    .configuration(org.cloudfoundry.uaa.identityzones.IdentityZoneConfiguration | null) // nullable {@link CreateIdentityZoneRequest#getConfiguration() configuration}
   *    .createdAt(Long | null) // nullable {@link CreateIdentityZoneRequest#getCreatedAt() createdAt}
   *    .description(String | null) // nullable {@link CreateIdentityZoneRequest#getDescription() description}
   *    .identityZoneId(String | null) // nullable {@link CreateIdentityZoneRequest#getIdentityZoneId() identityZoneId}
   *    .lastModified(Long | null) // nullable {@link CreateIdentityZoneRequest#getLastModified() lastModified}
   *    .name(String) // required {@link CreateIdentityZoneRequest#getName() name}
   *    .subdomain(String) // required {@link CreateIdentityZoneRequest#getSubdomain() subdomain}
   *    .version(Integer | null) // nullable {@link CreateIdentityZoneRequest#getVersion() version}
   *    .active(Boolean | null) // nullable {@link CreateIdentityZoneRequest#getActive() active}
   *    .build();
   * </pre>
   * @return A new CreateIdentityZoneRequest builder
   */
  public static CreateIdentityZoneRequest.Builder builder() {
    return new CreateIdentityZoneRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateIdentityZoneRequest CreateIdentityZoneRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateIdentityZoneRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SUBDOMAIN = 0x2L;
    private long initBits = 0x3L;

    private IdentityZoneConfiguration configuration;
    private Long createdAt;
    private String description;
    private String identityZoneId;
    private Long lastModified;
    private String name;
    private String subdomain;
    private Integer version;
    private Boolean active;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateIdentityZoneRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateIdentityZoneRequest instance) {
      return from((_CreateIdentityZoneRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateIdentityZoneRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateIdentityZoneRequest instance) {
      Objects.requireNonNull(instance, "instance");
      IdentityZoneConfiguration configurationValue = instance.getConfiguration();
      if (configurationValue != null) {
        configuration(configurationValue);
      }
      Long createdAtValue = instance.getCreatedAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String identityZoneIdValue = instance.getIdentityZoneId();
      if (identityZoneIdValue != null) {
        identityZoneId(identityZoneIdValue);
      }
      Long lastModifiedValue = instance.getLastModified();
      if (lastModifiedValue != null) {
        lastModified(lastModifiedValue);
      }
      this.name(instance.getName());
      this.subdomain(instance.getSubdomain());
      Integer versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      Boolean activeValue = instance.getActive();
      if (activeValue != null) {
        active(activeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityZoneRequest#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configuration(@Nullable IdentityZoneConfiguration configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityZoneRequest#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createdAt(@Nullable Long createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityZoneRequest#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityZoneRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityZoneRequest#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lastModified(@Nullable Long lastModified) {
      this.lastModified = lastModified;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityZoneRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityZoneRequest#getSubdomain() subdomain} attribute.
     * @param subdomain The value for subdomain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subdomain(String subdomain) {
      this.subdomain = Objects.requireNonNull(subdomain, "subdomain");
      initBits &= ~INIT_BIT_SUBDOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityZoneRequest#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@Nullable Integer version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateIdentityZoneRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Builds a new {@link CreateIdentityZoneRequest CreateIdentityZoneRequest}.
     * @return An immutable instance of CreateIdentityZoneRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateIdentityZoneRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateIdentityZoneRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SUBDOMAIN) != 0) attributes.add("subdomain");
      return "Cannot build CreateIdentityZoneRequest, some of required attributes are not set " + attributes;
    }
  }
}
