package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for the identity zone user configuration
 */
@Generated(from = "_UserConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UserConfig extends org.cloudfoundry.uaa.identityzones._UserConfig {
  private final @Nullable List<String> defaultGroups;
  private final @Nullable List<String> allowedGroups;
  private final @Nullable Integer maxUsers;
  private final @Nullable Boolean getcheckOriginEnabled;
  private final @Nullable Boolean allowOriginLoop;

  private UserConfig(UserConfig.Builder builder) {
    this.defaultGroups = builder.defaultGroups == null ? null : createUnmodifiableList(true, builder.defaultGroups);
    this.allowedGroups = builder.allowedGroups == null ? null : createUnmodifiableList(true, builder.allowedGroups);
    this.maxUsers = builder.maxUsers;
    this.getcheckOriginEnabled = builder.getcheckOriginEnabled;
    this.allowOriginLoop = builder.allowOriginLoop;
  }

  /**
   * The default groups
   */
  @JsonProperty("defaultGroups")
  @Override
  public @Nullable List<String> getDefaultGroups() {
    return defaultGroups;
  }

  /**
   * The allowed groups
   */
  @JsonProperty("allowedGroups")
  @Override
  public @Nullable List<String> getAllowedGroups() {
    return allowedGroups;
  }

  /**
   * Number of users in the zone. If more than 0, it limits the amount of users in the zone. (defaults to -1, no limit).
   */
  @JsonProperty("maxUsers")
  @Override
  public @Nullable Integer getMaxUsers() {
    return maxUsers;
  }

  /**
   * Flag for switching on the check if origin is valid when creating or updating users
   */
  @JsonProperty("checkOriginEnabled")
  @Override
  public @Nullable Boolean getcheckOriginEnabled() {
    return getcheckOriginEnabled;
  }

  /**
   * Flag for switching off the loop over all origins in a zone (defaults to true)
   */
  @JsonProperty("allowOriginLoop")
  @Override
  public @Nullable Boolean getAllowOriginLoop() {
    return allowOriginLoop;
  }

  /**
   * This instance is equal to all instances of {@code UserConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserConfig
        && equalTo(0, (UserConfig) another);
  }

  private boolean equalTo(int synthetic, UserConfig another) {
    return Objects.equals(defaultGroups, another.defaultGroups)
        && Objects.equals(allowedGroups, another.allowedGroups)
        && Objects.equals(maxUsers, another.maxUsers)
        && Objects.equals(getcheckOriginEnabled, another.getcheckOriginEnabled)
        && Objects.equals(allowOriginLoop, another.allowOriginLoop);
  }

  /**
   * Computes a hash code from attributes: {@code defaultGroups}, {@code allowedGroups}, {@code maxUsers}, {@code getcheckOriginEnabled}, {@code allowOriginLoop}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(defaultGroups);
    h += (h << 5) + Objects.hashCode(allowedGroups);
    h += (h << 5) + Objects.hashCode(maxUsers);
    h += (h << 5) + Objects.hashCode(getcheckOriginEnabled);
    h += (h << 5) + Objects.hashCode(allowOriginLoop);
    return h;
  }

  /**
   * Prints the immutable value {@code UserConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserConfig{"
        + "defaultGroups=" + defaultGroups
        + ", allowedGroups=" + allowedGroups
        + ", maxUsers=" + maxUsers
        + ", getcheckOriginEnabled=" + getcheckOriginEnabled
        + ", allowOriginLoop=" + allowOriginLoop
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UserConfig", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._UserConfig {
    List<String> defaultGroups = null;
    List<String> allowedGroups = null;
    Integer maxUsers;
    Boolean getcheckOriginEnabled;
    Boolean allowOriginLoop;
    @JsonProperty("defaultGroups")
    public void setDefaultGroups(@Nullable List<String> defaultGroups) {
      this.defaultGroups = defaultGroups;
    }
    @JsonProperty("allowedGroups")
    public void setAllowedGroups(@Nullable List<String> allowedGroups) {
      this.allowedGroups = allowedGroups;
    }
    @JsonProperty("maxUsers")
    public void setMaxUsers(@Nullable Integer maxUsers) {
      this.maxUsers = maxUsers;
    }
    @JsonProperty("checkOriginEnabled")
    public void setGetcheckOriginEnabled(@Nullable Boolean getcheckOriginEnabled) {
      this.getcheckOriginEnabled = getcheckOriginEnabled;
    }
    @JsonProperty("allowOriginLoop")
    public void setAllowOriginLoop(@Nullable Boolean allowOriginLoop) {
      this.allowOriginLoop = allowOriginLoop;
    }
    @Override
    public List<String> getDefaultGroups() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAllowedGroups() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMaxUsers() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getcheckOriginEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAllowOriginLoop() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UserConfig fromJson(Json json) {
    UserConfig.Builder builder = UserConfig.builder();
    if (json.defaultGroups != null) {
      builder.addAllDefaultGroups(json.defaultGroups);
    }
    if (json.allowedGroups != null) {
      builder.addAllAllowedGroups(json.allowedGroups);
    }
    if (json.maxUsers != null) {
      builder.maxUsers(json.maxUsers);
    }
    if (json.getcheckOriginEnabled != null) {
      builder.getcheckOriginEnabled(json.getcheckOriginEnabled);
    }
    if (json.allowOriginLoop != null) {
      builder.allowOriginLoop(json.allowOriginLoop);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserConfig UserConfig}.
   * <pre>
   * UserConfig.builder()
   *    .defaultGroups(List&amp;lt;String&amp;gt; | null) // nullable {@link UserConfig#getDefaultGroups() defaultGroups}
   *    .allowedGroups(List&amp;lt;String&amp;gt; | null) // nullable {@link UserConfig#getAllowedGroups() allowedGroups}
   *    .maxUsers(Integer | null) // nullable {@link UserConfig#getMaxUsers() maxUsers}
   *    .getcheckOriginEnabled(Boolean | null) // nullable {@link UserConfig#getcheckOriginEnabled() getcheckOriginEnabled}
   *    .allowOriginLoop(Boolean | null) // nullable {@link UserConfig#getAllowOriginLoop() allowOriginLoop}
   *    .build();
   * </pre>
   * @return A new UserConfig builder
   */
  public static UserConfig.Builder builder() {
    return new UserConfig.Builder();
  }

  /**
   * Builds instances of type {@link UserConfig UserConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UserConfig", generator = "Immutables")
  public static final class Builder {
    private List<String> defaultGroups = null;
    private List<String> allowedGroups = null;
    private Integer maxUsers;
    private Boolean getcheckOriginEnabled;
    private Boolean allowOriginLoop;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserConfig instance) {
      return from((_UserConfig) instance);
    }

    /**
     * Copy abstract value type {@code _UserConfig} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UserConfig instance) {
      Objects.requireNonNull(instance, "instance");
      List<String> defaultGroupsValue = instance.getDefaultGroups();
      if (defaultGroupsValue != null) {
        addAllDefaultGroups(defaultGroupsValue);
      }
      List<String> allowedGroupsValue = instance.getAllowedGroups();
      if (allowedGroupsValue != null) {
        addAllAllowedGroups(allowedGroupsValue);
      }
      Integer maxUsersValue = instance.getMaxUsers();
      if (maxUsersValue != null) {
        maxUsers(maxUsersValue);
      }
      Boolean getcheckOriginEnabledValue = instance.getcheckOriginEnabled();
      if (getcheckOriginEnabledValue != null) {
        getcheckOriginEnabled(getcheckOriginEnabledValue);
      }
      Boolean allowOriginLoopValue = instance.getAllowOriginLoop();
      if (allowOriginLoopValue != null) {
        allowOriginLoop(allowOriginLoopValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link UserConfig#getDefaultGroups() defaultGroups} list.
     * @param element A defaultGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultGroup(String element) {
      if (this.defaultGroups == null) {
        this.defaultGroups = new ArrayList<String>();
      }
      this.defaultGroups.add(Objects.requireNonNull(element, "defaultGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link UserConfig#getDefaultGroups() defaultGroups} list.
     * @param elements An array of defaultGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultGroups(String... elements) {
      if (this.defaultGroups == null) {
        this.defaultGroups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.defaultGroups.add(Objects.requireNonNull(element, "defaultGroups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserConfig#getDefaultGroups() defaultGroups} list.
     * @param elements An iterable of defaultGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultGroups")
    public final Builder defaultGroups(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.defaultGroups = null;
        return this;
      }
      this.defaultGroups = new ArrayList<String>();
      return addAllDefaultGroups(elements);
    }

    /**
     * Adds elements to {@link UserConfig#getDefaultGroups() defaultGroups} list.
     * @param elements An iterable of defaultGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDefaultGroups(Iterable<String> elements) {
      Objects.requireNonNull(elements, "defaultGroups element");
      if (this.defaultGroups == null) {
        this.defaultGroups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.defaultGroups.add(Objects.requireNonNull(element, "defaultGroups element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UserConfig#getAllowedGroups() allowedGroups} list.
     * @param element A allowedGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedGroup(String element) {
      if (this.allowedGroups == null) {
        this.allowedGroups = new ArrayList<String>();
      }
      this.allowedGroups.add(Objects.requireNonNull(element, "allowedGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link UserConfig#getAllowedGroups() allowedGroups} list.
     * @param elements An array of allowedGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedGroups(String... elements) {
      if (this.allowedGroups == null) {
        this.allowedGroups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.allowedGroups.add(Objects.requireNonNull(element, "allowedGroups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserConfig#getAllowedGroups() allowedGroups} list.
     * @param elements An iterable of allowedGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedGroups")
    public final Builder allowedGroups(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.allowedGroups = null;
        return this;
      }
      this.allowedGroups = new ArrayList<String>();
      return addAllAllowedGroups(elements);
    }

    /**
     * Adds elements to {@link UserConfig#getAllowedGroups() allowedGroups} list.
     * @param elements An iterable of allowedGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedGroups(Iterable<String> elements) {
      Objects.requireNonNull(elements, "allowedGroups element");
      if (this.allowedGroups == null) {
        this.allowedGroups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.allowedGroups.add(Objects.requireNonNull(element, "allowedGroups element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserConfig#getMaxUsers() maxUsers} attribute.
     * @param maxUsers The value for maxUsers (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maxUsers")
    public final Builder maxUsers(@Nullable Integer maxUsers) {
      this.maxUsers = maxUsers;
      return this;
    }

    /**
     * Initializes the value for the {@link UserConfig#getcheckOriginEnabled() getcheckOriginEnabled} attribute.
     * @param getcheckOriginEnabled The value for getcheckOriginEnabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("checkOriginEnabled")
    public final Builder getcheckOriginEnabled(@Nullable Boolean getcheckOriginEnabled) {
      this.getcheckOriginEnabled = getcheckOriginEnabled;
      return this;
    }

    /**
     * Initializes the value for the {@link UserConfig#getAllowOriginLoop() allowOriginLoop} attribute.
     * @param allowOriginLoop The value for allowOriginLoop (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowOriginLoop")
    public final Builder allowOriginLoop(@Nullable Boolean allowOriginLoop) {
      this.allowOriginLoop = allowOriginLoop;
      return this;
    }

    /**
     * Builds a new {@link UserConfig UserConfig}.
     * @return An immutable instance of UserConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserConfig build() {
      return new UserConfig(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
