package org.cloudfoundry.uaa.serverinformation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Auto Login Authentication Code operation
 */
@Generated(from = "_GetAutoLoginAuthenticationCodeResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetAutoLoginAuthenticationCodeResponse
    extends org.cloudfoundry.uaa.serverinformation._GetAutoLoginAuthenticationCodeResponse {
  private final @Nullable String code;
  private final String path;

  private GetAutoLoginAuthenticationCodeResponse(GetAutoLoginAuthenticationCodeResponse.Builder builder) {
    this.code = builder.code;
    this.path = builder.path;
  }

  /**
   * The code used to authenticate the user.
   */
  @JsonProperty("code")
  @Override
  public @Nullable String getCode() {
    return code;
  }

  /**
   * Not used. Hardcoded to /oauth/authorize
   */
  @JsonProperty("path")
  @Override
  public String getPath() {
    return path;
  }

  /**
   * This instance is equal to all instances of {@code GetAutoLoginAuthenticationCodeResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetAutoLoginAuthenticationCodeResponse
        && equalTo(0, (GetAutoLoginAuthenticationCodeResponse) another);
  }

  private boolean equalTo(int synthetic, GetAutoLoginAuthenticationCodeResponse another) {
    return Objects.equals(code, another.code)
        && path.equals(another.path);
  }

  /**
   * Computes a hash code from attributes: {@code code}, {@code path}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(code);
    h += (h << 5) + path.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetAutoLoginAuthenticationCodeResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetAutoLoginAuthenticationCodeResponse{"
        + "code=" + code
        + ", path=" + path
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetAutoLoginAuthenticationCodeResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.uaa.serverinformation._GetAutoLoginAuthenticationCodeResponse {
    String code;
    String path;
    @JsonProperty("code")
    public void setCode(@Nullable String code) {
      this.code = code;
    }
    @JsonProperty("path")
    public void setPath(String path) {
      this.path = path;
    }
    @Override
    public String getCode() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetAutoLoginAuthenticationCodeResponse fromJson(Json json) {
    GetAutoLoginAuthenticationCodeResponse.Builder builder = GetAutoLoginAuthenticationCodeResponse.builder();
    if (json.code != null) {
      builder.code(json.code);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetAutoLoginAuthenticationCodeResponse GetAutoLoginAuthenticationCodeResponse}.
   * <pre>
   * GetAutoLoginAuthenticationCodeResponse.builder()
   *    .code(String | null) // nullable {@link GetAutoLoginAuthenticationCodeResponse#getCode() code}
   *    .path(String) // required {@link GetAutoLoginAuthenticationCodeResponse#getPath() path}
   *    .build();
   * </pre>
   * @return A new GetAutoLoginAuthenticationCodeResponse builder
   */
  public static GetAutoLoginAuthenticationCodeResponse.Builder builder() {
    return new GetAutoLoginAuthenticationCodeResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetAutoLoginAuthenticationCodeResponse GetAutoLoginAuthenticationCodeResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetAutoLoginAuthenticationCodeResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PATH = 0x1L;
    private long initBits = 0x1L;

    private String code;
    private String path;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetAutoLoginAuthenticationCodeResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetAutoLoginAuthenticationCodeResponse instance) {
      return from((_GetAutoLoginAuthenticationCodeResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetAutoLoginAuthenticationCodeResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetAutoLoginAuthenticationCodeResponse instance) {
      Objects.requireNonNull(instance, "instance");
      String codeValue = instance.getCode();
      if (codeValue != null) {
        code(codeValue);
      }
      this.path(instance.getPath());
      return this;
    }

    /**
     * Initializes the value for the {@link GetAutoLoginAuthenticationCodeResponse#getCode() code} attribute.
     * @param code The value for code (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("code")
    public final Builder code(@Nullable String code) {
      this.code = code;
      return this;
    }

    /**
     * Initializes the value for the {@link GetAutoLoginAuthenticationCodeResponse#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("path")
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Builds a new {@link GetAutoLoginAuthenticationCodeResponse GetAutoLoginAuthenticationCodeResponse}.
     * @return An immutable instance of GetAutoLoginAuthenticationCodeResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetAutoLoginAuthenticationCodeResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetAutoLoginAuthenticationCodeResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      return "Cannot build GetAutoLoginAuthenticationCodeResponse, some of required attributes are not set " + attributes;
    }
  }
}
