package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * An email address for a user
 */
@Generated(from = "_Email", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Email extends org.cloudfoundry.uaa.users._Email {
  private final Boolean primary;
  private final String value;

  private Email(Email.Builder builder) {
    this.primary = builder.primary;
    this.value = builder.value;
  }

  /**
   * Whether this email address is the primary
   */
  @JsonProperty("primary")
  @Override
  public Boolean getPrimary() {
    return primary;
  }

  /**
   * The email address
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code Email} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Email
        && equalTo(0, (Email) another);
  }

  private boolean equalTo(int synthetic, Email another) {
    return primary.equals(another.primary)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code primary}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + primary.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Email} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Email{"
        + "primary=" + primary
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Email", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._Email {
    Boolean primary;
    String value;
    @JsonProperty("primary")
    public void setPrimary(Boolean primary) {
      this.primary = primary;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public Boolean getPrimary() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Email fromJson(Json json) {
    Email.Builder builder = Email.builder();
    if (json.primary != null) {
      builder.primary(json.primary);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Email Email}.
   * <pre>
   * Email.builder()
   *    .primary(Boolean) // required {@link Email#getPrimary() primary}
   *    .value(String) // required {@link Email#getValue() value}
   *    .build();
   * </pre>
   * @return A new Email builder
   */
  public static Email.Builder builder() {
    return new Email.Builder();
  }

  /**
   * Builds instances of type {@link Email Email}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Email", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PRIMARY = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private Boolean primary;
    private String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Email} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Email instance) {
      return from((_Email) instance);
    }

    /**
     * Copy abstract value type {@code _Email} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Email instance) {
      Objects.requireNonNull(instance, "instance");
      this.primary(instance.getPrimary());
      this.value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link Email#getPrimary() primary} attribute.
     * @param primary The value for primary 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("primary")
    public final Builder primary(Boolean primary) {
      this.primary = Objects.requireNonNull(primary, "primary");
      initBits &= ~INIT_BIT_PRIMARY;
      return this;
    }

    /**
     * Initializes the value for the {@link Email#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link Email Email}.
     * @return An immutable instance of Email
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Email build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Email(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PRIMARY) != 0) attributes.add("primary");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build Email, some of required attributes are not set " + attributes;
    }
  }
}
