package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A phone number for a user
 */
@Generated(from = "_PhoneNumber", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class PhoneNumber extends org.cloudfoundry.uaa.users._PhoneNumber {
  private final String value;

  private PhoneNumber(PhoneNumber.Builder builder) {
    this.value = builder.value;
  }

  /**
   * The phone number
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code PhoneNumber} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof PhoneNumber
        && equalTo(0, (PhoneNumber) another);
  }

  private boolean equalTo(int synthetic, PhoneNumber another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PhoneNumber} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PhoneNumber{"
        + "value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_PhoneNumber", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._PhoneNumber {
    String value;
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static PhoneNumber fromJson(Json json) {
    PhoneNumber.Builder builder = PhoneNumber.builder();
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link PhoneNumber PhoneNumber}.
   * <pre>
   * PhoneNumber.builder()
   *    .value(String) // required {@link PhoneNumber#getValue() value}
   *    .build();
   * </pre>
   * @return A new PhoneNumber builder
   */
  public static PhoneNumber.Builder builder() {
    return new PhoneNumber.Builder();
  }

  /**
   * Builds instances of type {@link PhoneNumber PhoneNumber}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_PhoneNumber", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PhoneNumber} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PhoneNumber instance) {
      return from((_PhoneNumber) instance);
    }

    /**
     * Copy abstract value type {@code _PhoneNumber} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_PhoneNumber instance) {
      Objects.requireNonNull(instance, "instance");
      this.value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link PhoneNumber#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link PhoneNumber PhoneNumber}.
     * @return An immutable instance of PhoneNumber
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PhoneNumber build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PhoneNumber(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build PhoneNumber, some of required attributes are not set " + attributes;
    }
  }
}
