package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _UserId}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UserId.builder()}.
 */
@Generated(from = "_UserId", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UserId extends org.cloudfoundry.uaa.users._UserId {
  private final String id;
  private final String origin;
  private final String userName;

  private UserId(UserId.Builder builder) {
    this.id = builder.id;
    this.origin = builder.origin;
    this.userName = builder.userName;
  }

  /**
   * The id
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The identity provider that authenticated this user
   */
  @JsonProperty("origin")
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * The user name
   */
  @JsonProperty("userName")
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * This instance is equal to all instances of {@code UserId} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserId
        && equalTo(0, (UserId) another);
  }

  private boolean equalTo(int synthetic, UserId another) {
    return id.equals(another.id)
        && origin.equals(another.origin)
        && userName.equals(another.userName);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code origin}, {@code userName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + origin.hashCode();
    h += (h << 5) + userName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UserId} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserId{"
        + "id=" + id
        + ", origin=" + origin
        + ", userName=" + userName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UserId", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._UserId {
    String id;
    String origin;
    String userName;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("origin")
    public void setOrigin(String origin) {
      this.origin = origin;
    }
    @JsonProperty("userName")
    public void setUserName(String userName) {
      this.userName = userName;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UserId fromJson(Json json) {
    UserId.Builder builder = UserId.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.userName != null) {
      builder.userName(json.userName);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserId UserId}.
   * <pre>
   * UserId.builder()
   *    .id(String) // required {@link UserId#getId() id}
   *    .origin(String) // required {@link UserId#getOrigin() origin}
   *    .userName(String) // required {@link UserId#getUserName() userName}
   *    .build();
   * </pre>
   * @return A new UserId builder
   */
  public static UserId.Builder builder() {
    return new UserId.Builder();
  }

  /**
   * Builds instances of type {@link UserId UserId}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UserId", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_ORIGIN = 0x2L;
    private static final long INIT_BIT_USER_NAME = 0x4L;
    private long initBits = 0x7L;

    private String id;
    private String origin;
    private String userName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.users.AbstractUserId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUserId instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserId instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UserId} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UserId instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractUserId) {
        AbstractUserId instance = (AbstractUserId) object;
        this.userName(instance.getUserName());
        this.origin(instance.getOrigin());
        this.id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link UserId#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UserId#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("origin")
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Initializes the value for the {@link UserId#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userName")
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Builds a new {@link UserId UserId}.
     * @return An immutable instance of UserId
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserId build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UserId(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      return "Cannot build UserId, some of required attributes are not set " + attributes;
    }
  }
}
