/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.applications.NetInfo;
import org.cloudfoundry.client.v2.applications.Usage;
import org.cloudfoundry.client.v2.applications._Statistics;
import org.immutables.value.Generated;

@Generated(from="_Statistics", generator="Immutables")
public final class Statistics
extends _Statistics {
    @Nullable
    private final Long diskQuota;
    @Nullable
    private final Integer fdsQuota;
    @Nullable
    private final String host;
    @Nullable
    private final Long memoryQuota;
    @Nullable
    private final String name;
    @Nullable
    private final NetInfo netInfo;
    @Nullable
    private final Integer port;
    @Nullable
    private final Long uptime;
    @Nullable
    private final List<String> uris;
    @Nullable
    private final Usage usage;
    @Nullable
    private final Integer logRateLimit;
    @Nullable
    private final String instanceGuid;

    private Statistics(Builder builder) {
        this.diskQuota = builder.diskQuota;
        this.fdsQuota = builder.fdsQuota;
        this.host = builder.host;
        this.memoryQuota = builder.memoryQuota;
        this.name = builder.name;
        this.netInfo = builder.netInfo;
        this.port = builder.port;
        this.uptime = builder.uptime;
        this.uris = builder.uris == null ? null : Statistics.createUnmodifiableList(true, builder.uris);
        this.usage = builder.usage;
        this.logRateLimit = builder.logRateLimit;
        this.instanceGuid = builder.instanceGuid;
    }

    @Override
    @JsonProperty(value="disk_quota")
    @Nullable
    public Long getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    @JsonProperty(value="fds_quota")
    @Nullable
    public Integer getFdsQuota() {
        return this.fdsQuota;
    }

    @Override
    @JsonProperty(value="host")
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty(value="mem_quota")
    @Nullable
    public Long getMemoryQuota() {
        return this.memoryQuota;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="net_info")
    @Nullable
    public NetInfo getNetInfo() {
        return this.netInfo;
    }

    @Override
    @JsonProperty(value="port")
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="uptime")
    @Nullable
    public Long getUptime() {
        return this.uptime;
    }

    @Override
    @JsonProperty(value="uris")
    @Nullable
    public List<String> getUris() {
        return this.uris;
    }

    @Override
    @JsonProperty(value="usage")
    @Nullable
    public Usage getUsage() {
        return this.usage;
    }

    @Override
    @JsonProperty(value="log_rate_limit")
    @Nullable
    public Integer getLogRateLimit() {
        return this.logRateLimit;
    }

    @Override
    @JsonProperty(value="instance_guid")
    @Nullable
    public String getInstanceGuid() {
        return this.instanceGuid;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Statistics && this.equalTo(0, (Statistics)another);
    }

    private boolean equalTo(int synthetic, Statistics another) {
        return Objects.equals(this.diskQuota, another.diskQuota) && Objects.equals(this.fdsQuota, another.fdsQuota) && Objects.equals(this.host, another.host) && Objects.equals(this.memoryQuota, another.memoryQuota) && Objects.equals(this.name, another.name) && Objects.equals(this.netInfo, another.netInfo) && Objects.equals(this.port, another.port) && Objects.equals(this.uptime, another.uptime) && Objects.equals(this.uris, another.uris) && Objects.equals(this.usage, another.usage) && Objects.equals(this.logRateLimit, another.logRateLimit) && Objects.equals(this.instanceGuid, another.instanceGuid);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.diskQuota);
        h += (h << 5) + Objects.hashCode(this.fdsQuota);
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.memoryQuota);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.netInfo);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.uptime);
        h += (h << 5) + Objects.hashCode(this.uris);
        h += (h << 5) + Objects.hashCode(this.usage);
        h += (h << 5) + Objects.hashCode(this.logRateLimit);
        h += (h << 5) + Objects.hashCode(this.instanceGuid);
        return h;
    }

    public String toString() {
        return "Statistics{diskQuota=" + this.diskQuota + ", fdsQuota=" + this.fdsQuota + ", host=" + this.host + ", memoryQuota=" + this.memoryQuota + ", name=" + this.name + ", netInfo=" + this.netInfo + ", port=" + this.port + ", uptime=" + this.uptime + ", uris=" + this.uris + ", usage=" + this.usage + ", logRateLimit=" + this.logRateLimit + ", instanceGuid=" + this.instanceGuid + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Statistics fromJson(Json json) {
        Builder builder = Statistics.builder();
        if (json.diskQuota != null) {
            builder.diskQuota(json.diskQuota);
        }
        if (json.fdsQuota != null) {
            builder.fdsQuota(json.fdsQuota);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.memoryQuota != null) {
            builder.memoryQuota(json.memoryQuota);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.netInfo != null) {
            builder.netInfo(json.netInfo);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.uptime != null) {
            builder.uptime(json.uptime);
        }
        if (json.uris != null) {
            builder.addAllUris(json.uris);
        }
        if (json.usage != null) {
            builder.usage(json.usage);
        }
        if (json.logRateLimit != null) {
            builder.logRateLimit(json.logRateLimit);
        }
        if (json.instanceGuid != null) {
            builder.instanceGuid(json.instanceGuid);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_Statistics", generator="Immutables")
    public static final class Builder {
        private Long diskQuota;
        private Integer fdsQuota;
        private String host;
        private Long memoryQuota;
        private String name;
        private NetInfo netInfo;
        private Integer port;
        private Long uptime;
        private List<String> uris = null;
        private Usage usage;
        private Integer logRateLimit;
        private String instanceGuid;

        private Builder() {
        }

        public final Builder from(Statistics instance) {
            return this.from((_Statistics)instance);
        }

        final Builder from(_Statistics instance) {
            String instanceGuidValue;
            Integer logRateLimitValue;
            Usage usageValue;
            List<String> urisValue;
            Long uptimeValue;
            Integer portValue;
            NetInfo netInfoValue;
            String nameValue;
            Long memoryQuotaValue;
            String hostValue;
            Integer fdsQuotaValue;
            Objects.requireNonNull(instance, "instance");
            Long diskQuotaValue = instance.getDiskQuota();
            if (diskQuotaValue != null) {
                this.diskQuota(diskQuotaValue);
            }
            if ((fdsQuotaValue = instance.getFdsQuota()) != null) {
                this.fdsQuota(fdsQuotaValue);
            }
            if ((hostValue = instance.getHost()) != null) {
                this.host(hostValue);
            }
            if ((memoryQuotaValue = instance.getMemoryQuota()) != null) {
                this.memoryQuota(memoryQuotaValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((netInfoValue = instance.getNetInfo()) != null) {
                this.netInfo(netInfoValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            if ((uptimeValue = instance.getUptime()) != null) {
                this.uptime(uptimeValue);
            }
            if ((urisValue = instance.getUris()) != null) {
                this.addAllUris(urisValue);
            }
            if ((usageValue = instance.getUsage()) != null) {
                this.usage(usageValue);
            }
            if ((logRateLimitValue = instance.getLogRateLimit()) != null) {
                this.logRateLimit(logRateLimitValue);
            }
            if ((instanceGuidValue = instance.getInstanceGuid()) != null) {
                this.instanceGuid(instanceGuidValue);
            }
            return this;
        }

        @JsonProperty(value="disk_quota")
        public final Builder diskQuota(@Nullable Long diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        @JsonProperty(value="fds_quota")
        public final Builder fdsQuota(@Nullable Integer fdsQuota) {
            this.fdsQuota = fdsQuota;
            return this;
        }

        @JsonProperty(value="host")
        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        @JsonProperty(value="mem_quota")
        public final Builder memoryQuota(@Nullable Long memoryQuota) {
            this.memoryQuota = memoryQuota;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="net_info")
        public final Builder netInfo(@Nullable NetInfo netInfo) {
            this.netInfo = netInfo;
            return this;
        }

        @JsonProperty(value="port")
        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="uptime")
        public final Builder uptime(@Nullable Long uptime) {
            this.uptime = uptime;
            return this;
        }

        public final Builder uri(String element) {
            if (this.uris == null) {
                this.uris = new ArrayList<String>();
            }
            this.uris.add(Objects.requireNonNull(element, "uris element"));
            return this;
        }

        public final Builder uris(String ... elements) {
            if (this.uris == null) {
                this.uris = new ArrayList<String>();
            }
            for (String element : elements) {
                this.uris.add(Objects.requireNonNull(element, "uris element"));
            }
            return this;
        }

        @JsonProperty(value="uris")
        public final Builder uris(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.uris = null;
                return this;
            }
            this.uris = new ArrayList<String>();
            return this.addAllUris(elements);
        }

        public final Builder addAllUris(Iterable<String> elements) {
            Objects.requireNonNull(elements, "uris element");
            if (this.uris == null) {
                this.uris = new ArrayList<String>();
            }
            for (String element : elements) {
                this.uris.add(Objects.requireNonNull(element, "uris element"));
            }
            return this;
        }

        @JsonProperty(value="usage")
        public final Builder usage(@Nullable Usage usage) {
            this.usage = usage;
            return this;
        }

        @JsonProperty(value="log_rate_limit")
        public final Builder logRateLimit(@Nullable Integer logRateLimit) {
            this.logRateLimit = logRateLimit;
            return this;
        }

        @JsonProperty(value="instance_guid")
        public final Builder instanceGuid(@Nullable String instanceGuid) {
            this.instanceGuid = instanceGuid;
            return this;
        }

        public Statistics build() {
            return new Statistics(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_Statistics", generator="Immutables")
    static final class Json
    extends _Statistics {
        Long diskQuota;
        Integer fdsQuota;
        String host;
        Long memoryQuota;
        String name;
        NetInfo netInfo;
        Integer port;
        Long uptime;
        List<String> uris = null;
        Usage usage;
        Integer logRateLimit;
        String instanceGuid;

        Json() {
        }

        @JsonProperty(value="disk_quota")
        public void setDiskQuota(@Nullable Long diskQuota) {
            this.diskQuota = diskQuota;
        }

        @JsonProperty(value="fds_quota")
        public void setFdsQuota(@Nullable Integer fdsQuota) {
            this.fdsQuota = fdsQuota;
        }

        @JsonProperty(value="host")
        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @JsonProperty(value="mem_quota")
        public void setMemoryQuota(@Nullable Long memoryQuota) {
            this.memoryQuota = memoryQuota;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="net_info")
        public void setNetInfo(@Nullable NetInfo netInfo) {
            this.netInfo = netInfo;
        }

        @JsonProperty(value="port")
        public void setPort(@Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="uptime")
        public void setUptime(@Nullable Long uptime) {
            this.uptime = uptime;
        }

        @JsonProperty(value="uris")
        public void setUris(@Nullable List<String> uris) {
            this.uris = uris;
        }

        @JsonProperty(value="usage")
        public void setUsage(@Nullable Usage usage) {
            this.usage = usage;
        }

        @JsonProperty(value="log_rate_limit")
        public void setLogRateLimit(@Nullable Integer logRateLimit) {
            this.logRateLimit = logRateLimit;
        }

        @JsonProperty(value="instance_guid")
        public void setInstanceGuid(@Nullable String instanceGuid) {
            this.instanceGuid = instanceGuid;
        }

        @Override
        public Long getDiskQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getFdsQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getMemoryQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NetInfo getNetInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getUptime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getUris() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Usage getUsage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getLogRateLimit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getInstanceGuid() {
            throw new UnsupportedOperationException();
        }
    }
}

