/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.buildpacks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum LifecycleType {
    BUILDPACK("buildpack"),
    DOCKER("docker"),
    CNB("cnb");

    private final String value;

    private LifecycleType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static LifecycleType from(String s) {
        switch (s.toLowerCase()) {
            case "buildpack": {
                return BUILDPACK;
            }
            case "docker": {
                return DOCKER;
            }
            case "cnb": {
                return CNB;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown lifecycle type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

