/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routemappings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.routemappings._CreateRouteMappingRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateRouteMappingRequest", generator="Immutables")
public final class CreateRouteMappingRequest
extends _CreateRouteMappingRequest {
    private final String applicationId;
    @Nullable
    private final Integer applicationPort;
    private final String routeId;

    private CreateRouteMappingRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.applicationPort = builder.applicationPort;
        this.routeId = builder.routeId;
    }

    @Override
    @JsonProperty(value="app_guid")
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @JsonProperty(value="app_port")
    @Nullable
    public Integer getApplicationPort() {
        return this.applicationPort;
    }

    @Override
    @JsonProperty(value="route_guid")
    public String getRouteId() {
        return this.routeId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateRouteMappingRequest && this.equalTo(0, (CreateRouteMappingRequest)another);
    }

    private boolean equalTo(int synthetic, CreateRouteMappingRequest another) {
        return this.applicationId.equals(another.applicationId) && Objects.equals(this.applicationPort, another.applicationPort) && this.routeId.equals(another.routeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.applicationPort);
        h += (h << 5) + this.routeId.hashCode();
        return h;
    }

    public String toString() {
        return "CreateRouteMappingRequest{applicationId=" + this.applicationId + ", applicationPort=" + this.applicationPort + ", routeId=" + this.routeId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateRouteMappingRequest fromJson(Json json) {
        Builder builder = CreateRouteMappingRequest.builder();
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.applicationPort != null) {
            builder.applicationPort(json.applicationPort);
        }
        if (json.routeId != null) {
            builder.routeId(json.routeId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CreateRouteMappingRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_ROUTE_ID = 2L;
        private long initBits = 3L;
        private String applicationId;
        private Integer applicationPort;
        private String routeId;

        private Builder() {
        }

        public final Builder from(CreateRouteMappingRequest instance) {
            return this.from((_CreateRouteMappingRequest)instance);
        }

        final Builder from(_CreateRouteMappingRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            Integer applicationPortValue = instance.getApplicationPort();
            if (applicationPortValue != null) {
                this.applicationPort(applicationPortValue);
            }
            this.routeId(instance.getRouteId());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder applicationPort(@Nullable Integer applicationPort) {
            this.applicationPort = applicationPort;
            return this;
        }

        public final Builder routeId(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "routeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateRouteMappingRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateRouteMappingRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("routeId");
            }
            return "Cannot build CreateRouteMappingRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateRouteMappingRequest", generator="Immutables")
    static final class Json
    extends _CreateRouteMappingRequest {
        String applicationId;
        Integer applicationPort;
        String routeId;

        Json() {
        }

        @JsonProperty(value="app_guid")
        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="app_port")
        public void setApplicationPort(@Nullable Integer applicationPort) {
            this.applicationPort = applicationPort;
        }

        @JsonProperty(value="route_guid")
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public String getApplicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getApplicationPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouteId() {
            throw new UnsupportedOperationException();
        }
    }
}

