/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.servicebindings.LastOperation;
import org.cloudfoundry.client.v2.servicebindings.VolumeMounts;
import org.cloudfoundry.client.v2.servicebindings._ServiceBindingEntity;
import org.cloudfoundry.client.v2.serviceinstances.GatewayData;
import org.immutables.value.Generated;

@Generated(from="_ServiceBindingEntity", generator="Immutables")
public final class ServiceBindingEntity
extends _ServiceBindingEntity {
    @Nullable
    private final String applicationId;
    @Nullable
    private final String applicationUrl;
    @Nullable
    private final Map<String, Object> bindingOptions;
    @Nullable
    private final Map<String, Object> credentials;
    @Nullable
    private final GatewayData gatewayData;
    @Nullable
    private final String gatewayName;
    @Nullable
    private final LastOperation lastOperation;
    @Nullable
    private final String name;
    @Nullable
    private final String serviceBindingParametersUrl;
    @Nullable
    private final String serviceInstanceId;
    @Nullable
    private final String serviceInstanceUrl;
    @Nullable
    private final String syslogDrainUrl;
    @Nullable
    private final List<VolumeMounts> volumeMounts;

    private ServiceBindingEntity(Builder builder) {
        this.applicationId = builder.applicationId;
        this.applicationUrl = builder.applicationUrl;
        this.bindingOptions = builder.bindingOptions == null ? null : ServiceBindingEntity.createUnmodifiableMap(false, false, builder.bindingOptions);
        this.credentials = builder.credentials == null ? null : ServiceBindingEntity.createUnmodifiableMap(false, false, builder.credentials);
        this.gatewayData = builder.gatewayData;
        this.gatewayName = builder.gatewayName;
        this.lastOperation = builder.lastOperation;
        this.name = builder.name;
        this.serviceBindingParametersUrl = builder.serviceBindingParametersUrl;
        this.serviceInstanceId = builder.serviceInstanceId;
        this.serviceInstanceUrl = builder.serviceInstanceUrl;
        this.syslogDrainUrl = builder.syslogDrainUrl;
        this.volumeMounts = builder.volumeMounts == null ? null : ServiceBindingEntity.createUnmodifiableList(true, builder.volumeMounts);
    }

    @Override
    @JsonProperty(value="app_guid")
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @JsonProperty(value="app_url")
    @Nullable
    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    @Override
    @JsonProperty(value="binding_options")
    @Nullable
    public Map<String, Object> getBindingOptions() {
        return this.bindingOptions;
    }

    @Override
    @JsonProperty(value="credentials")
    @Nullable
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @Override
    @JsonProperty(value="gateway_data")
    @Deprecated
    @Nullable
    public GatewayData getGatewayData() {
        return this.gatewayData;
    }

    @Override
    @JsonProperty(value="gateway_name")
    @Nullable
    public String getGatewayName() {
        return this.gatewayName;
    }

    @Override
    @JsonProperty(value="last_operation")
    @Nullable
    public LastOperation getLastOperation() {
        return this.lastOperation;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="service_binding_parameters_url")
    @Nullable
    public String getServiceBindingParametersUrl() {
        return this.serviceBindingParametersUrl;
    }

    @Override
    @JsonProperty(value="service_instance_guid")
    @Nullable
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    @JsonProperty(value="service_instance_url")
    @Nullable
    public String getServiceInstanceUrl() {
        return this.serviceInstanceUrl;
    }

    @Override
    @JsonProperty(value="syslog_drain_url")
    @Nullable
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    @Override
    @JsonProperty(value="volume_mounts")
    @Nullable
    public List<VolumeMounts> getVolumeMounts() {
        return this.volumeMounts;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceBindingEntity && this.equalTo(0, (ServiceBindingEntity)another);
    }

    private boolean equalTo(int synthetic, ServiceBindingEntity another) {
        return Objects.equals(this.applicationId, another.applicationId) && Objects.equals(this.applicationUrl, another.applicationUrl) && Objects.equals(this.bindingOptions, another.bindingOptions) && Objects.equals(this.credentials, another.credentials) && Objects.equals(this.gatewayData, another.gatewayData) && Objects.equals(this.gatewayName, another.gatewayName) && Objects.equals(this.lastOperation, another.lastOperation) && Objects.equals(this.name, another.name) && Objects.equals(this.serviceBindingParametersUrl, another.serviceBindingParametersUrl) && Objects.equals(this.serviceInstanceId, another.serviceInstanceId) && Objects.equals(this.serviceInstanceUrl, another.serviceInstanceUrl) && Objects.equals(this.syslogDrainUrl, another.syslogDrainUrl) && Objects.equals(this.volumeMounts, another.volumeMounts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationId);
        h += (h << 5) + Objects.hashCode(this.applicationUrl);
        h += (h << 5) + Objects.hashCode(this.bindingOptions);
        h += (h << 5) + Objects.hashCode(this.credentials);
        h += (h << 5) + Objects.hashCode(this.gatewayData);
        h += (h << 5) + Objects.hashCode(this.gatewayName);
        h += (h << 5) + Objects.hashCode(this.lastOperation);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.serviceBindingParametersUrl);
        h += (h << 5) + Objects.hashCode(this.serviceInstanceId);
        h += (h << 5) + Objects.hashCode(this.serviceInstanceUrl);
        h += (h << 5) + Objects.hashCode(this.syslogDrainUrl);
        h += (h << 5) + Objects.hashCode(this.volumeMounts);
        return h;
    }

    public String toString() {
        return "ServiceBindingEntity{applicationId=" + this.applicationId + ", applicationUrl=" + this.applicationUrl + ", bindingOptions=" + this.bindingOptions + ", credentials=" + this.credentials + ", gatewayData=" + this.gatewayData + ", gatewayName=" + this.gatewayName + ", lastOperation=" + this.lastOperation + ", name=" + this.name + ", serviceBindingParametersUrl=" + this.serviceBindingParametersUrl + ", serviceInstanceId=" + this.serviceInstanceId + ", serviceInstanceUrl=" + this.serviceInstanceUrl + ", syslogDrainUrl=" + this.syslogDrainUrl + ", volumeMounts=" + this.volumeMounts + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ServiceBindingEntity fromJson(Json json) {
        Builder builder = ServiceBindingEntity.builder();
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.applicationUrl != null) {
            builder.applicationUrl(json.applicationUrl);
        }
        if (json.bindingOptions != null) {
            builder.putAllBindingOptions(json.bindingOptions);
        }
        if (json.credentials != null) {
            builder.putAllCredentials(json.credentials);
        }
        if (json.gatewayData != null) {
            builder.gatewayData(json.gatewayData);
        }
        if (json.gatewayName != null) {
            builder.gatewayName(json.gatewayName);
        }
        if (json.lastOperation != null) {
            builder.lastOperation(json.lastOperation);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.serviceBindingParametersUrl != null) {
            builder.serviceBindingParametersUrl(json.serviceBindingParametersUrl);
        }
        if (json.serviceInstanceId != null) {
            builder.serviceInstanceId(json.serviceInstanceId);
        }
        if (json.serviceInstanceUrl != null) {
            builder.serviceInstanceUrl(json.serviceInstanceUrl);
        }
        if (json.syslogDrainUrl != null) {
            builder.syslogDrainUrl(json.syslogDrainUrl);
        }
        if (json.volumeMounts != null) {
            builder.addAllVolumeMounts(json.volumeMounts);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_ServiceBindingEntity", generator="Immutables")
    public static final class Builder {
        private String applicationId;
        private String applicationUrl;
        private Map<String, Object> bindingOptions = null;
        private Map<String, Object> credentials = null;
        private GatewayData gatewayData;
        private String gatewayName;
        private LastOperation lastOperation;
        private String name;
        private String serviceBindingParametersUrl;
        private String serviceInstanceId;
        private String serviceInstanceUrl;
        private String syslogDrainUrl;
        private List<VolumeMounts> volumeMounts = null;

        private Builder() {
        }

        public final Builder from(ServiceBindingEntity instance) {
            return this.from((_ServiceBindingEntity)instance);
        }

        final Builder from(_ServiceBindingEntity instance) {
            List<VolumeMounts> volumeMountsValue;
            String syslogDrainUrlValue;
            String serviceInstanceUrlValue;
            String serviceInstanceIdValue;
            String serviceBindingParametersUrlValue;
            String nameValue;
            LastOperation lastOperationValue;
            String gatewayNameValue;
            GatewayData gatewayDataValue;
            Map<String, Object> credentialsValue;
            Map<String, Object> bindingOptionsValue;
            String applicationUrlValue;
            Objects.requireNonNull(instance, "instance");
            String applicationIdValue = instance.getApplicationId();
            if (applicationIdValue != null) {
                this.applicationId(applicationIdValue);
            }
            if ((applicationUrlValue = instance.getApplicationUrl()) != null) {
                this.applicationUrl(applicationUrlValue);
            }
            if ((bindingOptionsValue = instance.getBindingOptions()) != null) {
                this.putAllBindingOptions(bindingOptionsValue);
            }
            if ((credentialsValue = instance.getCredentials()) != null) {
                this.putAllCredentials(credentialsValue);
            }
            if ((gatewayDataValue = instance.getGatewayData()) != null) {
                this.gatewayData(gatewayDataValue);
            }
            if ((gatewayNameValue = instance.getGatewayName()) != null) {
                this.gatewayName(gatewayNameValue);
            }
            if ((lastOperationValue = instance.getLastOperation()) != null) {
                this.lastOperation(lastOperationValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((serviceBindingParametersUrlValue = instance.getServiceBindingParametersUrl()) != null) {
                this.serviceBindingParametersUrl(serviceBindingParametersUrlValue);
            }
            if ((serviceInstanceIdValue = instance.getServiceInstanceId()) != null) {
                this.serviceInstanceId(serviceInstanceIdValue);
            }
            if ((serviceInstanceUrlValue = instance.getServiceInstanceUrl()) != null) {
                this.serviceInstanceUrl(serviceInstanceUrlValue);
            }
            if ((syslogDrainUrlValue = instance.getSyslogDrainUrl()) != null) {
                this.syslogDrainUrl(syslogDrainUrlValue);
            }
            if ((volumeMountsValue = instance.getVolumeMounts()) != null) {
                this.addAllVolumeMounts(volumeMountsValue);
            }
            return this;
        }

        @JsonProperty(value="app_guid")
        public final Builder applicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @JsonProperty(value="app_url")
        public final Builder applicationUrl(@Nullable String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        public final Builder bindingOption(String key, Object value) {
            if (this.bindingOptions == null) {
                this.bindingOptions = new LinkedHashMap<String, Object>();
            }
            this.bindingOptions.put(key, value);
            return this;
        }

        public final Builder bindingOption(Map.Entry<String, ? extends Object> entry) {
            if (this.bindingOptions == null) {
                this.bindingOptions = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.bindingOptions.put(k, v);
            return this;
        }

        @JsonProperty(value="binding_options")
        public final Builder bindingOptions(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.bindingOptions = null;
                return this;
            }
            this.bindingOptions = new LinkedHashMap<String, Object>();
            return this.putAllBindingOptions(entries);
        }

        public final Builder putAllBindingOptions(Map<String, ? extends Object> entries) {
            if (this.bindingOptions == null) {
                this.bindingOptions = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.bindingOptions.put(k, v);
            }
            return this;
        }

        public final Builder credential(String key, Object value) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            this.credentials.put(key, value);
            return this;
        }

        public final Builder credential(Map.Entry<String, ? extends Object> entry) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.credentials.put(k, v);
            return this;
        }

        @JsonProperty(value="credentials")
        public final Builder credentials(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.credentials = null;
                return this;
            }
            this.credentials = new LinkedHashMap<String, Object>();
            return this.putAllCredentials(entries);
        }

        public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.credentials.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="gateway_data")
        @Deprecated
        public final Builder gatewayData(@Nullable GatewayData gatewayData) {
            this.gatewayData = gatewayData;
            return this;
        }

        @JsonProperty(value="gateway_name")
        public final Builder gatewayName(@Nullable String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        @JsonProperty(value="last_operation")
        public final Builder lastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="service_binding_parameters_url")
        public final Builder serviceBindingParametersUrl(@Nullable String serviceBindingParametersUrl) {
            this.serviceBindingParametersUrl = serviceBindingParametersUrl;
            return this;
        }

        @JsonProperty(value="service_instance_guid")
        public final Builder serviceInstanceId(@Nullable String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        @JsonProperty(value="service_instance_url")
        public final Builder serviceInstanceUrl(@Nullable String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
            return this;
        }

        @JsonProperty(value="syslog_drain_url")
        public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public final Builder volumeMount(VolumeMounts element) {
            if (this.volumeMounts == null) {
                this.volumeMounts = new ArrayList<VolumeMounts>();
            }
            this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
            return this;
        }

        public final Builder volumeMounts(VolumeMounts ... elements) {
            if (this.volumeMounts == null) {
                this.volumeMounts = new ArrayList<VolumeMounts>();
            }
            for (VolumeMounts element : elements) {
                this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
            }
            return this;
        }

        @JsonProperty(value="volume_mounts")
        public final Builder volumeMounts(@Nullable Iterable<? extends VolumeMounts> elements) {
            if (elements == null) {
                this.volumeMounts = null;
                return this;
            }
            this.volumeMounts = new ArrayList<VolumeMounts>();
            return this.addAllVolumeMounts(elements);
        }

        public final Builder addAllVolumeMounts(Iterable<? extends VolumeMounts> elements) {
            Objects.requireNonNull(elements, "volumeMounts element");
            if (this.volumeMounts == null) {
                this.volumeMounts = new ArrayList<VolumeMounts>();
            }
            for (VolumeMounts volumeMounts : elements) {
                this.volumeMounts.add(Objects.requireNonNull(volumeMounts, "volumeMounts element"));
            }
            return this;
        }

        public ServiceBindingEntity build() {
            return new ServiceBindingEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ServiceBindingEntity", generator="Immutables")
    static final class Json
    extends _ServiceBindingEntity {
        String applicationId;
        String applicationUrl;
        Map<String, Object> bindingOptions = null;
        Map<String, Object> credentials = null;
        GatewayData gatewayData;
        String gatewayName;
        LastOperation lastOperation;
        String name;
        String serviceBindingParametersUrl;
        String serviceInstanceId;
        String serviceInstanceUrl;
        String syslogDrainUrl;
        List<VolumeMounts> volumeMounts = null;

        Json() {
        }

        @JsonProperty(value="app_guid")
        public void setApplicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="app_url")
        public void setApplicationUrl(@Nullable String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        @JsonProperty(value="binding_options")
        public void setBindingOptions(@Nullable Map<String, Object> bindingOptions) {
            this.bindingOptions = bindingOptions;
        }

        @JsonProperty(value="credentials")
        public void setCredentials(@Nullable Map<String, Object> credentials) {
            this.credentials = credentials;
        }

        @JsonProperty(value="gateway_data")
        public void setGatewayData(@Nullable GatewayData gatewayData) {
            this.gatewayData = gatewayData;
        }

        @JsonProperty(value="gateway_name")
        public void setGatewayName(@Nullable String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @JsonProperty(value="last_operation")
        public void setLastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="service_binding_parameters_url")
        public void setServiceBindingParametersUrl(@Nullable String serviceBindingParametersUrl) {
            this.serviceBindingParametersUrl = serviceBindingParametersUrl;
        }

        @JsonProperty(value="service_instance_guid")
        public void setServiceInstanceId(@Nullable String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        @JsonProperty(value="service_instance_url")
        public void setServiceInstanceUrl(@Nullable String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
        }

        @JsonProperty(value="syslog_drain_url")
        public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
        }

        @JsonProperty(value="volume_mounts")
        public void setVolumeMounts(@Nullable List<VolumeMounts> volumeMounts) {
            this.volumeMounts = volumeMounts;
        }

        @Override
        public String getApplicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getApplicationUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getBindingOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GatewayData getGatewayData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGatewayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LastOperation getLastOperation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceBindingParametersUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSyslogDrainUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<VolumeMounts> getVolumeMounts() {
            throw new UnsupportedOperationException();
        }
    }
}

