/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.MaintenanceInfo;
import org.cloudfoundry.client.v2.serviceinstances.BaseServiceInstanceEntity;
import org.cloudfoundry.client.v2.serviceinstances.GatewayData;
import org.cloudfoundry.client.v2.serviceinstances.LastOperation;
import org.cloudfoundry.client.v2.serviceinstances._ServiceInstanceEntity;
import org.immutables.value.Generated;

@Generated(from="_ServiceInstanceEntity", generator="Immutables")
public final class ServiceInstanceEntity
extends _ServiceInstanceEntity {
    @Nullable
    private final Map<String, Object> credentials;
    @Nullable
    private final String name;
    @Nullable
    private final String routesUrl;
    @Nullable
    private final String serviceBindingsUrl;
    @Nullable
    private final String sharedFromUrl;
    @Nullable
    private final String sharedToUrl;
    @Nullable
    private final String spaceId;
    @Nullable
    private final String spaceUrl;
    @Nullable
    private final List<String> tags;
    @Nullable
    private final String type;
    @Nullable
    private final String dashboardUrl;
    @Nullable
    private final GatewayData gatewayData;
    @Nullable
    private final LastOperation lastOperation;
    @Nullable
    private final MaintenanceInfo maintenanceInfo;
    @Nullable
    private final String serviceId;
    @Nullable
    private final String serviceInstanceParametersUrl;
    @Nullable
    private final String serviceKeysUrl;
    @Nullable
    private final String servicePlanId;
    @Nullable
    private final String servicePlanUrl;
    @Nullable
    private final String serviceUrl;

    private ServiceInstanceEntity(Builder builder) {
        this.credentials = builder.credentials == null ? null : ServiceInstanceEntity.createUnmodifiableMap(false, false, builder.credentials);
        this.name = builder.name;
        this.routesUrl = builder.routesUrl;
        this.serviceBindingsUrl = builder.serviceBindingsUrl;
        this.sharedFromUrl = builder.sharedFromUrl;
        this.sharedToUrl = builder.sharedToUrl;
        this.spaceId = builder.spaceId;
        this.spaceUrl = builder.spaceUrl;
        this.tags = builder.tags == null ? null : ServiceInstanceEntity.createUnmodifiableList(true, builder.tags);
        this.type = builder.type;
        this.dashboardUrl = builder.dashboardUrl;
        this.gatewayData = builder.gatewayData;
        this.lastOperation = builder.lastOperation;
        this.maintenanceInfo = builder.maintenanceInfo;
        this.serviceId = builder.serviceId;
        this.serviceInstanceParametersUrl = builder.serviceInstanceParametersUrl;
        this.serviceKeysUrl = builder.serviceKeysUrl;
        this.servicePlanId = builder.servicePlanId;
        this.servicePlanUrl = builder.servicePlanUrl;
        this.serviceUrl = builder.serviceUrl;
    }

    @Override
    @JsonProperty(value="credentials")
    @Nullable
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="routes_url")
    @Nullable
    public String getRoutesUrl() {
        return this.routesUrl;
    }

    @Override
    @JsonProperty(value="service_bindings_url")
    @Nullable
    public String getServiceBindingsUrl() {
        return this.serviceBindingsUrl;
    }

    @Override
    @JsonProperty(value="shared_from_url")
    @Nullable
    public String getSharedFromUrl() {
        return this.sharedFromUrl;
    }

    @Override
    @JsonProperty(value="shared_to_url")
    @Nullable
    public String getSharedToUrl() {
        return this.sharedToUrl;
    }

    @Override
    @JsonProperty(value="space_guid")
    @Nullable
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @JsonProperty(value="space_url")
    @Nullable
    public String getSpaceUrl() {
        return this.spaceUrl;
    }

    @Override
    @JsonProperty(value="tags")
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="dashboard_url")
    @Nullable
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Override
    @JsonProperty(value="gateway_data")
    @Deprecated
    @Nullable
    public GatewayData getGatewayData() {
        return this.gatewayData;
    }

    @Override
    @JsonProperty(value="last_operation")
    @Nullable
    public LastOperation getLastOperation() {
        return this.lastOperation;
    }

    @Override
    @JsonProperty(value="maintenance_info")
    @Nullable
    public MaintenanceInfo getMaintenanceInfo() {
        return this.maintenanceInfo;
    }

    @Override
    @JsonProperty(value="service_guid")
    @Nullable
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="service_instance_parameters_url")
    @Nullable
    public String getServiceInstanceParametersUrl() {
        return this.serviceInstanceParametersUrl;
    }

    @Override
    @JsonProperty(value="service_keys_url")
    @Nullable
    public String getServiceKeysUrl() {
        return this.serviceKeysUrl;
    }

    @Override
    @JsonProperty(value="service_plan_guid")
    @Nullable
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    @Override
    @JsonProperty(value="service_plan_url")
    @Nullable
    public String getServicePlanUrl() {
        return this.servicePlanUrl;
    }

    @Override
    @JsonProperty(value="service_url")
    @Nullable
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceInstanceEntity && this.equalTo(0, (ServiceInstanceEntity)another);
    }

    private boolean equalTo(int synthetic, ServiceInstanceEntity another) {
        return Objects.equals(this.credentials, another.credentials) && Objects.equals(this.name, another.name) && Objects.equals(this.routesUrl, another.routesUrl) && Objects.equals(this.serviceBindingsUrl, another.serviceBindingsUrl) && Objects.equals(this.sharedFromUrl, another.sharedFromUrl) && Objects.equals(this.sharedToUrl, another.sharedToUrl) && Objects.equals(this.spaceId, another.spaceId) && Objects.equals(this.spaceUrl, another.spaceUrl) && Objects.equals(this.tags, another.tags) && Objects.equals(this.type, another.type) && Objects.equals(this.dashboardUrl, another.dashboardUrl) && Objects.equals(this.gatewayData, another.gatewayData) && Objects.equals(this.lastOperation, another.lastOperation) && Objects.equals(this.maintenanceInfo, another.maintenanceInfo) && Objects.equals(this.serviceId, another.serviceId) && Objects.equals(this.serviceInstanceParametersUrl, another.serviceInstanceParametersUrl) && Objects.equals(this.serviceKeysUrl, another.serviceKeysUrl) && Objects.equals(this.servicePlanId, another.servicePlanId) && Objects.equals(this.servicePlanUrl, another.servicePlanUrl) && Objects.equals(this.serviceUrl, another.serviceUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.credentials);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.routesUrl);
        h += (h << 5) + Objects.hashCode(this.serviceBindingsUrl);
        h += (h << 5) + Objects.hashCode(this.sharedFromUrl);
        h += (h << 5) + Objects.hashCode(this.sharedToUrl);
        h += (h << 5) + Objects.hashCode(this.spaceId);
        h += (h << 5) + Objects.hashCode(this.spaceUrl);
        h += (h << 5) + Objects.hashCode(this.tags);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.dashboardUrl);
        h += (h << 5) + Objects.hashCode(this.gatewayData);
        h += (h << 5) + Objects.hashCode(this.lastOperation);
        h += (h << 5) + Objects.hashCode(this.maintenanceInfo);
        h += (h << 5) + Objects.hashCode(this.serviceId);
        h += (h << 5) + Objects.hashCode(this.serviceInstanceParametersUrl);
        h += (h << 5) + Objects.hashCode(this.serviceKeysUrl);
        h += (h << 5) + Objects.hashCode(this.servicePlanId);
        h += (h << 5) + Objects.hashCode(this.servicePlanUrl);
        h += (h << 5) + Objects.hashCode(this.serviceUrl);
        return h;
    }

    public String toString() {
        return "ServiceInstanceEntity{credentials=" + this.credentials + ", name=" + this.name + ", routesUrl=" + this.routesUrl + ", serviceBindingsUrl=" + this.serviceBindingsUrl + ", sharedFromUrl=" + this.sharedFromUrl + ", sharedToUrl=" + this.sharedToUrl + ", spaceId=" + this.spaceId + ", spaceUrl=" + this.spaceUrl + ", tags=" + this.tags + ", type=" + this.type + ", dashboardUrl=" + this.dashboardUrl + ", gatewayData=" + this.gatewayData + ", lastOperation=" + this.lastOperation + ", maintenanceInfo=" + this.maintenanceInfo + ", serviceId=" + this.serviceId + ", serviceInstanceParametersUrl=" + this.serviceInstanceParametersUrl + ", serviceKeysUrl=" + this.serviceKeysUrl + ", servicePlanId=" + this.servicePlanId + ", servicePlanUrl=" + this.servicePlanUrl + ", serviceUrl=" + this.serviceUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ServiceInstanceEntity fromJson(Json json) {
        Builder builder = ServiceInstanceEntity.builder();
        if (json.credentials != null) {
            builder.putAllCredentials(json.credentials);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.routesUrl != null) {
            builder.routesUrl(json.routesUrl);
        }
        if (json.serviceBindingsUrl != null) {
            builder.serviceBindingsUrl(json.serviceBindingsUrl);
        }
        if (json.sharedFromUrl != null) {
            builder.sharedFromUrl(json.sharedFromUrl);
        }
        if (json.sharedToUrl != null) {
            builder.sharedToUrl(json.sharedToUrl);
        }
        if (json.spaceId != null) {
            builder.spaceId(json.spaceId);
        }
        if (json.spaceUrl != null) {
            builder.spaceUrl(json.spaceUrl);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.dashboardUrl != null) {
            builder.dashboardUrl(json.dashboardUrl);
        }
        if (json.gatewayData != null) {
            builder.gatewayData(json.gatewayData);
        }
        if (json.lastOperation != null) {
            builder.lastOperation(json.lastOperation);
        }
        if (json.maintenanceInfo != null) {
            builder.maintenanceInfo(json.maintenanceInfo);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.serviceInstanceParametersUrl != null) {
            builder.serviceInstanceParametersUrl(json.serviceInstanceParametersUrl);
        }
        if (json.serviceKeysUrl != null) {
            builder.serviceKeysUrl(json.serviceKeysUrl);
        }
        if (json.servicePlanId != null) {
            builder.servicePlanId(json.servicePlanId);
        }
        if (json.servicePlanUrl != null) {
            builder.servicePlanUrl(json.servicePlanUrl);
        }
        if (json.serviceUrl != null) {
            builder.serviceUrl(json.serviceUrl);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_ServiceInstanceEntity", generator="Immutables")
    public static final class Builder {
        private Map<String, Object> credentials = null;
        private String name;
        private String routesUrl;
        private String serviceBindingsUrl;
        private String sharedFromUrl;
        private String sharedToUrl;
        private String spaceId;
        private String spaceUrl;
        private List<String> tags = null;
        private String type;
        private String dashboardUrl;
        private GatewayData gatewayData;
        private LastOperation lastOperation;
        private MaintenanceInfo maintenanceInfo;
        private String serviceId;
        private String serviceInstanceParametersUrl;
        private String serviceKeysUrl;
        private String servicePlanId;
        private String servicePlanUrl;
        private String serviceUrl;

        private Builder() {
        }

        public final Builder from(ServiceInstanceEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ServiceInstanceEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BaseServiceInstanceEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BaseServiceInstanceEntity instance;
            if (object instanceof _ServiceInstanceEntity) {
                String servicePlanUrlValue;
                MaintenanceInfo maintenanceInfoValue;
                String serviceIdValue;
                String servicePlanIdValue;
                GatewayData gatewayDataValue;
                String serviceInstanceParametersUrlValue;
                String serviceUrlValue;
                String serviceKeysUrlValue;
                LastOperation lastOperationValue;
                instance = (_ServiceInstanceEntity)object;
                String dashboardUrlValue = ((_ServiceInstanceEntity)instance).getDashboardUrl();
                if (dashboardUrlValue != null) {
                    this.dashboardUrl(dashboardUrlValue);
                }
                if ((lastOperationValue = ((_ServiceInstanceEntity)instance).getLastOperation()) != null) {
                    this.lastOperation(lastOperationValue);
                }
                if ((serviceKeysUrlValue = ((_ServiceInstanceEntity)instance).getServiceKeysUrl()) != null) {
                    this.serviceKeysUrl(serviceKeysUrlValue);
                }
                if ((serviceUrlValue = ((_ServiceInstanceEntity)instance).getServiceUrl()) != null) {
                    this.serviceUrl(serviceUrlValue);
                }
                if ((serviceInstanceParametersUrlValue = ((_ServiceInstanceEntity)instance).getServiceInstanceParametersUrl()) != null) {
                    this.serviceInstanceParametersUrl(serviceInstanceParametersUrlValue);
                }
                if ((gatewayDataValue = ((_ServiceInstanceEntity)instance).getGatewayData()) != null) {
                    this.gatewayData(gatewayDataValue);
                }
                if ((servicePlanIdValue = ((_ServiceInstanceEntity)instance).getServicePlanId()) != null) {
                    this.servicePlanId(servicePlanIdValue);
                }
                if ((serviceIdValue = ((_ServiceInstanceEntity)instance).getServiceId()) != null) {
                    this.serviceId(serviceIdValue);
                }
                if ((maintenanceInfoValue = ((_ServiceInstanceEntity)instance).getMaintenanceInfo()) != null) {
                    this.maintenanceInfo(maintenanceInfoValue);
                }
                if ((servicePlanUrlValue = ((_ServiceInstanceEntity)instance).getServicePlanUrl()) != null) {
                    this.servicePlanUrl(servicePlanUrlValue);
                }
            }
            if (object instanceof BaseServiceInstanceEntity) {
                List<String> tagsValue;
                String routesUrlValue;
                String sharedToUrlValue;
                String typeValue;
                String serviceBindingsUrlValue;
                String nameValue;
                Map<String, Object> credentialsValue;
                String sharedFromUrlValue;
                String spaceIdValue;
                instance = (BaseServiceInstanceEntity)object;
                String spaceUrlValue = instance.getSpaceUrl();
                if (spaceUrlValue != null) {
                    this.spaceUrl(spaceUrlValue);
                }
                if ((spaceIdValue = instance.getSpaceId()) != null) {
                    this.spaceId(spaceIdValue);
                }
                if ((sharedFromUrlValue = instance.getSharedFromUrl()) != null) {
                    this.sharedFromUrl(sharedFromUrlValue);
                }
                if ((credentialsValue = instance.getCredentials()) != null) {
                    this.putAllCredentials(credentialsValue);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((serviceBindingsUrlValue = instance.getServiceBindingsUrl()) != null) {
                    this.serviceBindingsUrl(serviceBindingsUrlValue);
                }
                if ((typeValue = instance.getType()) != null) {
                    this.type(typeValue);
                }
                if ((sharedToUrlValue = instance.getSharedToUrl()) != null) {
                    this.sharedToUrl(sharedToUrlValue);
                }
                if ((routesUrlValue = instance.getRoutesUrl()) != null) {
                    this.routesUrl(routesUrlValue);
                }
                if ((tagsValue = instance.getTags()) != null) {
                    this.addAllTags(tagsValue);
                }
            }
        }

        public final Builder credential(String key, Object value) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            this.credentials.put(key, value);
            return this;
        }

        public final Builder credential(Map.Entry<String, ? extends Object> entry) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.credentials.put(k, v);
            return this;
        }

        @JsonProperty(value="credentials")
        public final Builder credentials(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.credentials = null;
                return this;
            }
            this.credentials = new LinkedHashMap<String, Object>();
            return this.putAllCredentials(entries);
        }

        public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.credentials.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="routes_url")
        public final Builder routesUrl(@Nullable String routesUrl) {
            this.routesUrl = routesUrl;
            return this;
        }

        @JsonProperty(value="service_bindings_url")
        public final Builder serviceBindingsUrl(@Nullable String serviceBindingsUrl) {
            this.serviceBindingsUrl = serviceBindingsUrl;
            return this;
        }

        @JsonProperty(value="shared_from_url")
        public final Builder sharedFromUrl(@Nullable String sharedFromUrl) {
            this.sharedFromUrl = sharedFromUrl;
            return this;
        }

        @JsonProperty(value="shared_to_url")
        public final Builder sharedToUrl(@Nullable String sharedToUrl) {
            this.sharedToUrl = sharedToUrl;
            return this;
        }

        @JsonProperty(value="space_guid")
        public final Builder spaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @JsonProperty(value="space_url")
        public final Builder spaceUrl(@Nullable String spaceUrl) {
            this.spaceUrl = spaceUrl;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tags(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="tags")
        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="dashboard_url")
        public final Builder dashboardUrl(@Nullable String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
            return this;
        }

        @JsonProperty(value="gateway_data")
        @Deprecated
        public final Builder gatewayData(@Nullable GatewayData gatewayData) {
            this.gatewayData = gatewayData;
            return this;
        }

        @JsonProperty(value="last_operation")
        public final Builder lastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        @JsonProperty(value="maintenance_info")
        public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
            this.maintenanceInfo = maintenanceInfo;
            return this;
        }

        @JsonProperty(value="service_guid")
        public final Builder serviceId(@Nullable String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @JsonProperty(value="service_instance_parameters_url")
        public final Builder serviceInstanceParametersUrl(@Nullable String serviceInstanceParametersUrl) {
            this.serviceInstanceParametersUrl = serviceInstanceParametersUrl;
            return this;
        }

        @JsonProperty(value="service_keys_url")
        public final Builder serviceKeysUrl(@Nullable String serviceKeysUrl) {
            this.serviceKeysUrl = serviceKeysUrl;
            return this;
        }

        @JsonProperty(value="service_plan_guid")
        public final Builder servicePlanId(@Nullable String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        @JsonProperty(value="service_plan_url")
        public final Builder servicePlanUrl(@Nullable String servicePlanUrl) {
            this.servicePlanUrl = servicePlanUrl;
            return this;
        }

        @JsonProperty(value="service_url")
        public final Builder serviceUrl(@Nullable String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public ServiceInstanceEntity build() {
            return new ServiceInstanceEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ServiceInstanceEntity", generator="Immutables")
    static final class Json
    extends _ServiceInstanceEntity {
        Map<String, Object> credentials = null;
        String name;
        String routesUrl;
        String serviceBindingsUrl;
        String sharedFromUrl;
        String sharedToUrl;
        String spaceId;
        String spaceUrl;
        List<String> tags = null;
        String type;
        String dashboardUrl;
        GatewayData gatewayData;
        LastOperation lastOperation;
        MaintenanceInfo maintenanceInfo;
        String serviceId;
        String serviceInstanceParametersUrl;
        String serviceKeysUrl;
        String servicePlanId;
        String servicePlanUrl;
        String serviceUrl;

        Json() {
        }

        @JsonProperty(value="credentials")
        public void setCredentials(@Nullable Map<String, Object> credentials) {
            this.credentials = credentials;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="routes_url")
        public void setRoutesUrl(@Nullable String routesUrl) {
            this.routesUrl = routesUrl;
        }

        @JsonProperty(value="service_bindings_url")
        public void setServiceBindingsUrl(@Nullable String serviceBindingsUrl) {
            this.serviceBindingsUrl = serviceBindingsUrl;
        }

        @JsonProperty(value="shared_from_url")
        public void setSharedFromUrl(@Nullable String sharedFromUrl) {
            this.sharedFromUrl = sharedFromUrl;
        }

        @JsonProperty(value="shared_to_url")
        public void setSharedToUrl(@Nullable String sharedToUrl) {
            this.sharedToUrl = sharedToUrl;
        }

        @JsonProperty(value="space_guid")
        public void setSpaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
        }

        @JsonProperty(value="space_url")
        public void setSpaceUrl(@Nullable String spaceUrl) {
            this.spaceUrl = spaceUrl;
        }

        @JsonProperty(value="tags")
        public void setTags(@Nullable List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="dashboard_url")
        public void setDashboardUrl(@Nullable String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
        }

        @JsonProperty(value="gateway_data")
        public void setGatewayData(@Nullable GatewayData gatewayData) {
            this.gatewayData = gatewayData;
        }

        @JsonProperty(value="last_operation")
        public void setLastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
        }

        @JsonProperty(value="maintenance_info")
        public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
            this.maintenanceInfo = maintenanceInfo;
        }

        @JsonProperty(value="service_guid")
        public void setServiceId(@Nullable String serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="service_instance_parameters_url")
        public void setServiceInstanceParametersUrl(@Nullable String serviceInstanceParametersUrl) {
            this.serviceInstanceParametersUrl = serviceInstanceParametersUrl;
        }

        @JsonProperty(value="service_keys_url")
        public void setServiceKeysUrl(@Nullable String serviceKeysUrl) {
            this.serviceKeysUrl = serviceKeysUrl;
        }

        @JsonProperty(value="service_plan_guid")
        public void setServicePlanId(@Nullable String servicePlanId) {
            this.servicePlanId = servicePlanId;
        }

        @JsonProperty(value="service_plan_url")
        public void setServicePlanUrl(@Nullable String servicePlanUrl) {
            this.servicePlanUrl = servicePlanUrl;
        }

        @JsonProperty(value="service_url")
        public void setServiceUrl(@Nullable String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        @Override
        public Map<String, Object> getCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRoutesUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceBindingsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSharedFromUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSharedToUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpaceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpaceUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDashboardUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GatewayData getGatewayData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LastOperation getLastOperation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MaintenanceInfo getMaintenanceInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceParametersUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceKeysUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServicePlanId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServicePlanUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

