/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import org.cloudfoundry.Nullable;
import org.cloudfoundry.QueryParameter;
import org.immutables.value.Value;

public abstract class PaginatedRequest {
    @Nullable
    @QueryParameter(value="order_by")
    public abstract String getOrderBy();

    @Nullable
    @QueryParameter(value="page")
    public abstract Integer getPage();

    @Nullable
    @QueryParameter(value="per_page")
    public abstract Integer getPerPage();

    @Value.Check
    public void check() {
        if (this.getPage() != null && this.getPage() < 1) {
            throw new IllegalStateException("page must be greater than or equal to 1");
        }
        if (this.getPerPage() != null && (this.getPerPage() < 1 || this.getPerPage() > 5000)) {
            throw new IllegalStateException("perPage much be between 1 and 5000 inclusive");
        }
    }
}

