/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3._UsageSummary;
import org.immutables.value.Generated;

@Generated(from="_UsageSummary", generator="Immutables")
public final class UsageSummary
extends _UsageSummary {
    private final Integer memoryInMb;
    private final Integer startedInstances;
    @Nullable
    private final Integer routes;
    @Nullable
    private final Integer serviceInstances;
    @Nullable
    private final Integer reservedPorts;
    @Nullable
    private final Integer domains;
    @Nullable
    private final Integer perAppTasks;
    @Nullable
    private final Integer serviceKeys;

    private UsageSummary(Builder builder) {
        this.memoryInMb = builder.memoryInMb;
        this.startedInstances = builder.startedInstances;
        this.routes = builder.routes;
        this.serviceInstances = builder.serviceInstances;
        this.reservedPorts = builder.reservedPorts;
        this.domains = builder.domains;
        this.perAppTasks = builder.perAppTasks;
        this.serviceKeys = builder.serviceKeys;
    }

    @Override
    @JsonProperty(value="memory_in_mb")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    @JsonProperty(value="started_instances")
    public Integer getStartedInstances() {
        return this.startedInstances;
    }

    @Override
    @JsonProperty(value="routes")
    @Nullable
    public Integer getRoutes() {
        return this.routes;
    }

    @Override
    @JsonProperty(value="service_instances")
    @Nullable
    public Integer getServiceInstances() {
        return this.serviceInstances;
    }

    @Override
    @JsonProperty(value="reserved_ports")
    @Nullable
    public Integer getReservedPorts() {
        return this.reservedPorts;
    }

    @Override
    @JsonProperty(value="domains")
    @Nullable
    public Integer getDomains() {
        return this.domains;
    }

    @Override
    @JsonProperty(value="per_app_tasks")
    @Nullable
    public Integer getPerAppTasks() {
        return this.perAppTasks;
    }

    @Override
    @JsonProperty(value="service_keys")
    @Nullable
    public Integer getServiceKeys() {
        return this.serviceKeys;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsageSummary && this.equalTo(0, (UsageSummary)another);
    }

    private boolean equalTo(int synthetic, UsageSummary another) {
        return this.memoryInMb.equals(another.memoryInMb) && this.startedInstances.equals(another.startedInstances) && Objects.equals(this.routes, another.routes) && Objects.equals(this.serviceInstances, another.serviceInstances) && Objects.equals(this.reservedPorts, another.reservedPorts) && Objects.equals(this.domains, another.domains) && Objects.equals(this.perAppTasks, another.perAppTasks) && Objects.equals(this.serviceKeys, another.serviceKeys);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.memoryInMb.hashCode();
        h += (h << 5) + this.startedInstances.hashCode();
        h += (h << 5) + Objects.hashCode(this.routes);
        h += (h << 5) + Objects.hashCode(this.serviceInstances);
        h += (h << 5) + Objects.hashCode(this.reservedPorts);
        h += (h << 5) + Objects.hashCode(this.domains);
        h += (h << 5) + Objects.hashCode(this.perAppTasks);
        h += (h << 5) + Objects.hashCode(this.serviceKeys);
        return h;
    }

    public String toString() {
        return "UsageSummary{memoryInMb=" + this.memoryInMb + ", startedInstances=" + this.startedInstances + ", routes=" + this.routes + ", serviceInstances=" + this.serviceInstances + ", reservedPorts=" + this.reservedPorts + ", domains=" + this.domains + ", perAppTasks=" + this.perAppTasks + ", serviceKeys=" + this.serviceKeys + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsageSummary fromJson(Json json) {
        Builder builder = UsageSummary.builder();
        if (json.memoryInMb != null) {
            builder.memoryInMb(json.memoryInMb);
        }
        if (json.startedInstances != null) {
            builder.startedInstances(json.startedInstances);
        }
        if (json.routes != null) {
            builder.routes(json.routes);
        }
        if (json.serviceInstances != null) {
            builder.serviceInstances(json.serviceInstances);
        }
        if (json.reservedPorts != null) {
            builder.reservedPorts(json.reservedPorts);
        }
        if (json.domains != null) {
            builder.domains(json.domains);
        }
        if (json.perAppTasks != null) {
            builder.perAppTasks(json.perAppTasks);
        }
        if (json.serviceKeys != null) {
            builder.serviceKeys(json.serviceKeys);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_UsageSummary", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MEMORY_IN_MB = 1L;
        private static final long INIT_BIT_STARTED_INSTANCES = 2L;
        private long initBits = 3L;
        private Integer memoryInMb;
        private Integer startedInstances;
        private Integer routes;
        private Integer serviceInstances;
        private Integer reservedPorts;
        private Integer domains;
        private Integer perAppTasks;
        private Integer serviceKeys;

        private Builder() {
        }

        public final Builder from(UsageSummary instance) {
            return this.from((_UsageSummary)instance);
        }

        final Builder from(_UsageSummary instance) {
            Integer serviceKeysValue;
            Integer perAppTasksValue;
            Integer domainsValue;
            Integer reservedPortsValue;
            Integer serviceInstancesValue;
            Objects.requireNonNull(instance, "instance");
            this.memoryInMb(instance.getMemoryInMb());
            this.startedInstances(instance.getStartedInstances());
            Integer routesValue = instance.getRoutes();
            if (routesValue != null) {
                this.routes(routesValue);
            }
            if ((serviceInstancesValue = instance.getServiceInstances()) != null) {
                this.serviceInstances(serviceInstancesValue);
            }
            if ((reservedPortsValue = instance.getReservedPorts()) != null) {
                this.reservedPorts(reservedPortsValue);
            }
            if ((domainsValue = instance.getDomains()) != null) {
                this.domains(domainsValue);
            }
            if ((perAppTasksValue = instance.getPerAppTasks()) != null) {
                this.perAppTasks(perAppTasksValue);
            }
            if ((serviceKeysValue = instance.getServiceKeys()) != null) {
                this.serviceKeys(serviceKeysValue);
            }
            return this;
        }

        @JsonProperty(value="memory_in_mb")
        public final Builder memoryInMb(Integer memoryInMb) {
            this.memoryInMb = Objects.requireNonNull(memoryInMb, "memoryInMb");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="started_instances")
        public final Builder startedInstances(Integer startedInstances) {
            this.startedInstances = Objects.requireNonNull(startedInstances, "startedInstances");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="routes")
        public final Builder routes(@Nullable Integer routes) {
            this.routes = routes;
            return this;
        }

        @JsonProperty(value="service_instances")
        public final Builder serviceInstances(@Nullable Integer serviceInstances) {
            this.serviceInstances = serviceInstances;
            return this;
        }

        @JsonProperty(value="reserved_ports")
        public final Builder reservedPorts(@Nullable Integer reservedPorts) {
            this.reservedPorts = reservedPorts;
            return this;
        }

        @JsonProperty(value="domains")
        public final Builder domains(@Nullable Integer domains) {
            this.domains = domains;
            return this;
        }

        @JsonProperty(value="per_app_tasks")
        public final Builder perAppTasks(@Nullable Integer perAppTasks) {
            this.perAppTasks = perAppTasks;
            return this;
        }

        @JsonProperty(value="service_keys")
        public final Builder serviceKeys(@Nullable Integer serviceKeys) {
            this.serviceKeys = serviceKeys;
            return this;
        }

        public UsageSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UsageSummary(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("memoryInMb");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("startedInstances");
            }
            return "Cannot build UsageSummary, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UsageSummary", generator="Immutables")
    static final class Json
    extends _UsageSummary {
        Integer memoryInMb;
        Integer startedInstances;
        Integer routes;
        Integer serviceInstances;
        Integer reservedPorts;
        Integer domains;
        Integer perAppTasks;
        Integer serviceKeys;

        Json() {
        }

        @JsonProperty(value="memory_in_mb")
        public void setMemoryInMb(Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
        }

        @JsonProperty(value="started_instances")
        public void setStartedInstances(Integer startedInstances) {
            this.startedInstances = startedInstances;
        }

        @JsonProperty(value="routes")
        public void setRoutes(@Nullable Integer routes) {
            this.routes = routes;
        }

        @JsonProperty(value="service_instances")
        public void setServiceInstances(@Nullable Integer serviceInstances) {
            this.serviceInstances = serviceInstances;
        }

        @JsonProperty(value="reserved_ports")
        public void setReservedPorts(@Nullable Integer reservedPorts) {
            this.reservedPorts = reservedPorts;
        }

        @JsonProperty(value="domains")
        public void setDomains(@Nullable Integer domains) {
            this.domains = domains;
        }

        @JsonProperty(value="per_app_tasks")
        public void setPerAppTasks(@Nullable Integer perAppTasks) {
            this.perAppTasks = perAppTasks;
        }

        @JsonProperty(value="service_keys")
        public void setServiceKeys(@Nullable Integer serviceKeys) {
            this.serviceKeys = serviceKeys;
        }

        @Override
        public Integer getMemoryInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStartedInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getRoutes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getServiceInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getReservedPorts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getDomains() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPerAppTasks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getServiceKeys() {
            throw new UnsupportedOperationException();
        }
    }
}

