/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.applications._ListApplicationTasksRequest;
import org.cloudfoundry.client.v3.packages.PackageState;
import org.immutables.value.Generated;

@Generated(from="_ListApplicationTasksRequest", generator="Immutables")
public final class ListApplicationTasksRequest
extends _ListApplicationTasksRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final String applicationId;
    private final List<String> names;
    private final List<String> sequenceIds;
    private final List<PackageState> states;
    private final List<String> taskIds;

    private ListApplicationTasksRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.applicationId = builder.applicationId;
        this.names = ListApplicationTasksRequest.createUnmodifiableList(true, builder.names);
        this.sequenceIds = ListApplicationTasksRequest.createUnmodifiableList(true, builder.sequenceIds);
        this.states = ListApplicationTasksRequest.createUnmodifiableList(true, builder.states);
        this.taskIds = ListApplicationTasksRequest.createUnmodifiableList(true, builder.taskIds);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public List<String> getSequenceIds() {
        return this.sequenceIds;
    }

    @Override
    public List<PackageState> getStates() {
        return this.states;
    }

    @Override
    public List<String> getTaskIds() {
        return this.taskIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListApplicationTasksRequest && this.equalTo(0, (ListApplicationTasksRequest)another);
    }

    private boolean equalTo(int synthetic, ListApplicationTasksRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.applicationId.equals(another.applicationId) && this.names.equals(another.names) && this.sequenceIds.equals(another.sequenceIds) && this.states.equals(another.states) && this.taskIds.equals(another.taskIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + this.names.hashCode();
        h += (h << 5) + this.sequenceIds.hashCode();
        h += (h << 5) + this.states.hashCode();
        h += (h << 5) + this.taskIds.hashCode();
        return h;
    }

    public String toString() {
        return "ListApplicationTasksRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", applicationId=" + this.applicationId + ", names=" + this.names + ", sequenceIds=" + this.sequenceIds + ", states=" + this.states + ", taskIds=" + this.taskIds + "}";
    }

    private static ListApplicationTasksRequest validate(ListApplicationTasksRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListApplicationTasksRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private String applicationId;
        private List<String> names = new ArrayList<String>();
        private List<String> sequenceIds = new ArrayList<String>();
        private List<PackageState> states = new ArrayList<PackageState>();
        private List<String> taskIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ListApplicationTasksRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListApplicationTasksRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListApplicationTasksRequest) {
                instance = (_ListApplicationTasksRequest)object;
                this.addAllNames(((_ListApplicationTasksRequest)instance).getNames());
                this.addAllTaskIds(((_ListApplicationTasksRequest)instance).getTaskIds());
                this.applicationId(((_ListApplicationTasksRequest)instance).getApplicationId());
                this.addAllSequenceIds(((_ListApplicationTasksRequest)instance).getSequenceIds());
                this.addAllStates(((_ListApplicationTasksRequest)instance).getStates());
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder sequenceId(String element) {
            this.sequenceIds.add(Objects.requireNonNull(element, "sequenceIds element"));
            return this;
        }

        public final Builder sequenceIds(String ... elements) {
            for (String element : elements) {
                this.sequenceIds.add(Objects.requireNonNull(element, "sequenceIds element"));
            }
            return this;
        }

        public final Builder sequenceIds(Iterable<String> elements) {
            this.sequenceIds.clear();
            return this.addAllSequenceIds(elements);
        }

        public final Builder addAllSequenceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.sequenceIds.add(Objects.requireNonNull(element, "sequenceIds element"));
            }
            return this;
        }

        public final Builder state(PackageState element) {
            this.states.add(Objects.requireNonNull(element, "states element"));
            return this;
        }

        public final Builder states(PackageState ... elements) {
            for (PackageState element : elements) {
                this.states.add(Objects.requireNonNull(element, "states element"));
            }
            return this;
        }

        public final Builder states(Iterable<? extends PackageState> elements) {
            this.states.clear();
            return this.addAllStates(elements);
        }

        public final Builder addAllStates(Iterable<? extends PackageState> elements) {
            for (PackageState packageState : elements) {
                this.states.add(Objects.requireNonNull(packageState, "states element"));
            }
            return this;
        }

        public final Builder taskId(String element) {
            this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
            return this;
        }

        public final Builder taskIds(String ... elements) {
            for (String element : elements) {
                this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
            }
            return this;
        }

        public final Builder taskIds(Iterable<String> elements) {
            this.taskIds.clear();
            return this.addAllTaskIds(elements);
        }

        public final Builder addAllTaskIds(Iterable<String> elements) {
            for (String element : elements) {
                this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
            }
            return this;
        }

        public ListApplicationTasksRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ListApplicationTasksRequest.validate(new ListApplicationTasksRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build ListApplicationTasksRequest, some of required attributes are not set " + attributes;
        }
    }
}

