/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.buildpacks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.buildpacks._ListBuildpacksRequest;
import org.immutables.value.Generated;

@Generated(from="_ListBuildpacksRequest", generator="Immutables")
public final class ListBuildpacksRequest
extends _ListBuildpacksRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    @Nullable
    private final List<String> names;
    @Nullable
    private final List<String> stacks;

    private ListBuildpacksRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.names = builder.names == null ? null : ListBuildpacksRequest.createUnmodifiableList(true, builder.names);
        this.stacks = builder.stacks == null ? null : ListBuildpacksRequest.createUnmodifiableList(true, builder.stacks);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public List<String> getStacks() {
        return this.stacks;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListBuildpacksRequest && this.equalTo(0, (ListBuildpacksRequest)another);
    }

    private boolean equalTo(int synthetic, ListBuildpacksRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && Objects.equals(this.names, another.names) && Objects.equals(this.stacks, another.stacks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + Objects.hashCode(this.stacks);
        return h;
    }

    public String toString() {
        return "ListBuildpacksRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", names=" + this.names + ", stacks=" + this.stacks + "}";
    }

    private static ListBuildpacksRequest validate(ListBuildpacksRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListBuildpacksRequest", generator="Immutables")
    public static final class Builder {
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> names = null;
        private List<String> stacks = null;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ListBuildpacksRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListBuildpacksRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListBuildpacksRequest) {
                List<String> namesValue;
                instance = (_ListBuildpacksRequest)object;
                List<String> stacksValue = ((_ListBuildpacksRequest)instance).getStacks();
                if (stacksValue != null) {
                    this.addAllStacks(stacksValue);
                }
                if ((namesValue = ((_ListBuildpacksRequest)instance).getNames()) != null) {
                    this.addAllNames(namesValue);
                }
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder stack(String element) {
            if (this.stacks == null) {
                this.stacks = new ArrayList<String>();
            }
            this.stacks.add(Objects.requireNonNull(element, "stacks element"));
            return this;
        }

        public final Builder stacks(String ... elements) {
            if (this.stacks == null) {
                this.stacks = new ArrayList<String>();
            }
            for (String element : elements) {
                this.stacks.add(Objects.requireNonNull(element, "stacks element"));
            }
            return this;
        }

        public final Builder stacks(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.stacks = null;
                return this;
            }
            this.stacks = new ArrayList<String>();
            return this.addAllStacks(elements);
        }

        public final Builder addAllStacks(Iterable<String> elements) {
            Objects.requireNonNull(elements, "stacks element");
            if (this.stacks == null) {
                this.stacks = new ArrayList<String>();
            }
            for (String element : elements) {
                this.stacks.add(Objects.requireNonNull(element, "stacks element"));
            }
            return this;
        }

        public ListBuildpacksRequest build() {
            return ListBuildpacksRequest.validate(new ListBuildpacksRequest(this));
        }
    }
}

