/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListIsolationSegmentsRequest", generator="Immutables")
public final class ListIsolationSegmentsRequest
extends _ListIsolationSegmentsRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final List<String> isolationSegmentIds;
    private final List<String> names;
    private final List<String> organizationIds;

    private ListIsolationSegmentsRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.isolationSegmentIds = ListIsolationSegmentsRequest.createUnmodifiableList(true, builder.isolationSegmentIds);
        this.names = ListIsolationSegmentsRequest.createUnmodifiableList(true, builder.names);
        this.organizationIds = ListIsolationSegmentsRequest.createUnmodifiableList(true, builder.organizationIds);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public List<String> getIsolationSegmentIds() {
        return this.isolationSegmentIds;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListIsolationSegmentsRequest && this.equalTo(0, (ListIsolationSegmentsRequest)another);
    }

    private boolean equalTo(int synthetic, ListIsolationSegmentsRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.isolationSegmentIds.equals(another.isolationSegmentIds) && this.names.equals(another.names) && this.organizationIds.equals(another.organizationIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.isolationSegmentIds.hashCode();
        h += (h << 5) + this.names.hashCode();
        h += (h << 5) + this.organizationIds.hashCode();
        return h;
    }

    public String toString() {
        return "ListIsolationSegmentsRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", isolationSegmentIds=" + this.isolationSegmentIds + ", names=" + this.names + ", organizationIds=" + this.organizationIds + "}";
    }

    private static ListIsolationSegmentsRequest validate(ListIsolationSegmentsRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListIsolationSegmentsRequest", generator="Immutables")
    public static final class Builder {
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> isolationSegmentIds = new ArrayList<String>();
        private List<String> names = new ArrayList<String>();
        private List<String> organizationIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ListIsolationSegmentsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListIsolationSegmentsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListIsolationSegmentsRequest) {
                instance = (_ListIsolationSegmentsRequest)object;
                this.addAllOrganizationIds(((_ListIsolationSegmentsRequest)instance).getOrganizationIds());
                this.addAllIsolationSegmentIds(((_ListIsolationSegmentsRequest)instance).getIsolationSegmentIds());
                this.addAllNames(((_ListIsolationSegmentsRequest)instance).getNames());
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder isolationSegmentId(String element) {
            this.isolationSegmentIds.add(Objects.requireNonNull(element, "isolationSegmentIds element"));
            return this;
        }

        public final Builder isolationSegmentIds(String ... elements) {
            for (String element : elements) {
                this.isolationSegmentIds.add(Objects.requireNonNull(element, "isolationSegmentIds element"));
            }
            return this;
        }

        public final Builder isolationSegmentIds(Iterable<String> elements) {
            this.isolationSegmentIds.clear();
            return this.addAllIsolationSegmentIds(elements);
        }

        public final Builder addAllIsolationSegmentIds(Iterable<String> elements) {
            for (String element : elements) {
                this.isolationSegmentIds.add(Objects.requireNonNull(element, "isolationSegmentIds element"));
            }
            return this;
        }

        public final Builder name(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public ListIsolationSegmentsRequest build() {
            return ListIsolationSegmentsRequest.validate(new ListIsolationSegmentsRequest(this));
        }
    }
}

