/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.packages.PackageRelationships;
import org.cloudfoundry.client.v3.packages._CopyPackageRequest;
import org.immutables.value.Generated;

@Generated(from="_CopyPackageRequest", generator="Immutables")
public final class CopyPackageRequest
extends _CopyPackageRequest {
    private final PackageRelationships relationships;
    private final String sourcePackageId;

    private CopyPackageRequest(Builder builder) {
        this.relationships = builder.relationships;
        this.sourcePackageId = builder.sourcePackageId;
    }

    @Override
    @JsonProperty(value="relationships")
    public PackageRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonIgnore
    public String getSourcePackageId() {
        return this.sourcePackageId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CopyPackageRequest && this.equalTo(0, (CopyPackageRequest)another);
    }

    private boolean equalTo(int synthetic, CopyPackageRequest another) {
        return this.relationships.equals(another.relationships) && this.sourcePackageId.equals(another.sourcePackageId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.sourcePackageId.hashCode();
        return h;
    }

    public String toString() {
        return "CopyPackageRequest{relationships=" + this.relationships + ", sourcePackageId=" + this.sourcePackageId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CopyPackageRequest fromJson(Json json) {
        Builder builder = CopyPackageRequest.builder();
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.sourcePackageId != null) {
            builder.sourcePackageId(json.sourcePackageId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CopyPackageRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RELATIONSHIPS = 1L;
        private static final long INIT_BIT_SOURCE_PACKAGE_ID = 2L;
        private long initBits = 3L;
        private PackageRelationships relationships;
        private String sourcePackageId;

        private Builder() {
        }

        public final Builder from(CopyPackageRequest instance) {
            return this.from((_CopyPackageRequest)instance);
        }

        final Builder from(_CopyPackageRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.relationships(instance.getRelationships());
            this.sourcePackageId(instance.getSourcePackageId());
            return this;
        }

        public final Builder relationships(PackageRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sourcePackageId(String sourcePackageId) {
            this.sourcePackageId = Objects.requireNonNull(sourcePackageId, "sourcePackageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CopyPackageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CopyPackageRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sourcePackageId");
            }
            return "Cannot build CopyPackageRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CopyPackageRequest", generator="Immutables")
    static final class Json
    extends _CopyPackageRequest {
        PackageRelationships relationships;
        String sourcePackageId;

        Json() {
        }

        @JsonProperty(value="relationships")
        public void setRelationships(PackageRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonIgnore
        public void setSourcePackageId(String sourcePackageId) {
            this.sourcePackageId = sourcePackageId;
        }

        @Override
        public PackageRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSourcePackageId() {
            throw new UnsupportedOperationException();
        }
    }
}

