/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.droplets.DropletState;
import org.cloudfoundry.client.v3.packages._ListPackageDropletsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListPackageDropletsRequest", generator="Immutables")
public final class ListPackageDropletsRequest
extends _ListPackageDropletsRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final List<String> dropletIds;
    private final String packageId;
    private final List<DropletState> states;

    private ListPackageDropletsRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.dropletIds = ListPackageDropletsRequest.createUnmodifiableList(true, builder.dropletIds);
        this.packageId = builder.packageId;
        this.states = ListPackageDropletsRequest.createUnmodifiableList(true, builder.states);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public List<String> getDropletIds() {
        return this.dropletIds;
    }

    @Override
    public String getPackageId() {
        return this.packageId;
    }

    @Override
    public List<DropletState> getStates() {
        return this.states;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListPackageDropletsRequest && this.equalTo(0, (ListPackageDropletsRequest)another);
    }

    private boolean equalTo(int synthetic, ListPackageDropletsRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.dropletIds.equals(another.dropletIds) && this.packageId.equals(another.packageId) && this.states.equals(another.states);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.dropletIds.hashCode();
        h += (h << 5) + this.packageId.hashCode();
        h += (h << 5) + this.states.hashCode();
        return h;
    }

    public String toString() {
        return "ListPackageDropletsRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", dropletIds=" + this.dropletIds + ", packageId=" + this.packageId + ", states=" + this.states + "}";
    }

    private static ListPackageDropletsRequest validate(ListPackageDropletsRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListPackageDropletsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PACKAGE_ID = 1L;
        private long initBits = 1L;
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> dropletIds = new ArrayList<String>();
        private String packageId;
        private List<DropletState> states = new ArrayList<DropletState>();

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ListPackageDropletsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListPackageDropletsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListPackageDropletsRequest) {
                instance = (_ListPackageDropletsRequest)object;
                this.packageId(((_ListPackageDropletsRequest)instance).getPackageId());
                this.addAllDropletIds(((_ListPackageDropletsRequest)instance).getDropletIds());
                this.addAllStates(((_ListPackageDropletsRequest)instance).getStates());
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder dropletId(String element) {
            this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
            return this;
        }

        public final Builder dropletIds(String ... elements) {
            for (String element : elements) {
                this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
            }
            return this;
        }

        public final Builder dropletIds(Iterable<String> elements) {
            this.dropletIds.clear();
            return this.addAllDropletIds(elements);
        }

        public final Builder addAllDropletIds(Iterable<String> elements) {
            for (String element : elements) {
                this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
            }
            return this;
        }

        public final Builder packageId(String packageId) {
            this.packageId = Objects.requireNonNull(packageId, "packageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder state(DropletState element) {
            this.states.add(Objects.requireNonNull(element, "states element"));
            return this;
        }

        public final Builder states(DropletState ... elements) {
            for (DropletState element : elements) {
                this.states.add(Objects.requireNonNull(element, "states element"));
            }
            return this;
        }

        public final Builder states(Iterable<? extends DropletState> elements) {
            this.states.clear();
            return this.addAllStates(elements);
        }

        public final Builder addAllStates(Iterable<? extends DropletState> elements) {
            for (DropletState dropletState : elements) {
                this.states.add(Objects.requireNonNull(dropletState, "states element"));
            }
            return this;
        }

        public ListPackageDropletsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ListPackageDropletsRequest.validate(new ListPackageDropletsRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("packageId");
            }
            return "Cannot build ListPackageDropletsRequest, some of required attributes are not set " + attributes;
        }
    }
}

