/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.packages.PackageState;
import org.cloudfoundry.client.v3.packages.PackageType;
import org.cloudfoundry.client.v3.packages._ListPackagesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListPackagesRequest", generator="Immutables")
public final class ListPackagesRequest
extends _ListPackagesRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final List<String> applicationIds;
    private final List<String> organizationIds;
    private final List<String> packageIds;
    private final List<String> spaceIds;
    private final List<PackageState> states;
    private final List<PackageType> types;

    private ListPackagesRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.applicationIds = ListPackagesRequest.createUnmodifiableList(true, builder.applicationIds);
        this.organizationIds = ListPackagesRequest.createUnmodifiableList(true, builder.organizationIds);
        this.packageIds = ListPackagesRequest.createUnmodifiableList(true, builder.packageIds);
        this.spaceIds = ListPackagesRequest.createUnmodifiableList(true, builder.spaceIds);
        this.states = ListPackagesRequest.createUnmodifiableList(true, builder.states);
        this.types = ListPackagesRequest.createUnmodifiableList(true, builder.types);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public List<String> getPackageIds() {
        return this.packageIds;
    }

    @Override
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    public List<PackageState> getStates() {
        return this.states;
    }

    @Override
    public List<PackageType> getTypes() {
        return this.types;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListPackagesRequest && this.equalTo(0, (ListPackagesRequest)another);
    }

    private boolean equalTo(int synthetic, ListPackagesRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.applicationIds.equals(another.applicationIds) && this.organizationIds.equals(another.organizationIds) && this.packageIds.equals(another.packageIds) && this.spaceIds.equals(another.spaceIds) && this.states.equals(another.states) && this.types.equals(another.types);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.applicationIds.hashCode();
        h += (h << 5) + this.organizationIds.hashCode();
        h += (h << 5) + this.packageIds.hashCode();
        h += (h << 5) + this.spaceIds.hashCode();
        h += (h << 5) + this.states.hashCode();
        h += (h << 5) + this.types.hashCode();
        return h;
    }

    public String toString() {
        return "ListPackagesRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", applicationIds=" + this.applicationIds + ", organizationIds=" + this.organizationIds + ", packageIds=" + this.packageIds + ", spaceIds=" + this.spaceIds + ", states=" + this.states + ", types=" + this.types + "}";
    }

    private static ListPackagesRequest validate(ListPackagesRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListPackagesRequest", generator="Immutables")
    public static final class Builder {
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> applicationIds = new ArrayList<String>();
        private List<String> organizationIds = new ArrayList<String>();
        private List<String> packageIds = new ArrayList<String>();
        private List<String> spaceIds = new ArrayList<String>();
        private List<PackageState> states = new ArrayList<PackageState>();
        private List<PackageType> types = new ArrayList<PackageType>();

        private Builder() {
        }

        public final Builder from(ListPackagesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListPackagesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListPackagesRequest) {
                instance = (_ListPackagesRequest)object;
                this.addAllTypes(((_ListPackagesRequest)instance).getTypes());
                this.addAllSpaceIds(((_ListPackagesRequest)instance).getSpaceIds());
                this.addAllPackageIds(((_ListPackagesRequest)instance).getPackageIds());
                this.addAllOrganizationIds(((_ListPackagesRequest)instance).getOrganizationIds());
                this.addAllApplicationIds(((_ListPackagesRequest)instance).getApplicationIds());
                this.addAllStates(((_ListPackagesRequest)instance).getStates());
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder applicationId(String element) {
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(Iterable<String> elements) {
            this.applicationIds.clear();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder packageId(String element) {
            this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
            return this;
        }

        public final Builder packageIds(String ... elements) {
            for (String element : elements) {
                this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
            }
            return this;
        }

        public final Builder packageIds(Iterable<String> elements) {
            this.packageIds.clear();
            return this.addAllPackageIds(elements);
        }

        public final Builder addAllPackageIds(Iterable<String> elements) {
            for (String element : elements) {
                this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(Iterable<String> elements) {
            this.spaceIds.clear();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder state(PackageState element) {
            this.states.add(Objects.requireNonNull(element, "states element"));
            return this;
        }

        public final Builder states(PackageState ... elements) {
            for (PackageState element : elements) {
                this.states.add(Objects.requireNonNull(element, "states element"));
            }
            return this;
        }

        public final Builder states(Iterable<? extends PackageState> elements) {
            this.states.clear();
            return this.addAllStates(elements);
        }

        public final Builder addAllStates(Iterable<? extends PackageState> elements) {
            for (PackageState packageState : elements) {
                this.states.add(Objects.requireNonNull(packageState, "states element"));
            }
            return this;
        }

        public final Builder type(PackageType element) {
            this.types.add(Objects.requireNonNull(element, "types element"));
            return this;
        }

        public final Builder types(PackageType ... elements) {
            for (PackageType element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public final Builder types(Iterable<? extends PackageType> elements) {
            this.types.clear();
            return this.addAllTypes(elements);
        }

        public final Builder addAllTypes(Iterable<? extends PackageType> elements) {
            for (PackageType packageType : elements) {
                this.types.add(Objects.requireNonNull(packageType, "types element"));
            }
            return this;
        }

        public ListPackagesRequest build() {
            return ListPackagesRequest.validate(new ListPackagesRequest(this));
        }
    }
}

