/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.processes._ListProcessesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListProcessesRequest", generator="Immutables")
public final class ListProcessesRequest
extends _ListProcessesRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final List<String> applicationIds;
    private final List<String> organizationIds;
    private final List<String> processIds;
    private final List<String> spaceIds;
    private final List<String> types;

    private ListProcessesRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.applicationIds = ListProcessesRequest.createUnmodifiableList(true, builder.applicationIds);
        this.organizationIds = ListProcessesRequest.createUnmodifiableList(true, builder.organizationIds);
        this.processIds = ListProcessesRequest.createUnmodifiableList(true, builder.processIds);
        this.spaceIds = ListProcessesRequest.createUnmodifiableList(true, builder.spaceIds);
        this.types = ListProcessesRequest.createUnmodifiableList(true, builder.types);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public List<String> getProcessIds() {
        return this.processIds;
    }

    @Override
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListProcessesRequest && this.equalTo(0, (ListProcessesRequest)another);
    }

    private boolean equalTo(int synthetic, ListProcessesRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.applicationIds.equals(another.applicationIds) && this.organizationIds.equals(another.organizationIds) && this.processIds.equals(another.processIds) && this.spaceIds.equals(another.spaceIds) && this.types.equals(another.types);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.applicationIds.hashCode();
        h += (h << 5) + this.organizationIds.hashCode();
        h += (h << 5) + this.processIds.hashCode();
        h += (h << 5) + this.spaceIds.hashCode();
        h += (h << 5) + this.types.hashCode();
        return h;
    }

    public String toString() {
        return "ListProcessesRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", applicationIds=" + this.applicationIds + ", organizationIds=" + this.organizationIds + ", processIds=" + this.processIds + ", spaceIds=" + this.spaceIds + ", types=" + this.types + "}";
    }

    private static ListProcessesRequest validate(ListProcessesRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListProcessesRequest", generator="Immutables")
    public static final class Builder {
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> applicationIds = new ArrayList<String>();
        private List<String> organizationIds = new ArrayList<String>();
        private List<String> processIds = new ArrayList<String>();
        private List<String> spaceIds = new ArrayList<String>();
        private List<String> types = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(ListProcessesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListProcessesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListProcessesRequest) {
                instance = (_ListProcessesRequest)object;
                this.addAllProcessIds(((_ListProcessesRequest)instance).getProcessIds());
                this.addAllTypes(((_ListProcessesRequest)instance).getTypes());
                this.addAllSpaceIds(((_ListProcessesRequest)instance).getSpaceIds());
                this.addAllOrganizationIds(((_ListProcessesRequest)instance).getOrganizationIds());
                this.addAllApplicationIds(((_ListProcessesRequest)instance).getApplicationIds());
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder applicationId(String element) {
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(Iterable<String> elements) {
            this.applicationIds.clear();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder processId(String element) {
            this.processIds.add(Objects.requireNonNull(element, "processIds element"));
            return this;
        }

        public final Builder processIds(String ... elements) {
            for (String element : elements) {
                this.processIds.add(Objects.requireNonNull(element, "processIds element"));
            }
            return this;
        }

        public final Builder processIds(Iterable<String> elements) {
            this.processIds.clear();
            return this.addAllProcessIds(elements);
        }

        public final Builder addAllProcessIds(Iterable<String> elements) {
            for (String element : elements) {
                this.processIds.add(Objects.requireNonNull(element, "processIds element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(Iterable<String> elements) {
            this.spaceIds.clear();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder type(String element) {
            this.types.add(Objects.requireNonNull(element, "types element"));
            return this;
        }

        public final Builder types(String ... elements) {
            for (String element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public final Builder types(Iterable<String> elements) {
            this.types.clear();
            return this.addAllTypes(elements);
        }

        public final Builder addAllTypes(Iterable<String> elements) {
            for (String element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public ListProcessesRequest build() {
            return ListProcessesRequest.validate(new ListProcessesRequest(this));
        }
    }
}

