/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.processes.HealthCheck;
import org.cloudfoundry.client.v3.processes.Process;
import org.cloudfoundry.client.v3.processes.ProcessRelationships;
import org.cloudfoundry.client.v3.processes.ReadinessHealthCheck;
import org.cloudfoundry.client.v3.processes._ProcessResource;
import org.immutables.value.Generated;

@Generated(from="_ProcessResource", generator="Immutables")
public final class ProcessResource
extends _ProcessResource {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    private final String command;
    private final Integer diskInMb;
    private final HealthCheck healthCheck;
    @Nullable
    private final ReadinessHealthCheck readinessHealthCheck;
    private final Integer instances;
    private final Integer memoryInMb;
    private final Metadata metadata;
    private final ProcessRelationships relationships;
    private final String type;
    @Nullable
    private final String version;
    @Nullable
    private final Integer logRateLimitInBytesPerSecond;

    private ProcessResource(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = ProcessResource.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.command = builder.command;
        this.diskInMb = builder.diskInMb;
        this.healthCheck = builder.healthCheck;
        this.readinessHealthCheck = builder.readinessHealthCheck;
        this.instances = builder.instances;
        this.memoryInMb = builder.memoryInMb;
        this.metadata = builder.metadata;
        this.relationships = builder.relationships;
        this.type = builder.type;
        this.version = builder.version;
        this.logRateLimitInBytesPerSecond = builder.logRateLimitInBytesPerSecond;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty(value="disk_in_mb")
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    @Override
    @JsonProperty(value="health_check")
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    @JsonProperty(value="readiness_health_check")
    @Nullable
    public ReadinessHealthCheck getReadinessHealthCheck() {
        return this.readinessHealthCheck;
    }

    @Override
    @JsonProperty(value="instances")
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @JsonProperty(value="memory_in_mb")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="relationships")
    public ProcessRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="log_rate_limit_in_bytes_per_second")
    @Nullable
    public Integer getLogRateLimitInBytesPerSecond() {
        return this.logRateLimitInBytesPerSecond;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ProcessResource && this.equalTo(0, (ProcessResource)another);
    }

    private boolean equalTo(int synthetic, ProcessResource another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && this.command.equals(another.command) && this.diskInMb.equals(another.diskInMb) && this.healthCheck.equals(another.healthCheck) && Objects.equals(this.readinessHealthCheck, another.readinessHealthCheck) && this.instances.equals(another.instances) && this.memoryInMb.equals(another.memoryInMb) && this.metadata.equals(another.metadata) && this.relationships.equals(another.relationships) && this.type.equals(another.type) && Objects.equals(this.version, another.version) && Objects.equals(this.logRateLimitInBytesPerSecond, another.logRateLimitInBytesPerSecond);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + this.diskInMb.hashCode();
        h += (h << 5) + this.healthCheck.hashCode();
        h += (h << 5) + Objects.hashCode(this.readinessHealthCheck);
        h += (h << 5) + this.instances.hashCode();
        h += (h << 5) + this.memoryInMb.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.logRateLimitInBytesPerSecond);
        return h;
    }

    public String toString() {
        return "ProcessResource{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", command=" + this.command + ", diskInMb=" + this.diskInMb + ", healthCheck=" + this.healthCheck + ", readinessHealthCheck=" + this.readinessHealthCheck + ", instances=" + this.instances + ", memoryInMb=" + this.memoryInMb + ", metadata=" + this.metadata + ", relationships=" + this.relationships + ", type=" + this.type + ", version=" + this.version + ", logRateLimitInBytesPerSecond=" + this.logRateLimitInBytesPerSecond + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ProcessResource fromJson(Json json) {
        Builder builder = ProcessResource.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.command != null) {
            builder.command(json.command);
        }
        if (json.diskInMb != null) {
            builder.diskInMb(json.diskInMb);
        }
        if (json.healthCheck != null) {
            builder.healthCheck(json.healthCheck);
        }
        if (json.readinessHealthCheck != null) {
            builder.readinessHealthCheck(json.readinessHealthCheck);
        }
        if (json.instances != null) {
            builder.instances(json.instances);
        }
        if (json.memoryInMb != null) {
            builder.memoryInMb(json.memoryInMb);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.logRateLimitInBytesPerSecond != null) {
            builder.logRateLimitInBytesPerSecond(json.logRateLimitInBytesPerSecond);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_ProcessResource", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_COMMAND = 4L;
        private static final long INIT_BIT_DISK_IN_MB = 8L;
        private static final long INIT_BIT_HEALTH_CHECK = 16L;
        private static final long INIT_BIT_INSTANCES = 32L;
        private static final long INIT_BIT_MEMORY_IN_MB = 64L;
        private static final long INIT_BIT_METADATA = 128L;
        private static final long INIT_BIT_RELATIONSHIPS = 256L;
        private static final long INIT_BIT_TYPE = 512L;
        private long initBits = 1023L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private String command;
        private Integer diskInMb;
        private HealthCheck healthCheck;
        private ReadinessHealthCheck readinessHealthCheck;
        private Integer instances;
        private Integer memoryInMb;
        private Metadata metadata;
        private ProcessRelationships relationships;
        private String type;
        private String version;
        private Integer logRateLimitInBytesPerSecond;

        private Builder() {
        }

        public final Builder from(Process instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ProcessResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ProcessResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String updatedAtValue;
            ReadinessHealthCheck readinessHealthCheckValue;
            String versionValue;
            Integer logRateLimitInBytesPerSecondValue;
            Resource instance;
            long bits = 0L;
            if (object instanceof Process) {
                instance = (Process)object;
                if ((bits & 1L) == 0L) {
                    this.metadata(((Process)instance).getMetadata());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.instances(((Process)instance).getInstances());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    logRateLimitInBytesPerSecondValue = ((Process)instance).getLogRateLimitInBytesPerSecond();
                    if (logRateLimitInBytesPerSecondValue != null) {
                        this.logRateLimitInBytesPerSecond(logRateLimitInBytesPerSecondValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.type(((Process)instance).getType());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    versionValue = ((Process)instance).getVersion();
                    if (versionValue != null) {
                        this.version(versionValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.command(((Process)instance).getCommand());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.diskInMb(((Process)instance).getDiskInMb());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.relationships(((Process)instance).getRelationships());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.memoryInMb(((Process)instance).getMemoryInMb());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.healthCheck(((Process)instance).getHealthCheck());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    readinessHealthCheckValue = ((Process)instance).getReadinessHealthCheck();
                    if (readinessHealthCheckValue != null) {
                        this.readinessHealthCheck(readinessHealthCheckValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x4000L;
                }
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                if ((bits & 0x80L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 0x80L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x4000L;
                }
            }
            if (object instanceof _ProcessResource) {
                instance = (_ProcessResource)object;
                if ((bits & 0x40L) == 0L) {
                    this.diskInMb(((Process)instance).getDiskInMb());
                    bits |= 0x40L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.relationships(((Process)instance).getRelationships());
                    bits |= 0x100L;
                }
                if ((bits & 1L) == 0L) {
                    this.metadata(((Process)instance).getMetadata());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.instances(((Process)instance).getInstances());
                    bits |= 2L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.memoryInMb(((Process)instance).getMemoryInMb());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.healthCheck(((Process)instance).getHealthCheck());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    readinessHealthCheckValue = ((Process)instance).getReadinessHealthCheck();
                    if (readinessHealthCheckValue != null) {
                        this.readinessHealthCheck(readinessHealthCheckValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 4L) == 0L) {
                    logRateLimitInBytesPerSecondValue = ((Process)instance).getLogRateLimitInBytesPerSecond();
                    if (logRateLimitInBytesPerSecondValue != null) {
                        this.logRateLimitInBytesPerSecond(logRateLimitInBytesPerSecondValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.type(((Process)instance).getType());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    versionValue = ((Process)instance).getVersion();
                    if (versionValue != null) {
                        this.version(versionValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.command(((Process)instance).getCommand());
                    bits |= 0x20L;
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="command")
        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="disk_in_mb")
        public final Builder diskInMb(Integer diskInMb) {
            this.diskInMb = Objects.requireNonNull(diskInMb, "diskInMb");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="health_check")
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = Objects.requireNonNull(healthCheck, "healthCheck");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="readiness_health_check")
        public final Builder readinessHealthCheck(@Nullable ReadinessHealthCheck readinessHealthCheck) {
            this.readinessHealthCheck = readinessHealthCheck;
            return this;
        }

        @JsonProperty(value="instances")
        public final Builder instances(Integer instances) {
            this.instances = Objects.requireNonNull(instances, "instances");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="memory_in_mb")
        public final Builder memoryInMb(Integer memoryInMb) {
            this.memoryInMb = Objects.requireNonNull(memoryInMb, "memoryInMb");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(ProcessRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="version")
        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="log_rate_limit_in_bytes_per_second")
        public final Builder logRateLimitInBytesPerSecond(@Nullable Integer logRateLimitInBytesPerSecond) {
            this.logRateLimitInBytesPerSecond = logRateLimitInBytesPerSecond;
            return this;
        }

        public ProcessResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ProcessResource(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("command");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("diskInMb");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("healthCheck");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("instances");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("memoryInMb");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("metadata");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ProcessResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ProcessResource", generator="Immutables")
    static final class Json
    extends _ProcessResource {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        String command;
        Integer diskInMb;
        HealthCheck healthCheck;
        ReadinessHealthCheck readinessHealthCheck;
        Integer instances;
        Integer memoryInMb;
        Metadata metadata;
        ProcessRelationships relationships;
        String type;
        String version;
        Integer logRateLimitInBytesPerSecond;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="command")
        public void setCommand(String command) {
            this.command = command;
        }

        @JsonProperty(value="disk_in_mb")
        public void setDiskInMb(Integer diskInMb) {
            this.diskInMb = diskInMb;
        }

        @JsonProperty(value="health_check")
        public void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        @JsonProperty(value="readiness_health_check")
        public void setReadinessHealthCheck(@Nullable ReadinessHealthCheck readinessHealthCheck) {
            this.readinessHealthCheck = readinessHealthCheck;
        }

        @JsonProperty(value="instances")
        public void setInstances(Integer instances) {
            this.instances = instances;
        }

        @JsonProperty(value="memory_in_mb")
        public void setMemoryInMb(Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(ProcessRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable String version) {
            this.version = version;
        }

        @JsonProperty(value="log_rate_limit_in_bytes_per_second")
        public void setLogRateLimitInBytesPerSecond(@Nullable Integer logRateLimitInBytesPerSecond) {
            this.logRateLimitInBytesPerSecond = logRateLimitInBytesPerSecond;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getDiskInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HealthCheck getHealthCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReadinessHealthCheck getReadinessHealthCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemoryInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getLogRateLimitInBytesPerSecond() {
            throw new UnsupportedOperationException();
        }
    }
}

