/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes.HealthCheck;
import org.cloudfoundry.client.v3.processes.ReadinessHealthCheck;
import org.cloudfoundry.client.v3.processes._UpdateProcessRequest;
import org.immutables.value.Generated;

@Generated(from="_UpdateProcessRequest", generator="Immutables")
public final class UpdateProcessRequest
extends _UpdateProcessRequest {
    @Nullable
    private final String command;
    @Nullable
    private final HealthCheck healthCheck;
    @Nullable
    private final ReadinessHealthCheck readinessHealthCheck;
    private final String processId;

    private UpdateProcessRequest(Builder builder) {
        this.command = builder.command;
        this.healthCheck = builder.healthCheck;
        this.readinessHealthCheck = builder.readinessHealthCheck;
        this.processId = builder.processId;
    }

    @Override
    @JsonProperty(value="command")
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty(value="health_check")
    @Nullable
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    @JsonProperty(value="readiness_health_check")
    @Nullable
    public ReadinessHealthCheck getReadinessHealthCheck() {
        return this.readinessHealthCheck;
    }

    @Override
    @JsonProperty(value="processId")
    @JsonIgnore
    public String getProcessId() {
        return this.processId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateProcessRequest && this.equalTo(0, (UpdateProcessRequest)another);
    }

    private boolean equalTo(int synthetic, UpdateProcessRequest another) {
        return Objects.equals(this.command, another.command) && Objects.equals(this.healthCheck, another.healthCheck) && Objects.equals(this.readinessHealthCheck, another.readinessHealthCheck) && this.processId.equals(another.processId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + Objects.hashCode(this.healthCheck);
        h += (h << 5) + Objects.hashCode(this.readinessHealthCheck);
        h += (h << 5) + this.processId.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateProcessRequest{command=" + this.command + ", healthCheck=" + this.healthCheck + ", readinessHealthCheck=" + this.readinessHealthCheck + ", processId=" + this.processId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateProcessRequest fromJson(Json json) {
        Builder builder = UpdateProcessRequest.builder();
        if (json.command != null) {
            builder.command(json.command);
        }
        if (json.healthCheck != null) {
            builder.healthCheck(json.healthCheck);
        }
        if (json.readinessHealthCheck != null) {
            builder.readinessHealthCheck(json.readinessHealthCheck);
        }
        if (json.processId != null) {
            builder.processId(json.processId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_UpdateProcessRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PROCESS_ID = 1L;
        private long initBits = 1L;
        private String command;
        private HealthCheck healthCheck;
        private ReadinessHealthCheck readinessHealthCheck;
        private String processId;

        private Builder() {
        }

        public final Builder from(UpdateProcessRequest instance) {
            return this.from((_UpdateProcessRequest)instance);
        }

        final Builder from(_UpdateProcessRequest instance) {
            ReadinessHealthCheck readinessHealthCheckValue;
            HealthCheck healthCheckValue;
            Objects.requireNonNull(instance, "instance");
            String commandValue = instance.getCommand();
            if (commandValue != null) {
                this.command(commandValue);
            }
            if ((healthCheckValue = instance.getHealthCheck()) != null) {
                this.healthCheck(healthCheckValue);
            }
            if ((readinessHealthCheckValue = instance.getReadinessHealthCheck()) != null) {
                this.readinessHealthCheck(readinessHealthCheckValue);
            }
            this.processId(instance.getProcessId());
            return this;
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        public final Builder healthCheck(@Nullable HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final Builder readinessHealthCheck(@Nullable ReadinessHealthCheck readinessHealthCheck) {
            this.readinessHealthCheck = readinessHealthCheck;
            return this;
        }

        public final Builder processId(String processId) {
            this.processId = Objects.requireNonNull(processId, "processId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public UpdateProcessRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateProcessRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("processId");
            }
            return "Cannot build UpdateProcessRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UpdateProcessRequest", generator="Immutables")
    static final class Json
    extends _UpdateProcessRequest {
        String command;
        HealthCheck healthCheck;
        ReadinessHealthCheck readinessHealthCheck;
        String processId;

        Json() {
        }

        @JsonProperty(value="command")
        public void setCommand(@Nullable String command) {
            this.command = command;
        }

        @JsonProperty(value="health_check")
        public void setHealthCheck(@Nullable HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        @JsonProperty(value="readiness_health_check")
        public void setReadinessHealthCheck(@Nullable ReadinessHealthCheck readinessHealthCheck) {
            this.readinessHealthCheck = readinessHealthCheck;
        }

        @JsonProperty(value="processId")
        @JsonIgnore
        public void setProcessId(String processId) {
            this.processId = processId;
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HealthCheck getHealthCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReadinessHealthCheck getReadinessHealthCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProcessId() {
            throw new UnsupportedOperationException();
        }
    }
}

