/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.resourcematch;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.resourcematch.MatchedResource;
import org.cloudfoundry.client.v3.resourcematch._ListMatchingResourcesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListMatchingResourcesRequest", generator="Immutables")
public final class ListMatchingResourcesRequest
extends _ListMatchingResourcesRequest {
    private final List<MatchedResource> resources;

    private ListMatchingResourcesRequest(Builder builder) {
        this.resources = ListMatchingResourcesRequest.createUnmodifiableList(true, builder.resources);
    }

    @Override
    @JsonProperty(value="resources")
    public List<MatchedResource> getResources() {
        return this.resources;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListMatchingResourcesRequest && this.equalTo(0, (ListMatchingResourcesRequest)another);
    }

    private boolean equalTo(int synthetic, ListMatchingResourcesRequest another) {
        return this.resources.equals(another.resources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.resources.hashCode();
        return h;
    }

    public String toString() {
        return "ListMatchingResourcesRequest{resources=" + this.resources + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListMatchingResourcesRequest fromJson(Json json) {
        Builder builder = ListMatchingResourcesRequest.builder();
        if (json.resources != null) {
            builder.addAllResources(json.resources);
        }
        return builder.build();
    }

    private static ListMatchingResourcesRequest validate(ListMatchingResourcesRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListMatchingResourcesRequest", generator="Immutables")
    public static final class Builder {
        private List<MatchedResource> resources = new ArrayList<MatchedResource>();

        private Builder() {
        }

        public final Builder from(ListMatchingResourcesRequest instance) {
            return this.from((_ListMatchingResourcesRequest)instance);
        }

        final Builder from(_ListMatchingResourcesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllResources(instance.getResources());
            return this;
        }

        public final Builder resource(MatchedResource element) {
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resources(MatchedResource ... elements) {
            for (MatchedResource element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        public final Builder resources(Iterable<? extends MatchedResource> elements) {
            this.resources.clear();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends MatchedResource> elements) {
            for (MatchedResource matchedResource : elements) {
                this.resources.add(Objects.requireNonNull(matchedResource, "resources element"));
            }
            return this;
        }

        public ListMatchingResourcesRequest build() {
            return ListMatchingResourcesRequest.validate(new ListMatchingResourcesRequest(this));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ListMatchingResourcesRequest", generator="Immutables")
    static final class Json
    extends _ListMatchingResourcesRequest {
        List<MatchedResource> resources = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="resources")
        public void setResources(List<MatchedResource> resources) {
            this.resources = resources;
        }

        @Override
        public List<MatchedResource> getResources() {
            throw new UnsupportedOperationException();
        }
    }
}

