/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.routes.Destination;
import org.cloudfoundry.client.v3.routes.RouteDestinations;
import org.cloudfoundry.client.v3.routes._InsertRouteDestinationsResponse;
import org.immutables.value.Generated;

@Generated(from="_InsertRouteDestinationsResponse", generator="Immutables")
public final class InsertRouteDestinationsResponse
extends _InsertRouteDestinationsResponse {
    private final Map<String, Link> links;
    private final List<Destination> destinations;

    private InsertRouteDestinationsResponse(Builder builder) {
        this.links = InsertRouteDestinationsResponse.createUnmodifiableMap(false, false, builder.links);
        this.destinations = InsertRouteDestinationsResponse.createUnmodifiableList(true, builder.destinations);
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="destinations")
    public List<Destination> getDestinations() {
        return this.destinations;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InsertRouteDestinationsResponse && this.equalTo(0, (InsertRouteDestinationsResponse)another);
    }

    private boolean equalTo(int synthetic, InsertRouteDestinationsResponse another) {
        return this.links.equals(another.links) && this.destinations.equals(another.destinations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + this.destinations.hashCode();
        return h;
    }

    public String toString() {
        return "InsertRouteDestinationsResponse{links=" + this.links + ", destinations=" + this.destinations + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static InsertRouteDestinationsResponse fromJson(Json json) {
        Builder builder = InsertRouteDestinationsResponse.builder();
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.destinations != null) {
            builder.addAllDestinations(json.destinations);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_InsertRouteDestinationsResponse", generator="Immutables")
    public static final class Builder {
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private List<Destination> destinations = new ArrayList<Destination>();

        private Builder() {
        }

        public final Builder from(RouteDestinations instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(InsertRouteDestinationsResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_InsertRouteDestinationsResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof RouteDestinations) {
                RouteDestinations instance = (RouteDestinations)object;
                this.putAllLinks(instance.getLinks());
                this.addAllDestinations(instance.getDestinations());
            }
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        public final Builder destination(Destination element) {
            this.destinations.add(Objects.requireNonNull(element, "destinations element"));
            return this;
        }

        public final Builder destinations(Destination ... elements) {
            for (Destination element : elements) {
                this.destinations.add(Objects.requireNonNull(element, "destinations element"));
            }
            return this;
        }

        @JsonProperty(value="destinations")
        public final Builder destinations(Iterable<? extends Destination> elements) {
            this.destinations.clear();
            return this.addAllDestinations(elements);
        }

        public final Builder addAllDestinations(Iterable<? extends Destination> elements) {
            for (Destination destination : elements) {
                this.destinations.add(Objects.requireNonNull(destination, "destinations element"));
            }
            return this;
        }

        public InsertRouteDestinationsResponse build() {
            return new InsertRouteDestinationsResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_InsertRouteDestinationsResponse", generator="Immutables")
    static final class Json
    extends _InsertRouteDestinationsResponse {
        Map<String, Link> links = Collections.emptyMap();
        List<Destination> destinations = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="destinations")
        public void setDestinations(List<Destination> destinations) {
            this.destinations = destinations;
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Destination> getDestinations() {
            throw new UnsupportedOperationException();
        }
    }
}

