/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.securitygroups.AbstractBindSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups._BindStagingSecurityGroupRequest;
import org.immutables.value.Generated;

@Generated(from="_BindStagingSecurityGroupRequest", generator="Immutables")
public final class BindStagingSecurityGroupRequest
extends _BindStagingSecurityGroupRequest {
    private final String securityGroupId;
    private final List<Relationship> boundSpaces;

    private BindStagingSecurityGroupRequest(Builder builder) {
        this.securityGroupId = builder.securityGroupId;
        this.boundSpaces = BindStagingSecurityGroupRequest.createUnmodifiableList(true, builder.boundSpaces);
    }

    @Override
    @JsonProperty(value="securityGroupId")
    @JsonIgnore
    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    @Override
    @JsonProperty(value="data")
    public List<Relationship> getBoundSpaces() {
        return this.boundSpaces;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BindStagingSecurityGroupRequest && this.equalTo(0, (BindStagingSecurityGroupRequest)another);
    }

    private boolean equalTo(int synthetic, BindStagingSecurityGroupRequest another) {
        return this.securityGroupId.equals(another.securityGroupId) && this.boundSpaces.equals(another.boundSpaces);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.securityGroupId.hashCode();
        h += (h << 5) + this.boundSpaces.hashCode();
        return h;
    }

    public String toString() {
        return "BindStagingSecurityGroupRequest{securityGroupId=" + this.securityGroupId + ", boundSpaces=" + this.boundSpaces + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BindStagingSecurityGroupRequest fromJson(Json json) {
        Builder builder = BindStagingSecurityGroupRequest.builder();
        if (json.securityGroupId != null) {
            builder.securityGroupId(json.securityGroupId);
        }
        if (json.boundSpaces != null) {
            builder.addAllBoundSpaces(json.boundSpaces);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_BindStagingSecurityGroupRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SECURITY_GROUP_ID = 1L;
        private long initBits = 1L;
        private String securityGroupId;
        private List<Relationship> boundSpaces = new ArrayList<Relationship>();

        private Builder() {
        }

        public final Builder from(AbstractBindSecurityGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BindStagingSecurityGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_BindStagingSecurityGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof AbstractBindSecurityGroupRequest) {
                AbstractBindSecurityGroupRequest instance = (AbstractBindSecurityGroupRequest)object;
                this.securityGroupId(instance.getSecurityGroupId());
                this.addAllBoundSpaces(instance.getBoundSpaces());
            }
        }

        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder boundSpace(Relationship element) {
            this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
            return this;
        }

        public final Builder boundSpaces(Relationship ... elements) {
            for (Relationship element : elements) {
                this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
            }
            return this;
        }

        public final Builder boundSpaces(Iterable<? extends Relationship> elements) {
            this.boundSpaces.clear();
            return this.addAllBoundSpaces(elements);
        }

        public final Builder addAllBoundSpaces(Iterable<? extends Relationship> elements) {
            for (Relationship relationship : elements) {
                this.boundSpaces.add(Objects.requireNonNull(relationship, "boundSpaces element"));
            }
            return this;
        }

        public BindStagingSecurityGroupRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BindStagingSecurityGroupRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("securityGroupId");
            }
            return "Cannot build BindStagingSecurityGroupRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_BindStagingSecurityGroupRequest", generator="Immutables")
    static final class Json
    extends _BindStagingSecurityGroupRequest {
        String securityGroupId;
        List<Relationship> boundSpaces = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="securityGroupId")
        @JsonIgnore
        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        @JsonProperty(value="data")
        public void setBoundSpaces(List<Relationship> boundSpaces) {
            this.boundSpaces = boundSpaces;
        }

        @Override
        public String getSecurityGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Relationship> getBoundSpaces() {
            throw new UnsupportedOperationException();
        }
    }
}

