/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.securitygroups.GloballyEnabled;
import org.cloudfoundry.client.v3.securitygroups.Relationships;
import org.cloudfoundry.client.v3.securitygroups.Rule;
import org.cloudfoundry.client.v3.securitygroups._CreateSecurityGroupRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateSecurityGroupRequest", generator="Immutables")
public final class CreateSecurityGroupRequest
extends _CreateSecurityGroupRequest {
    private final String name;
    @Nullable
    private final GloballyEnabled globallyEnabled;
    @Nullable
    private final List<Rule> rules;
    @Nullable
    private final Relationships relationships;

    private CreateSecurityGroupRequest(Builder builder) {
        this.name = builder.name;
        this.globallyEnabled = builder.globallyEnabled;
        this.rules = builder.rules == null ? null : CreateSecurityGroupRequest.createUnmodifiableList(true, builder.rules);
        this.relationships = builder.relationships;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="globally_enabled")
    @Nullable
    public GloballyEnabled getGloballyEnabled() {
        return this.globallyEnabled;
    }

    @Override
    @JsonProperty(value="rules")
    @Nullable
    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    @JsonProperty(value="relationships")
    @Nullable
    public Relationships getRelationships() {
        return this.relationships;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateSecurityGroupRequest && this.equalTo(0, (CreateSecurityGroupRequest)another);
    }

    private boolean equalTo(int synthetic, CreateSecurityGroupRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.globallyEnabled, another.globallyEnabled) && Objects.equals(this.rules, another.rules) && Objects.equals(this.relationships, another.relationships);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.globallyEnabled);
        h += (h << 5) + Objects.hashCode(this.rules);
        h += (h << 5) + Objects.hashCode(this.relationships);
        return h;
    }

    public String toString() {
        return "CreateSecurityGroupRequest{name=" + this.name + ", globallyEnabled=" + this.globallyEnabled + ", rules=" + this.rules + ", relationships=" + this.relationships + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateSecurityGroupRequest fromJson(Json json) {
        Builder builder = CreateSecurityGroupRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.globallyEnabled != null) {
            builder.globallyEnabled(json.globallyEnabled);
        }
        if (json.rules != null) {
            builder.addAllRules(json.rules);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_CreateSecurityGroupRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private GloballyEnabled globallyEnabled;
        private List<Rule> rules = null;
        private Relationships relationships;

        private Builder() {
        }

        public final Builder from(CreateSecurityGroupRequest instance) {
            return this.from((_CreateSecurityGroupRequest)instance);
        }

        final Builder from(_CreateSecurityGroupRequest instance) {
            Relationships relationshipsValue;
            List<Rule> rulesValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            GloballyEnabled globallyEnabledValue = instance.getGloballyEnabled();
            if (globallyEnabledValue != null) {
                this.globallyEnabled(globallyEnabledValue);
            }
            if ((rulesValue = instance.getRules()) != null) {
                this.addAllRules(rulesValue);
            }
            if ((relationshipsValue = instance.getRelationships()) != null) {
                this.relationships(relationshipsValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder globallyEnabled(@Nullable GloballyEnabled globallyEnabled) {
            this.globallyEnabled = globallyEnabled;
            return this;
        }

        public final Builder rule(Rule element) {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
            }
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder rules(Rule ... elements) {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
            }
            for (Rule element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        public final Builder rules(@Nullable Iterable<? extends Rule> elements) {
            if (elements == null) {
                this.rules = null;
                return this;
            }
            this.rules = new ArrayList<Rule>();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends Rule> elements) {
            Objects.requireNonNull(elements, "rules element");
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
            }
            for (Rule rule : elements) {
                this.rules.add(Objects.requireNonNull(rule, "rules element"));
            }
            return this;
        }

        public final Builder relationships(@Nullable Relationships relationships) {
            this.relationships = relationships;
            return this;
        }

        public CreateSecurityGroupRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateSecurityGroupRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateSecurityGroupRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateSecurityGroupRequest", generator="Immutables")
    static final class Json
    extends _CreateSecurityGroupRequest {
        String name;
        GloballyEnabled globallyEnabled;
        List<Rule> rules = null;
        Relationships relationships;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="globally_enabled")
        public void setGloballyEnabled(@Nullable GloballyEnabled globallyEnabled) {
            this.globallyEnabled = globallyEnabled;
        }

        @JsonProperty(value="rules")
        public void setRules(@Nullable List<Rule> rules) {
            this.rules = rules;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(@Nullable Relationships relationships) {
            this.relationships = relationships;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GloballyEnabled getGloballyEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Rule> getRules() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Relationships getRelationships() {
            throw new UnsupportedOperationException();
        }
    }
}

