/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.securitygroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v3.securitygroups.AbstractListSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups._ListRunningSecurityGroupsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListRunningSecurityGroupsRequest", generator="Immutables")
public final class ListRunningSecurityGroupsRequest
extends _ListRunningSecurityGroupsRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    private final String spaceId;
    @Nullable
    private final List<String> securityGroupIds;
    @Nullable
    private final List<String> names;

    private ListRunningSecurityGroupsRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.spaceId = builder.spaceId;
        this.securityGroupIds = builder.securityGroupIds == null ? null : ListRunningSecurityGroupsRequest.createUnmodifiableList(true, builder.securityGroupIds);
        this.names = builder.names == null ? null : ListRunningSecurityGroupsRequest.createUnmodifiableList(true, builder.names);
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @Nullable
    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListRunningSecurityGroupsRequest && this.equalTo(0, (ListRunningSecurityGroupsRequest)another);
    }

    private boolean equalTo(int synthetic, ListRunningSecurityGroupsRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && this.spaceId.equals(another.spaceId) && Objects.equals(this.securityGroupIds, another.securityGroupIds) && Objects.equals(this.names, another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + this.spaceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.securityGroupIds);
        h += (h << 5) + Objects.hashCode(this.names);
        return h;
    }

    public String toString() {
        return "ListRunningSecurityGroupsRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", spaceId=" + this.spaceId + ", securityGroupIds=" + this.securityGroupIds + ", names=" + this.names + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListRunningSecurityGroupsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SPACE_ID = 1L;
        private long initBits = 1L;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private String spaceId;
        private List<String> securityGroupIds = null;
        private List<String> names = null;

        private Builder() {
        }

        public final Builder from(AbstractListSecurityGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ListRunningSecurityGroupsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListRunningSecurityGroupsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            List<String> securityGroupIdsValue;
            Integer pageValue;
            List<String> namesValue;
            Integer resultsPerPageValue;
            OrderDirection orderDirectionValue;
            PaginatedRequest instance;
            long bits = 0L;
            if (object instanceof AbstractListSecurityGroupRequest) {
                instance = (AbstractListSecurityGroupRequest)object;
                if ((bits & 1L) == 0L) {
                    this.spaceId(((AbstractListSecurityGroupRequest)instance).getSpaceId());
                    bits |= 1L;
                }
                if ((bits & 0x10L) == 0L) {
                    orderDirectionValue = instance.getOrderDirection();
                    if (orderDirectionValue != null) {
                        this.orderDirection(orderDirectionValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 2L) == 0L) {
                    resultsPerPageValue = instance.getResultsPerPage();
                    if (resultsPerPageValue != null) {
                        this.resultsPerPage(resultsPerPageValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    namesValue = ((AbstractListSecurityGroupRequest)instance).getNames();
                    if (namesValue != null) {
                        this.addAllNames(namesValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    pageValue = instance.getPage();
                    if (pageValue != null) {
                        this.page(pageValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 8L) == 0L) {
                    securityGroupIdsValue = ((AbstractListSecurityGroupRequest)instance).getSecurityGroupIds();
                    if (securityGroupIdsValue != null) {
                        this.addAllSecurityGroupIds(securityGroupIdsValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof _ListRunningSecurityGroupsRequest) {
                instance = (_ListRunningSecurityGroupsRequest)object;
                if ((bits & 1L) == 0L) {
                    this.spaceId(((AbstractListSecurityGroupRequest)instance).getSpaceId());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    securityGroupIdsValue = ((AbstractListSecurityGroupRequest)instance).getSecurityGroupIds();
                    if (securityGroupIdsValue != null) {
                        this.addAllSecurityGroupIds(securityGroupIdsValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    namesValue = ((AbstractListSecurityGroupRequest)instance).getNames();
                    if (namesValue != null) {
                        this.addAllNames(namesValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof PaginatedRequest) {
                instance = (PaginatedRequest)object;
                if ((bits & 0x10L) == 0L) {
                    orderDirectionValue = instance.getOrderDirection();
                    if (orderDirectionValue != null) {
                        this.orderDirection(orderDirectionValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 2L) == 0L) {
                    resultsPerPageValue = instance.getResultsPerPage();
                    if (resultsPerPageValue != null) {
                        this.resultsPerPage(resultsPerPageValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    pageValue = instance.getPage();
                    if (pageValue != null) {
                        this.page(pageValue);
                    }
                    bits |= 0x20L;
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder securityGroupId(String element) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>();
            }
            this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
            return this;
        }

        public final Builder securityGroupIds(String ... elements) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
            }
            return this;
        }

        public final Builder securityGroupIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.securityGroupIds = null;
                return this;
            }
            this.securityGroupIds = new ArrayList<String>();
            return this.addAllSecurityGroupIds(elements);
        }

        public final Builder addAllSecurityGroupIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "securityGroupIds element");
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
            }
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public ListRunningSecurityGroupsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListRunningSecurityGroupsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spaceId");
            }
            return "Cannot build ListRunningSecurityGroupsRequest, some of required attributes are not set " + attributes;
        }
    }
}

