/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.securitygroups.GloballyEnabled;
import org.cloudfoundry.client.v3.securitygroups.Rule;
import org.cloudfoundry.client.v3.securitygroups._UpdateSecurityGroupRequest;
import org.immutables.value.Generated;

@Generated(from="_UpdateSecurityGroupRequest", generator="Immutables")
public final class UpdateSecurityGroupRequest
extends _UpdateSecurityGroupRequest {
    private final String securityGroupId;
    private final String name;
    private final GloballyEnabled globallyEnabled;
    private final List<Rule> rules;

    private UpdateSecurityGroupRequest(Builder builder) {
        this.securityGroupId = builder.securityGroupId;
        this.name = builder.name;
        this.globallyEnabled = builder.globallyEnabled;
        this.rules = UpdateSecurityGroupRequest.createUnmodifiableList(true, builder.rules);
    }

    @Override
    @JsonProperty(value="securityGroupId")
    @JsonIgnore
    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="globally_enabled")
    public GloballyEnabled getGloballyEnabled() {
        return this.globallyEnabled;
    }

    @Override
    @JsonProperty(value="rules")
    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateSecurityGroupRequest && this.equalTo(0, (UpdateSecurityGroupRequest)another);
    }

    private boolean equalTo(int synthetic, UpdateSecurityGroupRequest another) {
        return this.securityGroupId.equals(another.securityGroupId) && this.name.equals(another.name) && this.globallyEnabled.equals(another.globallyEnabled) && this.rules.equals(another.rules);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.securityGroupId.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.globallyEnabled.hashCode();
        h += (h << 5) + this.rules.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateSecurityGroupRequest{securityGroupId=" + this.securityGroupId + ", name=" + this.name + ", globallyEnabled=" + this.globallyEnabled + ", rules=" + this.rules + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateSecurityGroupRequest fromJson(Json json) {
        Builder builder = UpdateSecurityGroupRequest.builder();
        if (json.securityGroupId != null) {
            builder.securityGroupId(json.securityGroupId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.globallyEnabled != null) {
            builder.globallyEnabled(json.globallyEnabled);
        }
        if (json.rules != null) {
            builder.addAllRules(json.rules);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_UpdateSecurityGroupRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SECURITY_GROUP_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_GLOBALLY_ENABLED = 4L;
        private long initBits = 7L;
        private String securityGroupId;
        private String name;
        private GloballyEnabled globallyEnabled;
        private List<Rule> rules = new ArrayList<Rule>();

        private Builder() {
        }

        public final Builder from(UpdateSecurityGroupRequest instance) {
            return this.from((_UpdateSecurityGroupRequest)instance);
        }

        final Builder from(_UpdateSecurityGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.securityGroupId(instance.getSecurityGroupId());
            this.name(instance.getName());
            this.globallyEnabled(instance.getGloballyEnabled());
            this.addAllRules(instance.getRules());
            return this;
        }

        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder globallyEnabled(GloballyEnabled globallyEnabled) {
            this.globallyEnabled = Objects.requireNonNull(globallyEnabled, "globallyEnabled");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder rule(Rule element) {
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder rules(Rule ... elements) {
            for (Rule element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        public final Builder rules(Iterable<? extends Rule> elements) {
            this.rules.clear();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends Rule> elements) {
            for (Rule rule : elements) {
                this.rules.add(Objects.requireNonNull(rule, "rules element"));
            }
            return this;
        }

        public UpdateSecurityGroupRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateSecurityGroupRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("securityGroupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("globallyEnabled");
            }
            return "Cannot build UpdateSecurityGroupRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UpdateSecurityGroupRequest", generator="Immutables")
    static final class Json
    extends _UpdateSecurityGroupRequest {
        String securityGroupId;
        String name;
        GloballyEnabled globallyEnabled;
        List<Rule> rules = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="securityGroupId")
        @JsonIgnore
        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="globally_enabled")
        public void setGloballyEnabled(GloballyEnabled globallyEnabled) {
            this.globallyEnabled = globallyEnabled;
        }

        @JsonProperty(value="rules")
        public void setRules(List<Rule> rules) {
            this.rules = rules;
        }

        @Override
        public String getSecurityGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GloballyEnabled getGloballyEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Rule> getRules() {
            throw new UnsupportedOperationException();
        }
    }
}

