/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingType;
import org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListServiceBindingsRequest", generator="Immutables")
public final class ListServiceBindingsRequest
extends _ListServiceBindingsRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final List<String> names;
    private final List<String> serviceInstanceIds;
    private final List<String> serviceInstanceNames;
    private final List<String> applicationIds;
    private final List<String> appNames;
    private final List<String> servicePlanIds;
    private final List<String> servicePlanNames;
    private final List<String> serviceOfferingIds;
    private final List<String> serviceOfferingNames;
    @Nullable
    private final ServiceBindingType type;
    private final List<String> ids;

    private ListServiceBindingsRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.names = ListServiceBindingsRequest.createUnmodifiableList(true, builder.names);
        this.serviceInstanceIds = ListServiceBindingsRequest.createUnmodifiableList(true, builder.serviceInstanceIds);
        this.serviceInstanceNames = ListServiceBindingsRequest.createUnmodifiableList(true, builder.serviceInstanceNames);
        this.applicationIds = ListServiceBindingsRequest.createUnmodifiableList(true, builder.applicationIds);
        this.appNames = ListServiceBindingsRequest.createUnmodifiableList(true, builder.appNames);
        this.servicePlanIds = ListServiceBindingsRequest.createUnmodifiableList(true, builder.servicePlanIds);
        this.servicePlanNames = ListServiceBindingsRequest.createUnmodifiableList(true, builder.servicePlanNames);
        this.serviceOfferingIds = ListServiceBindingsRequest.createUnmodifiableList(true, builder.serviceOfferingIds);
        this.serviceOfferingNames = ListServiceBindingsRequest.createUnmodifiableList(true, builder.serviceOfferingNames);
        this.type = builder.type;
        this.ids = ListServiceBindingsRequest.createUnmodifiableList(true, builder.ids);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    @Override
    public List<String> getServiceInstanceNames() {
        return this.serviceInstanceNames;
    }

    @Override
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public List<String> getAppNames() {
        return this.appNames;
    }

    @Override
    public List<String> getServicePlanIds() {
        return this.servicePlanIds;
    }

    @Override
    public List<String> getServicePlanNames() {
        return this.servicePlanNames;
    }

    @Override
    public List<String> getServiceOfferingIds() {
        return this.serviceOfferingIds;
    }

    @Override
    public List<String> getServiceOfferingNames() {
        return this.serviceOfferingNames;
    }

    @Override
    @Nullable
    public ServiceBindingType getType() {
        return this.type;
    }

    @Override
    public List<String> getIds() {
        return this.ids;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServiceBindingsRequest && this.equalTo(0, (ListServiceBindingsRequest)another);
    }

    private boolean equalTo(int synthetic, ListServiceBindingsRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.names.equals(another.names) && this.serviceInstanceIds.equals(another.serviceInstanceIds) && this.serviceInstanceNames.equals(another.serviceInstanceNames) && this.applicationIds.equals(another.applicationIds) && this.appNames.equals(another.appNames) && this.servicePlanIds.equals(another.servicePlanIds) && this.servicePlanNames.equals(another.servicePlanNames) && this.serviceOfferingIds.equals(another.serviceOfferingIds) && this.serviceOfferingNames.equals(another.serviceOfferingNames) && Objects.equals((Object)this.type, (Object)another.type) && this.ids.equals(another.ids);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.names.hashCode();
        h += (h << 5) + this.serviceInstanceIds.hashCode();
        h += (h << 5) + this.serviceInstanceNames.hashCode();
        h += (h << 5) + this.applicationIds.hashCode();
        h += (h << 5) + this.appNames.hashCode();
        h += (h << 5) + this.servicePlanIds.hashCode();
        h += (h << 5) + this.servicePlanNames.hashCode();
        h += (h << 5) + this.serviceOfferingIds.hashCode();
        h += (h << 5) + this.serviceOfferingNames.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + this.ids.hashCode();
        return h;
    }

    public String toString() {
        return "ListServiceBindingsRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", names=" + this.names + ", serviceInstanceIds=" + this.serviceInstanceIds + ", serviceInstanceNames=" + this.serviceInstanceNames + ", applicationIds=" + this.applicationIds + ", appNames=" + this.appNames + ", servicePlanIds=" + this.servicePlanIds + ", servicePlanNames=" + this.servicePlanNames + ", serviceOfferingIds=" + this.serviceOfferingIds + ", serviceOfferingNames=" + this.serviceOfferingNames + ", type=" + (Object)((Object)this.type) + ", ids=" + this.ids + "}";
    }

    private static ListServiceBindingsRequest validate(ListServiceBindingsRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListServiceBindingsRequest", generator="Immutables")
    public static final class Builder {
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> names = new ArrayList<String>();
        private List<String> serviceInstanceIds = new ArrayList<String>();
        private List<String> serviceInstanceNames = new ArrayList<String>();
        private List<String> applicationIds = new ArrayList<String>();
        private List<String> appNames = new ArrayList<String>();
        private List<String> servicePlanIds = new ArrayList<String>();
        private List<String> servicePlanNames = new ArrayList<String>();
        private List<String> serviceOfferingIds = new ArrayList<String>();
        private List<String> serviceOfferingNames = new ArrayList<String>();
        private ServiceBindingType type;
        private List<String> ids = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ListServiceBindingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListServiceBindingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListServiceBindingsRequest) {
                instance = (_ListServiceBindingsRequest)object;
                this.addAllServiceInstanceNames(((_ListServiceBindingsRequest)instance).getServiceInstanceNames());
                this.addAllNames(((_ListServiceBindingsRequest)instance).getNames());
                this.addAllServiceInstanceIds(((_ListServiceBindingsRequest)instance).getServiceInstanceIds());
                this.addAllAppNames(((_ListServiceBindingsRequest)instance).getAppNames());
                this.addAllServicePlanIds(((_ListServiceBindingsRequest)instance).getServicePlanIds());
                this.addAllServiceOfferingNames(((_ListServiceBindingsRequest)instance).getServiceOfferingNames());
                this.addAllIds(((_ListServiceBindingsRequest)instance).getIds());
                ServiceBindingType typeValue = ((_ListServiceBindingsRequest)instance).getType();
                if (typeValue != null) {
                    this.type(typeValue);
                }
                this.addAllServiceOfferingIds(((_ListServiceBindingsRequest)instance).getServiceOfferingIds());
                this.addAllServicePlanNames(((_ListServiceBindingsRequest)instance).getServicePlanNames());
                this.addAllApplicationIds(((_ListServiceBindingsRequest)instance).getApplicationIds());
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder name(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder serviceInstanceId(String element) {
            this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            return this;
        }

        public final Builder serviceInstanceIds(String ... elements) {
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceIds(Iterable<String> elements) {
            this.serviceInstanceIds.clear();
            return this.addAllServiceInstanceIds(elements);
        }

        public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceName(String element) {
            this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
            return this;
        }

        public final Builder serviceInstanceNames(String ... elements) {
            for (String element : elements) {
                this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
            }
            return this;
        }

        public final Builder serviceInstanceNames(Iterable<String> elements) {
            this.serviceInstanceNames.clear();
            return this.addAllServiceInstanceNames(elements);
        }

        public final Builder addAllServiceInstanceNames(Iterable<String> elements) {
            for (String element : elements) {
                this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
            }
            return this;
        }

        public final Builder applicationId(String element) {
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(Iterable<String> elements) {
            this.applicationIds.clear();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder appName(String element) {
            this.appNames.add(Objects.requireNonNull(element, "appNames element"));
            return this;
        }

        public final Builder appNames(String ... elements) {
            for (String element : elements) {
                this.appNames.add(Objects.requireNonNull(element, "appNames element"));
            }
            return this;
        }

        public final Builder appNames(Iterable<String> elements) {
            this.appNames.clear();
            return this.addAllAppNames(elements);
        }

        public final Builder addAllAppNames(Iterable<String> elements) {
            for (String element : elements) {
                this.appNames.add(Objects.requireNonNull(element, "appNames element"));
            }
            return this;
        }

        public final Builder servicePlanId(String element) {
            this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
            return this;
        }

        public final Builder servicePlanIds(String ... elements) {
            for (String element : elements) {
                this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
            }
            return this;
        }

        public final Builder servicePlanIds(Iterable<String> elements) {
            this.servicePlanIds.clear();
            return this.addAllServicePlanIds(elements);
        }

        public final Builder addAllServicePlanIds(Iterable<String> elements) {
            for (String element : elements) {
                this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
            }
            return this;
        }

        public final Builder servicePlanName(String element) {
            this.servicePlanNames.add(Objects.requireNonNull(element, "servicePlanNames element"));
            return this;
        }

        public final Builder servicePlanNames(String ... elements) {
            for (String element : elements) {
                this.servicePlanNames.add(Objects.requireNonNull(element, "servicePlanNames element"));
            }
            return this;
        }

        public final Builder servicePlanNames(Iterable<String> elements) {
            this.servicePlanNames.clear();
            return this.addAllServicePlanNames(elements);
        }

        public final Builder addAllServicePlanNames(Iterable<String> elements) {
            for (String element : elements) {
                this.servicePlanNames.add(Objects.requireNonNull(element, "servicePlanNames element"));
            }
            return this;
        }

        public final Builder serviceOfferingId(String element) {
            this.serviceOfferingIds.add(Objects.requireNonNull(element, "serviceOfferingIds element"));
            return this;
        }

        public final Builder serviceOfferingIds(String ... elements) {
            for (String element : elements) {
                this.serviceOfferingIds.add(Objects.requireNonNull(element, "serviceOfferingIds element"));
            }
            return this;
        }

        public final Builder serviceOfferingIds(Iterable<String> elements) {
            this.serviceOfferingIds.clear();
            return this.addAllServiceOfferingIds(elements);
        }

        public final Builder addAllServiceOfferingIds(Iterable<String> elements) {
            for (String element : elements) {
                this.serviceOfferingIds.add(Objects.requireNonNull(element, "serviceOfferingIds element"));
            }
            return this;
        }

        public final Builder serviceOfferingName(String element) {
            this.serviceOfferingNames.add(Objects.requireNonNull(element, "serviceOfferingNames element"));
            return this;
        }

        public final Builder serviceOfferingNames(String ... elements) {
            for (String element : elements) {
                this.serviceOfferingNames.add(Objects.requireNonNull(element, "serviceOfferingNames element"));
            }
            return this;
        }

        public final Builder serviceOfferingNames(Iterable<String> elements) {
            this.serviceOfferingNames.clear();
            return this.addAllServiceOfferingNames(elements);
        }

        public final Builder addAllServiceOfferingNames(Iterable<String> elements) {
            for (String element : elements) {
                this.serviceOfferingNames.add(Objects.requireNonNull(element, "serviceOfferingNames element"));
            }
            return this;
        }

        public final Builder type(@Nullable ServiceBindingType type) {
            this.type = type;
            return this;
        }

        public final Builder id(String element) {
            this.ids.add(Objects.requireNonNull(element, "ids element"));
            return this;
        }

        public final Builder ids(String ... elements) {
            for (String element : elements) {
                this.ids.add(Objects.requireNonNull(element, "ids element"));
            }
            return this;
        }

        public final Builder ids(Iterable<String> elements) {
            this.ids.clear();
            return this.addAllIds(elements);
        }

        public final Builder addAllIds(Iterable<String> elements) {
            for (String element : elements) {
                this.ids.add(Objects.requireNonNull(element, "ids element"));
            }
            return this;
        }

        public ListServiceBindingsRequest build() {
            return ListServiceBindingsRequest.validate(new ListServiceBindingsRequest(this));
        }
    }
}

