/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.serviceplans.Features;
import org.cloudfoundry.client.v3.serviceplans._BrokerCatalog;
import org.immutables.value.Generated;

@Generated(from="_BrokerCatalog", generator="Immutables")
public final class BrokerCatalog
extends _BrokerCatalog {
    private final String brokerCatalogId;
    private final Features features;
    @Nullable
    private final Integer maximumPollingDuration;
    @Nullable
    private final Map<String, Object> metadata;

    private BrokerCatalog(Builder builder) {
        this.brokerCatalogId = builder.brokerCatalogId;
        this.features = builder.features;
        this.maximumPollingDuration = builder.maximumPollingDuration;
        this.metadata = builder.metadata == null ? null : BrokerCatalog.createUnmodifiableMap(false, false, builder.metadata);
    }

    @Override
    @JsonProperty(value="id")
    public String getBrokerCatalogId() {
        return this.brokerCatalogId;
    }

    @Override
    @JsonProperty(value="features")
    public Features getFeatures() {
        return this.features;
    }

    @Override
    @JsonProperty(value="maximum_polling_duration")
    @Nullable
    public Integer getMaximumPollingDuration() {
        return this.maximumPollingDuration;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BrokerCatalog && this.equalTo(0, (BrokerCatalog)another);
    }

    private boolean equalTo(int synthetic, BrokerCatalog another) {
        return this.brokerCatalogId.equals(another.brokerCatalogId) && this.features.equals(another.features) && Objects.equals(this.maximumPollingDuration, another.maximumPollingDuration) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.brokerCatalogId.hashCode();
        h += (h << 5) + this.features.hashCode();
        h += (h << 5) + Objects.hashCode(this.maximumPollingDuration);
        h += (h << 5) + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "BrokerCatalog{brokerCatalogId=" + this.brokerCatalogId + ", features=" + this.features + ", maximumPollingDuration=" + this.maximumPollingDuration + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BrokerCatalog fromJson(Json json) {
        Builder builder = BrokerCatalog.builder();
        if (json.brokerCatalogId != null) {
            builder.brokerCatalogId(json.brokerCatalogId);
        }
        if (json.features != null) {
            builder.features(json.features);
        }
        if (json.maximumPollingDuration != null) {
            builder.maximumPollingDuration(json.maximumPollingDuration);
        }
        if (json.metadata != null) {
            builder.putAllMetadata(json.metadata);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_BrokerCatalog", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_BROKER_CATALOG_ID = 1L;
        private static final long INIT_BIT_FEATURES = 2L;
        private long initBits = 3L;
        private String brokerCatalogId;
        private Features features;
        private Integer maximumPollingDuration;
        private Map<String, Object> metadata = null;

        private Builder() {
        }

        public final Builder from(BrokerCatalog instance) {
            return this.from((_BrokerCatalog)instance);
        }

        final Builder from(_BrokerCatalog instance) {
            Map<String, Object> metadataValue;
            Objects.requireNonNull(instance, "instance");
            this.brokerCatalogId(instance.getBrokerCatalogId());
            this.features(instance.getFeatures());
            Integer maximumPollingDurationValue = instance.getMaximumPollingDuration();
            if (maximumPollingDurationValue != null) {
                this.maximumPollingDuration(maximumPollingDurationValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.putAllMetadata(metadataValue);
            }
            return this;
        }

        @JsonProperty(value="id")
        public final Builder brokerCatalogId(String brokerCatalogId) {
            this.brokerCatalogId = Objects.requireNonNull(brokerCatalogId, "brokerCatalogId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="features")
        public final Builder features(Features features) {
            this.features = Objects.requireNonNull(features, "features");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="maximum_polling_duration")
        public final Builder maximumPollingDuration(@Nullable Integer maximumPollingDuration) {
            this.maximumPollingDuration = maximumPollingDuration;
            return this;
        }

        public final Builder metadata(String key, Object value) {
            if (this.metadata == null) {
                this.metadata = new LinkedHashMap<String, Object>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public final Builder metadata(Map.Entry<String, ? extends Object> entry) {
            if (this.metadata == null) {
                this.metadata = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.metadata.put(k, v);
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.metadata = null;
                return this;
            }
            this.metadata = new LinkedHashMap<String, Object>();
            return this.putAllMetadata(entries);
        }

        public final Builder putAllMetadata(Map<String, ? extends Object> entries) {
            if (this.metadata == null) {
                this.metadata = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.metadata.put(k, v);
            }
            return this;
        }

        public BrokerCatalog build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BrokerCatalog(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("brokerCatalogId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("features");
            }
            return "Cannot build BrokerCatalog, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_BrokerCatalog", generator="Immutables")
    static final class Json
    extends _BrokerCatalog {
        String brokerCatalogId;
        Features features;
        Integer maximumPollingDuration;
        Map<String, Object> metadata = null;

        Json() {
        }

        @JsonProperty(value="id")
        public void setBrokerCatalogId(String brokerCatalogId) {
            this.brokerCatalogId = brokerCatalogId;
        }

        @JsonProperty(value="features")
        public void setFeatures(Features features) {
            this.features = features;
        }

        @JsonProperty(value="maximum_polling_duration")
        public void setMaximumPollingDuration(@Nullable Integer maximumPollingDuration) {
            this.maximumPollingDuration = maximumPollingDuration;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Map<String, Object> metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getBrokerCatalogId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Features getFeatures() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMaximumPollingDuration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

