/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.logcache.v1._Metadata;
import org.immutables.value.Generated;

@Generated(from="_Metadata", generator="Immutables")
public final class Metadata
extends _Metadata {
    private final Long count;
    private final Long expired;
    private final Long newestTimestamp;
    private final Long oldestTimestamp;

    private Metadata(Builder builder) {
        this.count = builder.count;
        this.expired = builder.expired;
        this.newestTimestamp = builder.newestTimestamp;
        this.oldestTimestamp = builder.oldestTimestamp;
    }

    @Override
    @JsonProperty(value="count")
    public Long getCount() {
        return this.count;
    }

    @Override
    @JsonProperty(value="expired")
    public Optional<Long> getExpired() {
        return Optional.ofNullable(this.expired);
    }

    @Override
    @JsonProperty(value="newestTimestamp")
    public Long getNewestTimestamp() {
        return this.newestTimestamp;
    }

    @Override
    @JsonProperty(value="oldestTimestamp")
    public Long getOldestTimestamp() {
        return this.oldestTimestamp;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Metadata && this.equalTo(0, (Metadata)another);
    }

    private boolean equalTo(int synthetic, Metadata another) {
        return this.count.equals(another.count) && Objects.equals(this.expired, another.expired) && this.newestTimestamp.equals(another.newestTimestamp) && this.oldestTimestamp.equals(another.oldestTimestamp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.count.hashCode();
        h += (h << 5) + Objects.hashCode(this.expired);
        h += (h << 5) + this.newestTimestamp.hashCode();
        h += (h << 5) + this.oldestTimestamp.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Metadata{");
        builder.append("count=").append(this.count);
        if (this.expired != null) {
            builder.append(", ");
            builder.append("expired=").append(this.expired);
        }
        builder.append(", ");
        builder.append("newestTimestamp=").append(this.newestTimestamp);
        builder.append(", ");
        builder.append("oldestTimestamp=").append(this.oldestTimestamp);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Metadata fromJson(Json json) {
        Builder builder = Metadata.builder();
        if (json.count != null) {
            builder.count(json.count);
        }
        if (json.expired != null) {
            builder.expired(json.expired);
        }
        if (json.newestTimestamp != null) {
            builder.newestTimestamp(json.newestTimestamp);
        }
        if (json.oldestTimestamp != null) {
            builder.oldestTimestamp(json.oldestTimestamp);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_Metadata", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long INIT_BIT_NEWEST_TIMESTAMP = 2L;
        private static final long INIT_BIT_OLDEST_TIMESTAMP = 4L;
        private long initBits = 7L;
        private Long count;
        private Long expired;
        private Long newestTimestamp;
        private Long oldestTimestamp;

        private Builder() {
        }

        public final Builder from(Metadata instance) {
            return this.from((_Metadata)instance);
        }

        final Builder from(_Metadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.count(instance.getCount());
            Optional<Long> expiredOptional = instance.getExpired();
            if (expiredOptional.isPresent()) {
                this.expired(expiredOptional);
            }
            this.newestTimestamp(instance.getNewestTimestamp());
            this.oldestTimestamp(instance.getOldestTimestamp());
            return this;
        }

        @JsonProperty(value="count")
        public final Builder count(Long count) {
            this.count = Objects.requireNonNull(count, "count");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder expired(long expired) {
            this.expired = expired;
            return this;
        }

        @JsonProperty(value="expired")
        public final Builder expired(Optional<Long> expired) {
            this.expired = expired.orElse(null);
            return this;
        }

        @JsonProperty(value="newestTimestamp")
        public final Builder newestTimestamp(Long newestTimestamp) {
            this.newestTimestamp = Objects.requireNonNull(newestTimestamp, "newestTimestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="oldestTimestamp")
        public final Builder oldestTimestamp(Long oldestTimestamp) {
            this.oldestTimestamp = Objects.requireNonNull(oldestTimestamp, "oldestTimestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Metadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Metadata(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("newestTimestamp");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("oldestTimestamp");
            }
            return "Cannot build Metadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_Metadata", generator="Immutables")
    static final class Json
    extends _Metadata {
        Long count;
        Optional<Long> expired = Optional.empty();
        Long newestTimestamp;
        Long oldestTimestamp;

        Json() {
        }

        @JsonProperty(value="count")
        public void setCount(Long count) {
            this.count = count;
        }

        @JsonProperty(value="expired")
        public void setExpired(Optional<Long> expired) {
            this.expired = expired;
        }

        @JsonProperty(value="newestTimestamp")
        public void setNewestTimestamp(Long newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
        }

        @JsonProperty(value="oldestTimestamp")
        public void setOldestTimestamp(Long oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
        }

        @Override
        public Long getCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getExpired() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getNewestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getOldestTimestamp() {
            throw new UnsupportedOperationException();
        }
    }
}

