/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.routing.v1.tcproutes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.routing.v1.ModificationTag;
import org.cloudfoundry.routing.v1.tcproutes.AbstractTcpRoute;
import org.cloudfoundry.routing.v1.tcproutes.EventType;
import org.cloudfoundry.routing.v1.tcproutes._TcpRouteEvent;
import org.immutables.value.Generated;

@Generated(from="_TcpRouteEvent", generator="Immutables")
public final class TcpRouteEvent
extends _TcpRouteEvent {
    private final String backendIp;
    private final Integer backendPort;
    @Nullable
    private final String isolationSegment;
    private final ModificationTag modificationTag;
    private final Integer port;
    private final String routerGroupId;
    private final Integer ttl;
    @Nullable
    private final Integer backendTlsPort;
    @Nullable
    private final Integer instanceId;
    private final EventType eventType;

    private TcpRouteEvent(Builder builder) {
        this.backendIp = builder.backendIp;
        this.backendPort = builder.backendPort;
        this.isolationSegment = builder.isolationSegment;
        this.modificationTag = builder.modificationTag;
        this.port = builder.port;
        this.routerGroupId = builder.routerGroupId;
        this.ttl = builder.ttl;
        this.backendTlsPort = builder.backendTlsPort;
        this.instanceId = builder.instanceId;
        this.eventType = builder.eventType;
    }

    @Override
    @JsonProperty(value="backend_ip")
    public String getBackendIp() {
        return this.backendIp;
    }

    @Override
    @JsonProperty(value="backend_port")
    public Integer getBackendPort() {
        return this.backendPort;
    }

    @Override
    @JsonProperty(value="isolation_segment")
    @Nullable
    public String getIsolationSegment() {
        return this.isolationSegment;
    }

    @Override
    @JsonProperty(value="modification_tag")
    public ModificationTag getModificationTag() {
        return this.modificationTag;
    }

    @Override
    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="router_group_guid")
    public String getRouterGroupId() {
        return this.routerGroupId;
    }

    @Override
    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    @Override
    @JsonProperty(value="backend_tls_port")
    @Nullable
    public Integer getBackendTlsPort() {
        return this.backendTlsPort;
    }

    @Override
    @JsonProperty(value="instance_id")
    @Nullable
    public Integer getInstanceId() {
        return this.instanceId;
    }

    @Override
    @JsonProperty(value="eventType")
    public EventType getEventType() {
        return this.eventType;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TcpRouteEvent && this.equalTo(0, (TcpRouteEvent)another);
    }

    private boolean equalTo(int synthetic, TcpRouteEvent another) {
        return this.backendIp.equals(another.backendIp) && this.backendPort.equals(another.backendPort) && Objects.equals(this.isolationSegment, another.isolationSegment) && this.modificationTag.equals(another.modificationTag) && this.port.equals(another.port) && this.routerGroupId.equals(another.routerGroupId) && this.ttl.equals(another.ttl) && Objects.equals(this.backendTlsPort, another.backendTlsPort) && Objects.equals(this.instanceId, another.instanceId) && this.eventType.equals((Object)another.eventType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.backendIp.hashCode();
        h += (h << 5) + this.backendPort.hashCode();
        h += (h << 5) + Objects.hashCode(this.isolationSegment);
        h += (h << 5) + this.modificationTag.hashCode();
        h += (h << 5) + this.port.hashCode();
        h += (h << 5) + this.routerGroupId.hashCode();
        h += (h << 5) + this.ttl.hashCode();
        h += (h << 5) + Objects.hashCode(this.backendTlsPort);
        h += (h << 5) + Objects.hashCode(this.instanceId);
        h += (h << 5) + this.eventType.hashCode();
        return h;
    }

    public String toString() {
        return "TcpRouteEvent{backendIp=" + this.backendIp + ", backendPort=" + this.backendPort + ", isolationSegment=" + this.isolationSegment + ", modificationTag=" + this.modificationTag + ", port=" + this.port + ", routerGroupId=" + this.routerGroupId + ", ttl=" + this.ttl + ", backendTlsPort=" + this.backendTlsPort + ", instanceId=" + this.instanceId + ", eventType=" + (Object)((Object)this.eventType) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static TcpRouteEvent fromJson(Json json) {
        Builder builder = TcpRouteEvent.builder();
        if (json.backendIp != null) {
            builder.backendIp(json.backendIp);
        }
        if (json.backendPort != null) {
            builder.backendPort(json.backendPort);
        }
        if (json.isolationSegment != null) {
            builder.isolationSegment(json.isolationSegment);
        }
        if (json.modificationTag != null) {
            builder.modificationTag(json.modificationTag);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.routerGroupId != null) {
            builder.routerGroupId(json.routerGroupId);
        }
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        if (json.backendTlsPort != null) {
            builder.backendTlsPort(json.backendTlsPort);
        }
        if (json.instanceId != null) {
            builder.instanceId(json.instanceId);
        }
        if (json.eventType != null) {
            builder.eventType(json.eventType);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_TcpRouteEvent", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_BACKEND_IP = 1L;
        private static final long INIT_BIT_BACKEND_PORT = 2L;
        private static final long INIT_BIT_MODIFICATION_TAG = 4L;
        private static final long INIT_BIT_PORT = 8L;
        private static final long INIT_BIT_ROUTER_GROUP_ID = 16L;
        private static final long INIT_BIT_TTL = 32L;
        private static final long INIT_BIT_EVENT_TYPE = 64L;
        private long initBits = 127L;
        private String backendIp;
        private Integer backendPort;
        private String isolationSegment;
        private ModificationTag modificationTag;
        private Integer port;
        private String routerGroupId;
        private Integer ttl;
        private Integer backendTlsPort;
        private Integer instanceId;
        private EventType eventType;

        private Builder() {
        }

        public final Builder from(TcpRouteEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_TcpRouteEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractTcpRoute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            AbstractTcpRoute instance;
            if (object instanceof _TcpRouteEvent) {
                instance = (_TcpRouteEvent)object;
                this.eventType(((_TcpRouteEvent)instance).getEventType());
            }
            if (object instanceof AbstractTcpRoute) {
                String isolationSegmentValue;
                instance = (AbstractTcpRoute)object;
                this.backendPort(instance.getBackendPort());
                Integer instanceIdValue = instance.getInstanceId();
                if (instanceIdValue != null) {
                    this.instanceId(instanceIdValue);
                }
                if ((isolationSegmentValue = instance.getIsolationSegment()) != null) {
                    this.isolationSegment(isolationSegmentValue);
                }
                this.port(instance.getPort());
                this.modificationTag(instance.getModificationTag());
                Integer backendTlsPortValue = instance.getBackendTlsPort();
                if (backendTlsPortValue != null) {
                    this.backendTlsPort(backendTlsPortValue);
                }
                this.routerGroupId(instance.getRouterGroupId());
                this.ttl(instance.getTtl());
                this.backendIp(instance.getBackendIp());
            }
        }

        @JsonProperty(value="backend_ip")
        public final Builder backendIp(String backendIp) {
            this.backendIp = Objects.requireNonNull(backendIp, "backendIp");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="backend_port")
        public final Builder backendPort(Integer backendPort) {
            this.backendPort = Objects.requireNonNull(backendPort, "backendPort");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="isolation_segment")
        public final Builder isolationSegment(@Nullable String isolationSegment) {
            this.isolationSegment = isolationSegment;
            return this;
        }

        @JsonProperty(value="modification_tag")
        public final Builder modificationTag(ModificationTag modificationTag) {
            this.modificationTag = Objects.requireNonNull(modificationTag, "modificationTag");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="port")
        public final Builder port(Integer port) {
            this.port = Objects.requireNonNull(port, "port");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="router_group_guid")
        public final Builder routerGroupId(String routerGroupId) {
            this.routerGroupId = Objects.requireNonNull(routerGroupId, "routerGroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="ttl")
        public final Builder ttl(Integer ttl) {
            this.ttl = Objects.requireNonNull(ttl, "ttl");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="backend_tls_port")
        public final Builder backendTlsPort(@Nullable Integer backendTlsPort) {
            this.backendTlsPort = backendTlsPort;
            return this;
        }

        @JsonProperty(value="instance_id")
        public final Builder instanceId(@Nullable Integer instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @JsonProperty(value="eventType")
        public final Builder eventType(EventType eventType) {
            this.eventType = Objects.requireNonNull(eventType, "eventType");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public TcpRouteEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TcpRouteEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("backendIp");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("backendPort");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("modificationTag");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("port");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("routerGroupId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("ttl");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("eventType");
            }
            return "Cannot build TcpRouteEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_TcpRouteEvent", generator="Immutables")
    static final class Json
    extends _TcpRouteEvent {
        String backendIp;
        Integer backendPort;
        String isolationSegment;
        ModificationTag modificationTag;
        Integer port;
        String routerGroupId;
        Integer ttl;
        Integer backendTlsPort;
        Integer instanceId;
        EventType eventType;

        Json() {
        }

        @JsonProperty(value="backend_ip")
        public void setBackendIp(String backendIp) {
            this.backendIp = backendIp;
        }

        @JsonProperty(value="backend_port")
        public void setBackendPort(Integer backendPort) {
            this.backendPort = backendPort;
        }

        @JsonProperty(value="isolation_segment")
        public void setIsolationSegment(@Nullable String isolationSegment) {
            this.isolationSegment = isolationSegment;
        }

        @JsonProperty(value="modification_tag")
        public void setModificationTag(ModificationTag modificationTag) {
            this.modificationTag = modificationTag;
        }

        @JsonProperty(value="port")
        public void setPort(Integer port) {
            this.port = port;
        }

        @JsonProperty(value="router_group_guid")
        public void setRouterGroupId(String routerGroupId) {
            this.routerGroupId = routerGroupId;
        }

        @JsonProperty(value="ttl")
        public void setTtl(Integer ttl) {
            this.ttl = ttl;
        }

        @JsonProperty(value="backend_tls_port")
        public void setBackendTlsPort(@Nullable Integer backendTlsPort) {
            this.backendTlsPort = backendTlsPort;
        }

        @JsonProperty(value="instance_id")
        public void setInstanceId(@Nullable Integer instanceId) {
            this.instanceId = instanceId;
        }

        @JsonProperty(value="eventType")
        public void setEventType(EventType eventType) {
            this.eventType = eventType;
        }

        @Override
        public String getBackendIp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getBackendPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIsolationSegment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ModificationTag getModificationTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouterGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getTtl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getBackendTlsPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInstanceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventType getEventType() {
            throw new UnsupportedOperationException();
        }
    }
}

