/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ExternalGroupMappingMode {
    EXPLICITLY_MAPPED("EXPLICITLY_MAPPED"),
    AS_SCOPES("AS_SCOPES");

    private final String value;

    private ExternalGroupMappingMode(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ExternalGroupMappingMode from(String s) {
        switch (s.toLowerCase()) {
            case "explicitly_mapped": {
                return EXPLICITLY_MAPPED;
            }
            case "as_scopes": {
                return AS_SCOPES;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown external group mapping mode: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

