package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Update a Route operation
 */
@Generated(from = "_UpdateRouteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateRouteRequest extends org.cloudfoundry.client.v2.routes._UpdateRouteRequest {
  private final @Nullable String domainId;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;
  private final String routeId;
  private final @Nullable String spaceId;

  private UpdateRouteRequest(UpdateRouteRequest.Builder builder) {
    this.domainId = builder.domainId;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
    this.routeId = builder.routeId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The domain id
   */
  @JsonProperty("domain_guid")
  @Override
  public @Nullable String getDomainId() {
    return domainId;
  }

  /**
   * The host
   */
  @JsonProperty("host")
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path
   */
  @JsonProperty("path")
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port
   */
  @JsonProperty("port")
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * The route id
   */
  @JsonProperty("routeId")
  @JsonIgnore
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateRouteRequest
        && equalTo((UpdateRouteRequest) another);
  }

  private boolean equalTo(UpdateRouteRequest another) {
    return Objects.equals(domainId, another.domainId)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port)
        && routeId.equals(another.routeId)
        && Objects.equals(spaceId, another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code domainId}, {@code host}, {@code path}, {@code port}, {@code routeId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(domainId);
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + routeId.hashCode();
    h += (h << 5) + Objects.hashCode(spaceId);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateRouteRequest{"
        + "domainId=" + domainId
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + ", routeId=" + routeId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateRouteRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.routes._UpdateRouteRequest {
    String domainId;
    String host;
    String path;
    Integer port;
    String routeId;
    String spaceId;
    @JsonProperty("domain_guid")
    public void setDomainId(@Nullable String domainId) {
      this.domainId = domainId;
    }
    @JsonProperty("host")
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonProperty("path")
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty("port")
    public void setPort(@Nullable Integer port) {
      this.port = port;
    }
    @JsonProperty("routeId")
    @JsonIgnore
    public void setRouteId(String routeId) {
      this.routeId = routeId;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @Override
    public String getDomainId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateRouteRequest fromJson(Json json) {
    UpdateRouteRequest.Builder builder = UpdateRouteRequest.builder();
    if (json.domainId != null) {
      builder.domainId(json.domainId);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.routeId != null) {
      builder.routeId(json.routeId);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateRouteRequest UpdateRouteRequest}.
   * <pre>
   * UpdateRouteRequest.builder()
   *    .domainId(String | null) // nullable {@link UpdateRouteRequest#getDomainId() domainId}
   *    .host(String | null) // nullable {@link UpdateRouteRequest#getHost() host}
   *    .path(String | null) // nullable {@link UpdateRouteRequest#getPath() path}
   *    .port(Integer | null) // nullable {@link UpdateRouteRequest#getPort() port}
   *    .routeId(String) // required {@link UpdateRouteRequest#getRouteId() routeId}
   *    .spaceId(String | null) // nullable {@link UpdateRouteRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new UpdateRouteRequest builder
   */
  public static UpdateRouteRequest.Builder builder() {
    return new UpdateRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateRouteRequest UpdateRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateRouteRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private long initBits = 0x1L;

    private String domainId;
    private String host;
    private String path;
    private Integer port;
    private String routeId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateRouteRequest instance) {
      return from((_UpdateRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String domainIdValue = instance.getDomainId();
      if (domainIdValue != null) {
        domainId(domainIdValue);
      }
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      routeId(instance.getRouteId());
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouteRequest#getDomainId() domainId} attribute.
     * @param domainId The value for domainId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(@Nullable String domainId) {
      this.domainId = domainId;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouteRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouteRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateRouteRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Builds a new {@link UpdateRouteRequest UpdateRouteRequest}.
     * @return An immutable instance of UpdateRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build UpdateRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
