package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Update a Security Group operation
 */
@Generated(from = "_UpdateSecurityGroupRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateSecurityGroupRequest
    extends org.cloudfoundry.client.v2.securitygroups._UpdateSecurityGroupRequest {
  private final String name;
  private final @Nullable List<RuleEntity> rules;
  private final String securityGroupId;
  private final @Nullable List<String> spaceIds;

  private UpdateSecurityGroupRequest(UpdateSecurityGroupRequest.Builder builder) {
    this.name = builder.name;
    this.rules = builder.rules == null ? null : createUnmodifiableList(true, builder.rules);
    this.securityGroupId = builder.securityGroupId;
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
  }

  /**
   * The security group name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The security group rules
   */
  @JsonProperty("rules")
  @Override
  public @Nullable List<RuleEntity> getRules() {
    return rules;
  }

  /**
   * The security group id
   */
  @JsonProperty("securityGroupId")
  @JsonIgnore
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * The list of associated spaces
   */
  @JsonProperty("space_guids")
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * This instance is equal to all instances of {@code UpdateSecurityGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateSecurityGroupRequest
        && equalTo((UpdateSecurityGroupRequest) another);
  }

  private boolean equalTo(UpdateSecurityGroupRequest another) {
    return name.equals(another.name)
        && Objects.equals(rules, another.rules)
        && securityGroupId.equals(another.securityGroupId)
        && Objects.equals(spaceIds, another.spaceIds);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code rules}, {@code securityGroupId}, {@code spaceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(rules);
    h += (h << 5) + securityGroupId.hashCode();
    h += (h << 5) + Objects.hashCode(spaceIds);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateSecurityGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateSecurityGroupRequest{"
        + "name=" + name
        + ", rules=" + rules
        + ", securityGroupId=" + securityGroupId
        + ", spaceIds=" + spaceIds
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateSecurityGroupRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.securitygroups._UpdateSecurityGroupRequest {
    String name;
    List<RuleEntity> rules = null;
    String securityGroupId;
    List<String> spaceIds = null;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("rules")
    public void setRules(@Nullable List<RuleEntity> rules) {
      this.rules = rules;
    }
    @JsonProperty("securityGroupId")
    @JsonIgnore
    public void setSecurityGroupId(String securityGroupId) {
      this.securityGroupId = securityGroupId;
    }
    @JsonProperty("space_guids")
    public void setSpaceIds(@Nullable List<String> spaceIds) {
      this.spaceIds = spaceIds;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<RuleEntity> getRules() { throw new UnsupportedOperationException(); }
    @Override
    public String getSecurityGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSpaceIds() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateSecurityGroupRequest fromJson(Json json) {
    UpdateSecurityGroupRequest.Builder builder = UpdateSecurityGroupRequest.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.rules != null) {
      builder.addAllRules(json.rules);
    }
    if (json.securityGroupId != null) {
      builder.securityGroupId(json.securityGroupId);
    }
    if (json.spaceIds != null) {
      builder.addAllSpaceIds(json.spaceIds);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateSecurityGroupRequest UpdateSecurityGroupRequest}.
   * <pre>
   * UpdateSecurityGroupRequest.builder()
   *    .name(String) // required {@link UpdateSecurityGroupRequest#getName() name}
   *    .rules(List&amp;lt;org.cloudfoundry.client.v2.securitygroups.RuleEntity&amp;gt; | null) // nullable {@link UpdateSecurityGroupRequest#getRules() rules}
   *    .securityGroupId(String) // required {@link UpdateSecurityGroupRequest#getSecurityGroupId() securityGroupId}
   *    .spaceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateSecurityGroupRequest#getSpaceIds() spaceIds}
   *    .build();
   * </pre>
   * @return A new UpdateSecurityGroupRequest builder
   */
  public static UpdateSecurityGroupRequest.Builder builder() {
    return new UpdateSecurityGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateSecurityGroupRequest UpdateSecurityGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateSecurityGroupRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private List<RuleEntity> rules = null;
    private String securityGroupId;
    private List<String> spaceIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateSecurityGroupRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateSecurityGroupRequest instance) {
      return from((_UpdateSecurityGroupRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateSecurityGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      List<RuleEntity> rulesValue = instance.getRules();
      if (rulesValue != null) {
        addAllRules(rulesValue);
      }
      securityGroupId(instance.getSecurityGroupId());
      List<String> spaceIdsValue = instance.getSpaceIds();
      if (spaceIdsValue != null) {
        addAllSpaceIds(spaceIdsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSecurityGroupRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link UpdateSecurityGroupRequest#getRules() rules} list.
     * @param element A rules element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rule(RuleEntity element) {
      if (this.rules == null) {
        this.rules = new ArrayList<RuleEntity>();
      }
      this.rules.add(Objects.requireNonNull(element, "rules element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateSecurityGroupRequest#getRules() rules} list.
     * @param elements An array of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(RuleEntity... elements) {
      if (this.rules == null) {
        this.rules = new ArrayList<RuleEntity>();
      }
      for (RuleEntity element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateSecurityGroupRequest#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(@Nullable Iterable<? extends RuleEntity> elements) {
      if (elements == null) {
        this.rules = null;
        return this;
      }
      this.rules = new ArrayList<RuleEntity>();
      return addAllRules(elements);
    }

    /**
     * Adds elements to {@link UpdateSecurityGroupRequest#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRules(Iterable<? extends RuleEntity> elements) {
      Objects.requireNonNull(elements, "rules element");
      if (this.rules == null) {
        this.rules = new ArrayList<RuleEntity>();
      }
      for (RuleEntity element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSecurityGroupRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Adds one element to {@link UpdateSecurityGroupRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateSecurityGroupRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateSecurityGroupRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link UpdateSecurityGroupRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateSecurityGroupRequest UpdateSecurityGroupRequest}.
     * @return An immutable instance of UpdateSecurityGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateSecurityGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateSecurityGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      return "Cannot build UpdateSecurityGroupRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
