package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.MaintenanceInfo;
import org.immutables.value.Generated;

/**
 * A service instance
 */
@Generated(from = "_ServiceInstance", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceInstance extends org.cloudfoundry.client.v2.serviceinstances._ServiceInstance {
  private final @Nullable Integer boundApplicationCount;
  private final @Nullable String dashboardUrl;
  private final @Nullable String id;
  private final @Nullable LastOperation lastOperation;
  private final @Nullable MaintenanceInfo maintenanceInfo;
  private final @Nullable String name;
  private final @Nullable String serviceBrokerName;
  private final @Nullable Plan servicePlan;
  private final @Nullable Share sharedFrom;
  private final @Nullable List<Share> sharedTo;
  private final @Nullable String type;

  private ServiceInstance(ServiceInstance.Builder builder) {
    this.boundApplicationCount = builder.boundApplicationCount;
    this.dashboardUrl = builder.dashboardUrl;
    this.id = builder.id;
    this.lastOperation = builder.lastOperation;
    this.maintenanceInfo = builder.maintenanceInfo;
    this.name = builder.name;
    this.serviceBrokerName = builder.serviceBrokerName;
    this.servicePlan = builder.servicePlan;
    this.sharedFrom = builder.sharedFrom;
    this.sharedTo = builder.sharedTo == null ? null : createUnmodifiableList(true, builder.sharedTo);
    this.type = builder.type;
  }

  /**
   * The bound application count
   */
  @JsonProperty("bound_app_count")
  @Override
  public @Nullable Integer getBoundApplicationCount() {
    return boundApplicationCount;
  }

  /**
   * The dashboard url
   */
  @JsonProperty("dashboard_url")
  @Override
  public @Nullable String getDashboardUrl() {
    return dashboardUrl;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The last operation
   */
  @JsonProperty("last_operation")
  @Override
  public @Nullable LastOperation getLastOperation() {
    return lastOperation;
  }

  /**
   * The maintenance info
   */
  @JsonProperty("maintenance_info")
  @Override
  public @Nullable MaintenanceInfo getMaintenanceInfo() {
    return maintenanceInfo;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The service broker name
   */
  @JsonProperty("service_broker_name")
  @Override
  public @Nullable String getServiceBrokerName() {
    return serviceBrokerName;
  }

  /**
   * The service plan
   */
  @JsonProperty("service_plan")
  @Override
  public @Nullable Plan getServicePlan() {
    return servicePlan;
  }

  /**
   * The shared from
   */
  @JsonProperty("shared_from")
  @Override
  public @Nullable Share getSharedFrom() {
    return sharedFrom;
  }

  /**
   * The shared to
   */
  @JsonProperty("shared_to")
  @Override
  public @Nullable List<Share> getSharedTo() {
    return sharedTo;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code ServiceInstance} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceInstance
        && equalTo((ServiceInstance) another);
  }

  private boolean equalTo(ServiceInstance another) {
    return Objects.equals(boundApplicationCount, another.boundApplicationCount)
        && Objects.equals(dashboardUrl, another.dashboardUrl)
        && Objects.equals(id, another.id)
        && Objects.equals(lastOperation, another.lastOperation)
        && Objects.equals(maintenanceInfo, another.maintenanceInfo)
        && Objects.equals(name, another.name)
        && Objects.equals(serviceBrokerName, another.serviceBrokerName)
        && Objects.equals(servicePlan, another.servicePlan)
        && Objects.equals(sharedFrom, another.sharedFrom)
        && Objects.equals(sharedTo, another.sharedTo)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code boundApplicationCount}, {@code dashboardUrl}, {@code id}, {@code lastOperation}, {@code maintenanceInfo}, {@code name}, {@code serviceBrokerName}, {@code servicePlan}, {@code sharedFrom}, {@code sharedTo}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(boundApplicationCount);
    h += (h << 5) + Objects.hashCode(dashboardUrl);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(lastOperation);
    h += (h << 5) + Objects.hashCode(maintenanceInfo);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(serviceBrokerName);
    h += (h << 5) + Objects.hashCode(servicePlan);
    h += (h << 5) + Objects.hashCode(sharedFrom);
    h += (h << 5) + Objects.hashCode(sharedTo);
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceInstance} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceInstance{"
        + "boundApplicationCount=" + boundApplicationCount
        + ", dashboardUrl=" + dashboardUrl
        + ", id=" + id
        + ", lastOperation=" + lastOperation
        + ", maintenanceInfo=" + maintenanceInfo
        + ", name=" + name
        + ", serviceBrokerName=" + serviceBrokerName
        + ", servicePlan=" + servicePlan
        + ", sharedFrom=" + sharedFrom
        + ", sharedTo=" + sharedTo
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServiceInstance", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._ServiceInstance {
    Integer boundApplicationCount;
    String dashboardUrl;
    String id;
    LastOperation lastOperation;
    MaintenanceInfo maintenanceInfo;
    String name;
    String serviceBrokerName;
    Plan servicePlan;
    Share sharedFrom;
    List<Share> sharedTo = null;
    String type;
    @JsonProperty("bound_app_count")
    public void setBoundApplicationCount(@Nullable Integer boundApplicationCount) {
      this.boundApplicationCount = boundApplicationCount;
    }
    @JsonProperty("dashboard_url")
    public void setDashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("last_operation")
    public void setLastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
    }
    @JsonProperty("maintenance_info")
    public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("service_broker_name")
    public void setServiceBrokerName(@Nullable String serviceBrokerName) {
      this.serviceBrokerName = serviceBrokerName;
    }
    @JsonProperty("service_plan")
    public void setServicePlan(@Nullable Plan servicePlan) {
      this.servicePlan = servicePlan;
    }
    @JsonProperty("shared_from")
    public void setSharedFrom(@Nullable Share sharedFrom) {
      this.sharedFrom = sharedFrom;
    }
    @JsonProperty("shared_to")
    public void setSharedTo(@Nullable List<Share> sharedTo) {
      this.sharedTo = sharedTo;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @Override
    public Integer getBoundApplicationCount() { throw new UnsupportedOperationException(); }
    @Override
    public String getDashboardUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public LastOperation getLastOperation() { throw new UnsupportedOperationException(); }
    @Override
    public MaintenanceInfo getMaintenanceInfo() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBrokerName() { throw new UnsupportedOperationException(); }
    @Override
    public Plan getServicePlan() { throw new UnsupportedOperationException(); }
    @Override
    public Share getSharedFrom() { throw new UnsupportedOperationException(); }
    @Override
    public List<Share> getSharedTo() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceInstance fromJson(Json json) {
    ServiceInstance.Builder builder = ServiceInstance.builder();
    if (json.boundApplicationCount != null) {
      builder.boundApplicationCount(json.boundApplicationCount);
    }
    if (json.dashboardUrl != null) {
      builder.dashboardUrl(json.dashboardUrl);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.lastOperation != null) {
      builder.lastOperation(json.lastOperation);
    }
    if (json.maintenanceInfo != null) {
      builder.maintenanceInfo(json.maintenanceInfo);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.serviceBrokerName != null) {
      builder.serviceBrokerName(json.serviceBrokerName);
    }
    if (json.servicePlan != null) {
      builder.servicePlan(json.servicePlan);
    }
    if (json.sharedFrom != null) {
      builder.sharedFrom(json.sharedFrom);
    }
    if (json.sharedTo != null) {
      builder.addAllSharedTo(json.sharedTo);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceInstance ServiceInstance}.
   * <pre>
   * ServiceInstance.builder()
   *    .boundApplicationCount(Integer | null) // nullable {@link ServiceInstance#getBoundApplicationCount() boundApplicationCount}
   *    .dashboardUrl(String | null) // nullable {@link ServiceInstance#getDashboardUrl() dashboardUrl}
   *    .id(String | null) // nullable {@link ServiceInstance#getId() id}
   *    .lastOperation(org.cloudfoundry.client.v2.serviceinstances.LastOperation | null) // nullable {@link ServiceInstance#getLastOperation() lastOperation}
   *    .maintenanceInfo(org.cloudfoundry.client.v2.MaintenanceInfo | null) // nullable {@link ServiceInstance#getMaintenanceInfo() maintenanceInfo}
   *    .name(String | null) // nullable {@link ServiceInstance#getName() name}
   *    .serviceBrokerName(String | null) // nullable {@link ServiceInstance#getServiceBrokerName() serviceBrokerName}
   *    .servicePlan(org.cloudfoundry.client.v2.serviceinstances.Plan | null) // nullable {@link ServiceInstance#getServicePlan() servicePlan}
   *    .sharedFrom(org.cloudfoundry.client.v2.serviceinstances.Share | null) // nullable {@link ServiceInstance#getSharedFrom() sharedFrom}
   *    .sharedTo(List&amp;lt;org.cloudfoundry.client.v2.serviceinstances.Share&amp;gt; | null) // nullable {@link ServiceInstance#getSharedTo() sharedTo}
   *    .type(String | null) // nullable {@link ServiceInstance#getType() type}
   *    .build();
   * </pre>
   * @return A new ServiceInstance builder
   */
  public static ServiceInstance.Builder builder() {
    return new ServiceInstance.Builder();
  }

  /**
   * Builds instances of type {@link ServiceInstance ServiceInstance}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceInstance", generator = "Immutables")
  public static final class Builder {
    private Integer boundApplicationCount;
    private String dashboardUrl;
    private String id;
    private LastOperation lastOperation;
    private MaintenanceInfo maintenanceInfo;
    private String name;
    private String serviceBrokerName;
    private Plan servicePlan;
    private Share sharedFrom;
    private List<Share> sharedTo = null;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceInstance} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceInstance instance) {
      return from((_ServiceInstance) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceInstance} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceInstance instance) {
      Objects.requireNonNull(instance, "instance");
      Integer boundApplicationCountValue = instance.getBoundApplicationCount();
      if (boundApplicationCountValue != null) {
        boundApplicationCount(boundApplicationCountValue);
      }
      String dashboardUrlValue = instance.getDashboardUrl();
      if (dashboardUrlValue != null) {
        dashboardUrl(dashboardUrlValue);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      LastOperation lastOperationValue = instance.getLastOperation();
      if (lastOperationValue != null) {
        lastOperation(lastOperationValue);
      }
      MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
      if (maintenanceInfoValue != null) {
        maintenanceInfo(maintenanceInfoValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String serviceBrokerNameValue = instance.getServiceBrokerName();
      if (serviceBrokerNameValue != null) {
        serviceBrokerName(serviceBrokerNameValue);
      }
      Plan servicePlanValue = instance.getServicePlan();
      if (servicePlanValue != null) {
        servicePlan(servicePlanValue);
      }
      Share sharedFromValue = instance.getSharedFrom();
      if (sharedFromValue != null) {
        sharedFrom(sharedFromValue);
      }
      List<Share> sharedToValue = instance.getSharedTo();
      if (sharedToValue != null) {
        addAllSharedTo(sharedToValue);
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getBoundApplicationCount() boundApplicationCount} attribute.
     * @param boundApplicationCount The value for boundApplicationCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("bound_app_count")
    public final Builder boundApplicationCount(@Nullable Integer boundApplicationCount) {
      this.boundApplicationCount = boundApplicationCount;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getDashboardUrl() dashboardUrl} attribute.
     * @param dashboardUrl The value for dashboardUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dashboard_url")
    public final Builder dashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getLastOperation() lastOperation} attribute.
     * @param lastOperation The value for lastOperation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("last_operation")
    public final Builder lastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getMaintenanceInfo() maintenanceInfo} attribute.
     * @param maintenanceInfo The value for maintenanceInfo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maintenance_info")
    public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getServiceBrokerName() serviceBrokerName} attribute.
     * @param serviceBrokerName The value for serviceBrokerName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_broker_name")
    public final Builder serviceBrokerName(@Nullable String serviceBrokerName) {
      this.serviceBrokerName = serviceBrokerName;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getServicePlan() servicePlan} attribute.
     * @param servicePlan The value for servicePlan (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan")
    public final Builder servicePlan(@Nullable Plan servicePlan) {
      this.servicePlan = servicePlan;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getSharedFrom() sharedFrom} attribute.
     * @param sharedFrom The value for sharedFrom (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("shared_from")
    public final Builder sharedFrom(@Nullable Share sharedFrom) {
      this.sharedFrom = sharedFrom;
      return this;
    }

    /**
     * Adds one element to {@link ServiceInstance#getSharedTo() sharedTo} list.
     * @param element A sharedTo element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedTo(Share element) {
      if (this.sharedTo == null) {
        this.sharedTo = new ArrayList<Share>();
      }
      this.sharedTo.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ServiceInstance#getSharedTo() sharedTo} list.
     * @param elements An array of sharedTo elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedTo(Share... elements) {
      if (this.sharedTo == null) {
        this.sharedTo = new ArrayList<Share>();
      }
      for (Share element : elements) {
        this.sharedTo.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceInstance#getSharedTo() sharedTo} list.
     * @param elements An iterable of sharedTo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("shared_to")
    public final Builder sharedTo(@Nullable Iterable<? extends Share> elements) {
      if (elements == null) {
        this.sharedTo = null;
        return this;
      }
      this.sharedTo = new ArrayList<Share>();
      return addAllSharedTo(elements);
    }

    /**
     * Adds elements to {@link ServiceInstance#getSharedTo() sharedTo} list.
     * @param elements An iterable of sharedTo elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSharedTo(Iterable<? extends Share> elements) {
      Objects.requireNonNull(elements, "sharedTo element");
      if (this.sharedTo == null) {
        this.sharedTo = new ArrayList<Share>();
      }
      for (Share element : elements) {
        this.sharedTo.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstance#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link ServiceInstance ServiceInstance}.
     * @return An immutable instance of ServiceInstance
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceInstance build() {
      return new ServiceInstance(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
