package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Billing Managed Organization from the User operation
 */
@Generated(from = "_RemoveUserBillingManagedOrganizationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveUserBillingManagedOrganizationRequest
    extends org.cloudfoundry.client.v2.users._RemoveUserBillingManagedOrganizationRequest {
  private final String billingManagedOrganizationId;
  private final String userId;

  private RemoveUserBillingManagedOrganizationRequest(RemoveUserBillingManagedOrganizationRequest.Builder builder) {
    this.billingManagedOrganizationId = builder.billingManagedOrganizationId;
    this.userId = builder.userId;
  }

  /**
   * The id of the billing managed organization
   */
  @Override
  public String getBillingManagedOrganizationId() {
    return billingManagedOrganizationId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveUserBillingManagedOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveUserBillingManagedOrganizationRequest
        && equalTo((RemoveUserBillingManagedOrganizationRequest) another);
  }

  private boolean equalTo(RemoveUserBillingManagedOrganizationRequest another) {
    return billingManagedOrganizationId.equals(another.billingManagedOrganizationId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code billingManagedOrganizationId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + billingManagedOrganizationId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveUserBillingManagedOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveUserBillingManagedOrganizationRequest{"
        + "billingManagedOrganizationId=" + billingManagedOrganizationId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveUserBillingManagedOrganizationRequest RemoveUserBillingManagedOrganizationRequest}.
   * <pre>
   * RemoveUserBillingManagedOrganizationRequest.builder()
   *    .billingManagedOrganizationId(String) // required {@link RemoveUserBillingManagedOrganizationRequest#getBillingManagedOrganizationId() billingManagedOrganizationId}
   *    .userId(String) // required {@link RemoveUserBillingManagedOrganizationRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new RemoveUserBillingManagedOrganizationRequest builder
   */
  public static RemoveUserBillingManagedOrganizationRequest.Builder builder() {
    return new RemoveUserBillingManagedOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveUserBillingManagedOrganizationRequest RemoveUserBillingManagedOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveUserBillingManagedOrganizationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BILLING_MANAGED_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String billingManagedOrganizationId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveUserBillingManagedOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveUserBillingManagedOrganizationRequest instance) {
      return from((_RemoveUserBillingManagedOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveUserBillingManagedOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveUserBillingManagedOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      billingManagedOrganizationId(instance.getBillingManagedOrganizationId());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserBillingManagedOrganizationRequest#getBillingManagedOrganizationId() billingManagedOrganizationId} attribute.
     * @param billingManagedOrganizationId The value for billingManagedOrganizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganizationId(String billingManagedOrganizationId) {
      this.billingManagedOrganizationId = Objects.requireNonNull(billingManagedOrganizationId, "billingManagedOrganizationId");
      initBits &= ~INIT_BIT_BILLING_MANAGED_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserBillingManagedOrganizationRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveUserBillingManagedOrganizationRequest RemoveUserBillingManagedOrganizationRequest}.
     * @return An immutable instance of RemoveUserBillingManagedOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveUserBillingManagedOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveUserBillingManagedOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BILLING_MANAGED_ORGANIZATION_ID) != 0) attributes.add("billingManagedOrganizationId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build RemoveUserBillingManagedOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
