package org.cloudfoundry.client.v2.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitionResource;
import org.immutables.value.Generated;

/**
 * The entity response payload for the User Organization resource
 */
@Generated(from = "_UserOrganizationEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UserOrganizationEntity extends org.cloudfoundry.client.v2.users._UserOrganizationEntity {
  private final @Nullable Boolean billingEnabled;
  private final @Nullable List<UserResource> managers;
  private final @Nullable String name;
  private final @Nullable OrganizationQuotaDefinitionResource quotaDefinition;
  private final @Nullable List<UserSpaceResource> spaces;
  private final @Nullable String status;

  private UserOrganizationEntity(UserOrganizationEntity.Builder builder) {
    this.billingEnabled = builder.billingEnabled;
    this.managers = builder.managers == null ? null : createUnmodifiableList(true, builder.managers);
    this.name = builder.name;
    this.quotaDefinition = builder.quotaDefinition;
    this.spaces = builder.spaces == null ? null : createUnmodifiableList(true, builder.spaces);
    this.status = builder.status;
  }

  /**
   * Billing enabled
   */
  @JsonProperty("billing_enabled")
  @Override
  public @Nullable Boolean getBillingEnabled() {
    return billingEnabled;
  }

  /**
   * The spaces
   */
  @JsonProperty("managers")
  @Override
  public @Nullable List<UserResource> getManagers() {
    return managers;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The spaces
   */
  @JsonProperty("quota_definition")
  @Override
  public @Nullable OrganizationQuotaDefinitionResource getQuotaDefinition() {
    return quotaDefinition;
  }

  /**
   * The spaces
   */
  @JsonProperty("spaces")
  @Override
  public @Nullable List<UserSpaceResource> getSpaces() {
    return spaces;
  }

  /**
   * The status
   */
  @JsonProperty("status")
  @Override
  public @Nullable String getStatus() {
    return status;
  }

  /**
   * This instance is equal to all instances of {@code UserOrganizationEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserOrganizationEntity
        && equalTo((UserOrganizationEntity) another);
  }

  private boolean equalTo(UserOrganizationEntity another) {
    return Objects.equals(billingEnabled, another.billingEnabled)
        && Objects.equals(managers, another.managers)
        && Objects.equals(name, another.name)
        && Objects.equals(quotaDefinition, another.quotaDefinition)
        && Objects.equals(spaces, another.spaces)
        && Objects.equals(status, another.status);
  }

  /**
   * Computes a hash code from attributes: {@code billingEnabled}, {@code managers}, {@code name}, {@code quotaDefinition}, {@code spaces}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(billingEnabled);
    h += (h << 5) + Objects.hashCode(managers);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(quotaDefinition);
    h += (h << 5) + Objects.hashCode(spaces);
    h += (h << 5) + Objects.hashCode(status);
    return h;
  }

  /**
   * Prints the immutable value {@code UserOrganizationEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserOrganizationEntity{"
        + "billingEnabled=" + billingEnabled
        + ", managers=" + managers
        + ", name=" + name
        + ", quotaDefinition=" + quotaDefinition
        + ", spaces=" + spaces
        + ", status=" + status
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UserOrganizationEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.users._UserOrganizationEntity {
    Boolean billingEnabled;
    List<UserResource> managers = null;
    String name;
    OrganizationQuotaDefinitionResource quotaDefinition;
    List<UserSpaceResource> spaces = null;
    String status;
    @JsonProperty("billing_enabled")
    public void setBillingEnabled(@Nullable Boolean billingEnabled) {
      this.billingEnabled = billingEnabled;
    }
    @JsonProperty("managers")
    public void setManagers(@Nullable List<UserResource> managers) {
      this.managers = managers;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("quota_definition")
    public void setQuotaDefinition(@Nullable OrganizationQuotaDefinitionResource quotaDefinition) {
      this.quotaDefinition = quotaDefinition;
    }
    @JsonProperty("spaces")
    public void setSpaces(@Nullable List<UserSpaceResource> spaces) {
      this.spaces = spaces;
    }
    @JsonProperty("status")
    public void setStatus(@Nullable String status) {
      this.status = status;
    }
    @Override
    public Boolean getBillingEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public List<UserResource> getManagers() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public OrganizationQuotaDefinitionResource getQuotaDefinition() { throw new UnsupportedOperationException(); }
    @Override
    public List<UserSpaceResource> getSpaces() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatus() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UserOrganizationEntity fromJson(Json json) {
    UserOrganizationEntity.Builder builder = UserOrganizationEntity.builder();
    if (json.billingEnabled != null) {
      builder.billingEnabled(json.billingEnabled);
    }
    if (json.managers != null) {
      builder.addAllManagers(json.managers);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.quotaDefinition != null) {
      builder.quotaDefinition(json.quotaDefinition);
    }
    if (json.spaces != null) {
      builder.addAllSpaces(json.spaces);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserOrganizationEntity UserOrganizationEntity}.
   * <pre>
   * UserOrganizationEntity.builder()
   *    .billingEnabled(Boolean | null) // nullable {@link UserOrganizationEntity#getBillingEnabled() billingEnabled}
   *    .managers(List&amp;lt;org.cloudfoundry.client.v2.users.UserResource&amp;gt; | null) // nullable {@link UserOrganizationEntity#getManagers() managers}
   *    .name(String | null) // nullable {@link UserOrganizationEntity#getName() name}
   *    .quotaDefinition(org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitionResource | null) // nullable {@link UserOrganizationEntity#getQuotaDefinition() quotaDefinition}
   *    .spaces(List&amp;lt;org.cloudfoundry.client.v2.users.UserSpaceResource&amp;gt; | null) // nullable {@link UserOrganizationEntity#getSpaces() spaces}
   *    .status(String | null) // nullable {@link UserOrganizationEntity#getStatus() status}
   *    .build();
   * </pre>
   * @return A new UserOrganizationEntity builder
   */
  public static UserOrganizationEntity.Builder builder() {
    return new UserOrganizationEntity.Builder();
  }

  /**
   * Builds instances of type {@link UserOrganizationEntity UserOrganizationEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UserOrganizationEntity", generator = "Immutables")
  public static final class Builder {
    private Boolean billingEnabled;
    private List<UserResource> managers = null;
    private String name;
    private OrganizationQuotaDefinitionResource quotaDefinition;
    private List<UserSpaceResource> spaces = null;
    private String status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserOrganizationEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserOrganizationEntity instance) {
      return from((_UserOrganizationEntity) instance);
    }

    /**
     * Copy abstract value type {@code _UserOrganizationEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UserOrganizationEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean billingEnabledValue = instance.getBillingEnabled();
      if (billingEnabledValue != null) {
        billingEnabled(billingEnabledValue);
      }
      List<UserResource> managersValue = instance.getManagers();
      if (managersValue != null) {
        addAllManagers(managersValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      OrganizationQuotaDefinitionResource quotaDefinitionValue = instance.getQuotaDefinition();
      if (quotaDefinitionValue != null) {
        quotaDefinition(quotaDefinitionValue);
      }
      List<UserSpaceResource> spacesValue = instance.getSpaces();
      if (spacesValue != null) {
        addAllSpaces(spacesValue);
      }
      String statusValue = instance.getStatus();
      if (statusValue != null) {
        status(statusValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserOrganizationEntity#getBillingEnabled() billingEnabled} attribute.
     * @param billingEnabled The value for billingEnabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("billing_enabled")
    public final Builder billingEnabled(@Nullable Boolean billingEnabled) {
      this.billingEnabled = billingEnabled;
      return this;
    }

    /**
     * Adds one element to {@link UserOrganizationEntity#getManagers() managers} list.
     * @param element A managers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder manager(UserResource element) {
      if (this.managers == null) {
        this.managers = new ArrayList<UserResource>();
      }
      this.managers.add(Objects.requireNonNull(element, "managers element"));
      return this;
    }

    /**
     * Adds elements to {@link UserOrganizationEntity#getManagers() managers} list.
     * @param elements An array of managers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managers(UserResource... elements) {
      if (this.managers == null) {
        this.managers = new ArrayList<UserResource>();
      }
      for (UserResource element : elements) {
        this.managers.add(Objects.requireNonNull(element, "managers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserOrganizationEntity#getManagers() managers} list.
     * @param elements An iterable of managers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("managers")
    public final Builder managers(@Nullable Iterable<? extends UserResource> elements) {
      if (elements == null) {
        this.managers = null;
        return this;
      }
      this.managers = new ArrayList<UserResource>();
      return addAllManagers(elements);
    }

    /**
     * Adds elements to {@link UserOrganizationEntity#getManagers() managers} list.
     * @param elements An iterable of managers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagers(Iterable<? extends UserResource> elements) {
      Objects.requireNonNull(elements, "managers element");
      if (this.managers == null) {
        this.managers = new ArrayList<UserResource>();
      }
      for (UserResource element : elements) {
        this.managers.add(Objects.requireNonNull(element, "managers element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserOrganizationEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link UserOrganizationEntity#getQuotaDefinition() quotaDefinition} attribute.
     * @param quotaDefinition The value for quotaDefinition (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("quota_definition")
    public final Builder quotaDefinition(@Nullable OrganizationQuotaDefinitionResource quotaDefinition) {
      this.quotaDefinition = quotaDefinition;
      return this;
    }

    /**
     * Adds one element to {@link UserOrganizationEntity#getSpaces() spaces} list.
     * @param element A spaces element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(UserSpaceResource element) {
      if (this.spaces == null) {
        this.spaces = new ArrayList<UserSpaceResource>();
      }
      this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      return this;
    }

    /**
     * Adds elements to {@link UserOrganizationEntity#getSpaces() spaces} list.
     * @param elements An array of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaces(UserSpaceResource... elements) {
      if (this.spaces == null) {
        this.spaces = new ArrayList<UserSpaceResource>();
      }
      for (UserSpaceResource element : elements) {
        this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserOrganizationEntity#getSpaces() spaces} list.
     * @param elements An iterable of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("spaces")
    public final Builder spaces(@Nullable Iterable<? extends UserSpaceResource> elements) {
      if (elements == null) {
        this.spaces = null;
        return this;
      }
      this.spaces = new ArrayList<UserSpaceResource>();
      return addAllSpaces(elements);
    }

    /**
     * Adds elements to {@link UserOrganizationEntity#getSpaces() spaces} list.
     * @param elements An iterable of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaces(Iterable<? extends UserSpaceResource> elements) {
      Objects.requireNonNull(elements, "spaces element");
      if (this.spaces == null) {
        this.spaces = new ArrayList<UserSpaceResource>();
      }
      for (UserSpaceResource element : elements) {
        this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserOrganizationEntity#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Builds a new {@link UserOrganizationEntity UserOrganizationEntity}.
     * @return An immutable instance of UserOrganizationEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserOrganizationEntity build() {
      return new UserOrganizationEntity(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
