package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.processes.HealthCheck;
import org.cloudfoundry.client.v3.processes.Process;
import org.cloudfoundry.client.v3.processes.ProcessRelationships;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Application Process operation
 */
@Generated(from = "_GetApplicationProcessResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetApplicationProcessResponse
    extends org.cloudfoundry.client.v3.applications._GetApplicationProcessResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final String command;
  private final Integer diskInMb;
  private final HealthCheck healthCheck;
  private final Integer instances;
  private final Integer memoryInMb;
  private final Metadata metadata;
  private final ProcessRelationships relationships;
  private final String type;

  private GetApplicationProcessResponse(GetApplicationProcessResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.command = builder.command;
    this.diskInMb = builder.diskInMb;
    this.healthCheck = builder.healthCheck;
    this.instances = builder.instances;
    this.memoryInMb = builder.memoryInMb;
    this.metadata = builder.metadata;
    this.relationships = builder.relationships;
    this.type = builder.type;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The command
   */
  @JsonProperty("command")
  @Override
  public String getCommand() {
    return command;
  }

  /**
   * The disk in megabytes
   */
  @JsonProperty("disk_in_mb")
  @Override
  public Integer getDiskInMb() {
    return diskInMb;
  }

  /**
   * The health check
   */
  @JsonProperty("health_check")
  @Override
  public HealthCheck getHealthCheck() {
    return healthCheck;
  }

  /**
   * The instances
   */
  @JsonProperty("instances")
  @Override
  public Integer getInstances() {
    return instances;
  }

  /**
   * The memory in megabytes
   */
  @JsonProperty("memory_in_mb")
  @Override
  public Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public ProcessRelationships getRelationships() {
    return relationships;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationProcessResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationProcessResponse
        && equalTo((GetApplicationProcessResponse) another);
  }

  private boolean equalTo(GetApplicationProcessResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && command.equals(another.command)
        && diskInMb.equals(another.diskInMb)
        && healthCheck.equals(another.healthCheck)
        && instances.equals(another.instances)
        && memoryInMb.equals(another.memoryInMb)
        && metadata.equals(another.metadata)
        && relationships.equals(another.relationships)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code command}, {@code diskInMb}, {@code healthCheck}, {@code instances}, {@code memoryInMb}, {@code metadata}, {@code relationships}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + command.hashCode();
    h += (h << 5) + diskInMb.hashCode();
    h += (h << 5) + healthCheck.hashCode();
    h += (h << 5) + instances.hashCode();
    h += (h << 5) + memoryInMb.hashCode();
    h += (h << 5) + metadata.hashCode();
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationProcessResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationProcessResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", command=" + command
        + ", diskInMb=" + diskInMb
        + ", healthCheck=" + healthCheck
        + ", instances=" + instances
        + ", memoryInMb=" + memoryInMb
        + ", metadata=" + metadata
        + ", relationships=" + relationships
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetApplicationProcessResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._GetApplicationProcessResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    String command;
    Integer diskInMb;
    HealthCheck healthCheck;
    Integer instances;
    Integer memoryInMb;
    Metadata metadata;
    ProcessRelationships relationships;
    String type;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("command")
    public void setCommand(String command) {
      this.command = command;
    }
    @JsonProperty("disk_in_mb")
    public void setDiskInMb(Integer diskInMb) {
      this.diskInMb = diskInMb;
    }
    @JsonProperty("health_check")
    public void setHealthCheck(HealthCheck healthCheck) {
      this.healthCheck = healthCheck;
    }
    @JsonProperty("instances")
    public void setInstances(Integer instances) {
      this.instances = instances;
    }
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("metadata")
    public void setMetadata(Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("relationships")
    public void setRelationships(ProcessRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDiskInMb() { throw new UnsupportedOperationException(); }
    @Override
    public HealthCheck getHealthCheck() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstances() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public ProcessRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetApplicationProcessResponse fromJson(Json json) {
    GetApplicationProcessResponse.Builder builder = GetApplicationProcessResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.command != null) {
      builder.command(json.command);
    }
    if (json.diskInMb != null) {
      builder.diskInMb(json.diskInMb);
    }
    if (json.healthCheck != null) {
      builder.healthCheck(json.healthCheck);
    }
    if (json.instances != null) {
      builder.instances(json.instances);
    }
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetApplicationProcessResponse GetApplicationProcessResponse}.
   * <pre>
   * GetApplicationProcessResponse.builder()
   *    .createdAt(String) // required {@link GetApplicationProcessResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetApplicationProcessResponse#getId() id}
   *    .link|putAllLinks(String =&gt; org.cloudfoundry.client.v3.Link) // {@link GetApplicationProcessResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetApplicationProcessResponse#getUpdatedAt() updatedAt}
   *    .command(String) // required {@link GetApplicationProcessResponse#getCommand() command}
   *    .diskInMb(Integer) // required {@link GetApplicationProcessResponse#getDiskInMb() diskInMb}
   *    .healthCheck(org.cloudfoundry.client.v3.processes.HealthCheck) // required {@link GetApplicationProcessResponse#getHealthCheck() healthCheck}
   *    .instances(Integer) // required {@link GetApplicationProcessResponse#getInstances() instances}
   *    .memoryInMb(Integer) // required {@link GetApplicationProcessResponse#getMemoryInMb() memoryInMb}
   *    .metadata(org.cloudfoundry.client.v3.Metadata) // required {@link GetApplicationProcessResponse#getMetadata() metadata}
   *    .relationships(org.cloudfoundry.client.v3.processes.ProcessRelationships) // required {@link GetApplicationProcessResponse#getRelationships() relationships}
   *    .type(String) // required {@link GetApplicationProcessResponse#getType() type}
   *    .build();
   * </pre>
   * @return A new GetApplicationProcessResponse builder
   */
  public static GetApplicationProcessResponse.Builder builder() {
    return new GetApplicationProcessResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationProcessResponse GetApplicationProcessResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetApplicationProcessResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_COMMAND = 0x4L;
    private static final long INIT_BIT_DISK_IN_MB = 0x8L;
    private static final long INIT_BIT_HEALTH_CHECK = 0x10L;
    private static final long INIT_BIT_INSTANCES = 0x20L;
    private static final long INIT_BIT_MEMORY_IN_MB = 0x40L;
    private static final long INIT_BIT_METADATA = 0x80L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x100L;
    private static final long INIT_BIT_TYPE = 0x200L;
    private long initBits = 0x3ffL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private String command;
    private Integer diskInMb;
    private HealthCheck healthCheck;
    private Integer instances;
    private Integer memoryInMb;
    private Metadata metadata;
    private ProcessRelationships relationships;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.processes.Process} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Process instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationProcessResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationProcessResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetApplicationProcessResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetApplicationProcessResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Process) {
        Process instance = (Process) object;
        diskInMb(instance.getDiskInMb());
        relationships(instance.getRelationships());
        metadata(instance.getMetadata());
        instances(instance.getInstances());
        memoryInMb(instance.getMemoryInMb());
        healthCheck(instance.getHealthCheck());
        type(instance.getType());
        command(instance.getCommand());
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationProcessResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationProcessResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetApplicationProcessResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetApplicationProcessResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("command")
    public final Builder command(String command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getDiskInMb() diskInMb} attribute.
     * @param diskInMb The value for diskInMb 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disk_in_mb")
    public final Builder diskInMb(Integer diskInMb) {
      this.diskInMb = Objects.requireNonNull(diskInMb, "diskInMb");
      initBits &= ~INIT_BIT_DISK_IN_MB;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getHealthCheck() healthCheck} attribute.
     * @param healthCheck The value for healthCheck 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("health_check")
    public final Builder healthCheck(HealthCheck healthCheck) {
      this.healthCheck = Objects.requireNonNull(healthCheck, "healthCheck");
      initBits &= ~INIT_BIT_HEALTH_CHECK;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getInstances() instances} attribute.
     * @param instances The value for instances 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instances")
    public final Builder instances(Integer instances) {
      this.instances = Objects.requireNonNull(instances, "instances");
      initBits &= ~INIT_BIT_INSTANCES;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_in_mb")
    public final Builder memoryInMb(Integer memoryInMb) {
      this.memoryInMb = Objects.requireNonNull(memoryInMb, "memoryInMb");
      initBits &= ~INIT_BIT_MEMORY_IN_MB;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(Metadata metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(ProcessRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationProcessResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationProcessResponse GetApplicationProcessResponse}.
     * @return An immutable instance of GetApplicationProcessResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationProcessResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetApplicationProcessResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      if ((initBits & INIT_BIT_DISK_IN_MB) != 0) attributes.add("diskInMb");
      if ((initBits & INIT_BIT_HEALTH_CHECK) != 0) attributes.add("healthCheck");
      if ((initBits & INIT_BIT_INSTANCES) != 0) attributes.add("instances");
      if ((initBits & INIT_BIT_MEMORY_IN_MB) != 0) attributes.add("memoryInMb");
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build GetApplicationProcessResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
