package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Application operation
 */
@Generated(from = "_UpdateApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateApplicationRequest
    extends org.cloudfoundry.client.v3.applications._UpdateApplicationRequest {
  private final String applicationId;
  private final @Nullable Lifecycle lifecycle;
  private final @Nullable Metadata metadata;
  private final @Nullable String name;

  private UpdateApplicationRequest(UpdateApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.lifecycle = builder.lifecycle;
    this.metadata = builder.metadata;
    this.name = builder.name;
  }

  /**
   * The application id
   */
  @JsonProperty("applicationId")
  @JsonIgnore
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The lifecycle
   */
  @JsonProperty("lifecycle")
  @Override
  public @Nullable Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code UpdateApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateApplicationRequest
        && equalTo((UpdateApplicationRequest) another);
  }

  private boolean equalTo(UpdateApplicationRequest another) {
    return applicationId.equals(another.applicationId)
        && Objects.equals(lifecycle, another.lifecycle)
        && Objects.equals(metadata, another.metadata)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code lifecycle}, {@code metadata}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + Objects.hashCode(lifecycle);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateApplicationRequest{"
        + "applicationId=" + applicationId
        + ", lifecycle=" + lifecycle
        + ", metadata=" + metadata
        + ", name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateApplicationRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._UpdateApplicationRequest {
    String applicationId;
    Lifecycle lifecycle;
    Metadata metadata;
    String name;
    @JsonProperty("applicationId")
    @JsonIgnore
    public void setApplicationId(String applicationId) {
      this.applicationId = applicationId;
    }
    @JsonProperty("lifecycle")
    public void setLifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @Override
    public String getApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public Lifecycle getLifecycle() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateApplicationRequest fromJson(Json json) {
    UpdateApplicationRequest.Builder builder = UpdateApplicationRequest.builder();
    if (json.applicationId != null) {
      builder.applicationId(json.applicationId);
    }
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateApplicationRequest UpdateApplicationRequest}.
   * <pre>
   * UpdateApplicationRequest.builder()
   *    .applicationId(String) // required {@link UpdateApplicationRequest#getApplicationId() applicationId}
   *    .lifecycle(org.cloudfoundry.client.v3.Lifecycle | null) // nullable {@link UpdateApplicationRequest#getLifecycle() lifecycle}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateApplicationRequest#getMetadata() metadata}
   *    .name(String | null) // nullable {@link UpdateApplicationRequest#getName() name}
   *    .build();
   * </pre>
   * @return A new UpdateApplicationRequest builder
   */
  public static UpdateApplicationRequest.Builder builder() {
    return new UpdateApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateApplicationRequest UpdateApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private Lifecycle lifecycle;
    private Metadata metadata;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateApplicationRequest instance) {
      return from((_UpdateApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      Lifecycle lifecycleValue = instance.getLifecycle();
      if (lifecycleValue != null) {
        lifecycle(lifecycleValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationRequest#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Builds a new {@link UpdateApplicationRequest UpdateApplicationRequest}.
     * @return An immutable instance of UpdateApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build UpdateApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
