package org.cloudfoundry.client.v3.buildpacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the the Update Buildpack request.
 */
@Generated(from = "_UpdateBuildpackResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateBuildpackResponse
    extends org.cloudfoundry.client.v3.buildpacks._UpdateBuildpackResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final Boolean enabled;
  private final @Nullable String filename;
  private final Boolean locked;
  private final @Nullable Metadata metadata;
  private final String name;
  private final Integer position;
  private final @Nullable String stack;
  private final BuildpackState state;

  private UpdateBuildpackResponse(UpdateBuildpackResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.enabled = builder.enabled;
    this.filename = builder.filename;
    this.locked = builder.locked;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.position = builder.position;
    this.stack = builder.stack;
    this.state = builder.state;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * Whether the buildpack is enabled
   */
  @JsonProperty("enabled")
  @Override
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * The filename
   */
  @JsonProperty("filename")
  @Override
  public @Nullable String getFilename() {
    return filename;
  }

  /**
   * Whether the buildpack is locked
   */
  @JsonProperty("locked")
  @Override
  public Boolean getLocked() {
    return locked;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The position
   */
  @JsonProperty("position")
  @Override
  public Integer getPosition() {
    return position;
  }

  /**
   * The stack
   */
  @JsonProperty("stack")
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public BuildpackState getState() {
    return state;
  }

  /**
   * This instance is equal to all instances of {@code UpdateBuildpackResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateBuildpackResponse
        && equalTo((UpdateBuildpackResponse) another);
  }

  private boolean equalTo(UpdateBuildpackResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && enabled.equals(another.enabled)
        && Objects.equals(filename, another.filename)
        && locked.equals(another.locked)
        && Objects.equals(metadata, another.metadata)
        && name.equals(another.name)
        && position.equals(another.position)
        && Objects.equals(stack, another.stack)
        && state.equals(another.state);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code enabled}, {@code filename}, {@code locked}, {@code metadata}, {@code name}, {@code position}, {@code stack}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + enabled.hashCode();
    h += (h << 5) + Objects.hashCode(filename);
    h += (h << 5) + locked.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + position.hashCode();
    h += (h << 5) + Objects.hashCode(stack);
    h += (h << 5) + state.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateBuildpackResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateBuildpackResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", enabled=" + enabled
        + ", filename=" + filename
        + ", locked=" + locked
        + ", metadata=" + metadata
        + ", name=" + name
        + ", position=" + position
        + ", stack=" + stack
        + ", state=" + state
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateBuildpackResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.buildpacks._UpdateBuildpackResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    Boolean enabled;
    String filename;
    Boolean locked;
    Metadata metadata;
    String name;
    Integer position;
    String stack;
    BuildpackState state;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("enabled")
    public void setEnabled(Boolean enabled) {
      this.enabled = enabled;
    }
    @JsonProperty("filename")
    public void setFilename(@Nullable String filename) {
      this.filename = filename;
    }
    @JsonProperty("locked")
    public void setLocked(Boolean locked) {
      this.locked = locked;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("position")
    public void setPosition(Integer position) {
      this.position = position;
    }
    @JsonProperty("stack")
    public void setStack(@Nullable String stack) {
      this.stack = stack;
    }
    @JsonProperty("state")
    public void setState(BuildpackState state) {
      this.state = state;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public String getFilename() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getLocked() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPosition() { throw new UnsupportedOperationException(); }
    @Override
    public String getStack() { throw new UnsupportedOperationException(); }
    @Override
    public BuildpackState getState() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateBuildpackResponse fromJson(Json json) {
    UpdateBuildpackResponse.Builder builder = UpdateBuildpackResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    if (json.filename != null) {
      builder.filename(json.filename);
    }
    if (json.locked != null) {
      builder.locked(json.locked);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.position != null) {
      builder.position(json.position);
    }
    if (json.stack != null) {
      builder.stack(json.stack);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateBuildpackResponse UpdateBuildpackResponse}.
   * <pre>
   * UpdateBuildpackResponse.builder()
   *    .createdAt(String) // required {@link UpdateBuildpackResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link UpdateBuildpackResponse#getId() id}
   *    .link|putAllLinks(String =&gt; org.cloudfoundry.client.v3.Link) // {@link UpdateBuildpackResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link UpdateBuildpackResponse#getUpdatedAt() updatedAt}
   *    .enabled(Boolean) // required {@link UpdateBuildpackResponse#getEnabled() enabled}
   *    .filename(String | null) // nullable {@link UpdateBuildpackResponse#getFilename() filename}
   *    .locked(Boolean) // required {@link UpdateBuildpackResponse#getLocked() locked}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateBuildpackResponse#getMetadata() metadata}
   *    .name(String) // required {@link UpdateBuildpackResponse#getName() name}
   *    .position(Integer) // required {@link UpdateBuildpackResponse#getPosition() position}
   *    .stack(String | null) // nullable {@link UpdateBuildpackResponse#getStack() stack}
   *    .state(org.cloudfoundry.client.v3.buildpacks.BuildpackState) // required {@link UpdateBuildpackResponse#getState() state}
   *    .build();
   * </pre>
   * @return A new UpdateBuildpackResponse builder
   */
  public static UpdateBuildpackResponse.Builder builder() {
    return new UpdateBuildpackResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateBuildpackResponse UpdateBuildpackResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateBuildpackResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_ENABLED = 0x4L;
    private static final long INIT_BIT_LOCKED = 0x8L;
    private static final long INIT_BIT_NAME = 0x10L;
    private static final long INIT_BIT_POSITION = 0x20L;
    private static final long INIT_BIT_STATE = 0x40L;
    private long initBits = 0x7fL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private Boolean enabled;
    private String filename;
    private Boolean locked;
    private Metadata metadata;
    private String name;
    private Integer position;
    private String stack;
    private BuildpackState state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.buildpacks.Buildpack} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Buildpack instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateBuildpackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateBuildpackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateBuildpackResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateBuildpackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Buildpack) {
        Buildpack instance = (Buildpack) object;
        Metadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
          metadata(metadataValue);
        }
        String stackValue = instance.getStack();
        if (stackValue != null) {
          stack(stackValue);
        }
        String filenameValue = instance.getFilename();
        if (filenameValue != null) {
          filename(filenameValue);
        }
        name(instance.getName());
        position(instance.getPosition());
        state(instance.getState());
        locked(instance.getLocked());
        enabled(instance.getEnabled());
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link UpdateBuildpackResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UpdateBuildpackResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UpdateBuildpackResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UpdateBuildpackResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getEnabled() enabled} attribute.
     * @param enabled The value for enabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("enabled")
    public final Builder enabled(Boolean enabled) {
      this.enabled = Objects.requireNonNull(enabled, "enabled");
      initBits &= ~INIT_BIT_ENABLED;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getFilename() filename} attribute.
     * @param filename The value for filename (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("filename")
    public final Builder filename(@Nullable String filename) {
      this.filename = filename;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getLocked() locked} attribute.
     * @param locked The value for locked 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("locked")
    public final Builder locked(Boolean locked) {
      this.locked = Objects.requireNonNull(locked, "locked");
      initBits &= ~INIT_BIT_LOCKED;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getPosition() position} attribute.
     * @param position The value for position 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("position")
    public final Builder position(Integer position) {
      this.position = Objects.requireNonNull(position, "position");
      initBits &= ~INIT_BIT_POSITION;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("stack")
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackResponse#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(BuildpackState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Builds a new {@link UpdateBuildpackResponse UpdateBuildpackResponse}.
     * @return An immutable instance of UpdateBuildpackResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateBuildpackResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateBuildpackResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ENABLED) != 0) attributes.add("enabled");
      if ((initBits & INIT_BIT_LOCKED) != 0) attributes.add("locked");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_POSITION) != 0) attributes.add("position");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      return "Cannot build UpdateBuildpackResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
