package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Cancel Deployment operation
 */
@Generated(from = "_CancelDeploymentRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CancelDeploymentRequest
    extends org.cloudfoundry.client.v3.deployments._CancelDeploymentRequest {
  private final String deploymentId;

  private CancelDeploymentRequest(CancelDeploymentRequest.Builder builder) {
    this.deploymentId = builder.deploymentId;
  }

  /**
   * The deployment id
   */
  @JsonProperty("deploymentId")
  @JsonIgnore
  @Override
  public String getDeploymentId() {
    return deploymentId;
  }

  /**
   * This instance is equal to all instances of {@code CancelDeploymentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CancelDeploymentRequest
        && equalTo((CancelDeploymentRequest) another);
  }

  private boolean equalTo(CancelDeploymentRequest another) {
    return deploymentId.equals(another.deploymentId);
  }

  /**
   * Computes a hash code from attributes: {@code deploymentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + deploymentId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CancelDeploymentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CancelDeploymentRequest{"
        + "deploymentId=" + deploymentId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CancelDeploymentRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.deployments._CancelDeploymentRequest {
    String deploymentId;
    @JsonProperty("deploymentId")
    @JsonIgnore
    public void setDeploymentId(String deploymentId) {
      this.deploymentId = deploymentId;
    }
    @Override
    public String getDeploymentId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CancelDeploymentRequest fromJson(Json json) {
    CancelDeploymentRequest.Builder builder = CancelDeploymentRequest.builder();
    if (json.deploymentId != null) {
      builder.deploymentId(json.deploymentId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CancelDeploymentRequest CancelDeploymentRequest}.
   * <pre>
   * CancelDeploymentRequest.builder()
   *    .deploymentId(String) // required {@link CancelDeploymentRequest#getDeploymentId() deploymentId}
   *    .build();
   * </pre>
   * @return A new CancelDeploymentRequest builder
   */
  public static CancelDeploymentRequest.Builder builder() {
    return new CancelDeploymentRequest.Builder();
  }

  /**
   * Builds instances of type {@link CancelDeploymentRequest CancelDeploymentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CancelDeploymentRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DEPLOYMENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String deploymentId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CancelDeploymentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CancelDeploymentRequest instance) {
      return from((_CancelDeploymentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CancelDeploymentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CancelDeploymentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      deploymentId(instance.getDeploymentId());
      return this;
    }

    /**
     * Initializes the value for the {@link CancelDeploymentRequest#getDeploymentId() deploymentId} attribute.
     * @param deploymentId The value for deploymentId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder deploymentId(String deploymentId) {
      this.deploymentId = Objects.requireNonNull(deploymentId, "deploymentId");
      initBits &= ~INIT_BIT_DEPLOYMENT_ID;
      return this;
    }

    /**
     * Builds a new {@link CancelDeploymentRequest CancelDeploymentRequest}.
     * @return An immutable instance of CancelDeploymentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CancelDeploymentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CancelDeploymentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DEPLOYMENT_ID) != 0) attributes.add("deploymentId");
      return "Cannot build CancelDeploymentRequest, some of required attributes are not set " + attributes;
    }
  }
}
