package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The status payload for the Deployment entity
 */
@Generated(from = "_Status", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Status extends org.cloudfoundry.client.v3.deployments._Status {
  private final Map<String, String> details;
  private final @Nullable DeploymentStatusReason reason;
  private final DeploymentStatusValue value;

  private Status(Status.Builder builder) {
    this.details = createUnmodifiableMap(false, false, builder.details);
    this.reason = builder.reason;
    this.value = builder.value;
  }

  /**
   * The details
   */
  @JsonProperty("details")
  @Override
  public Map<String, String> getDetails() {
    return details;
  }

  /**
   * The reason
   */
  @JsonProperty("reason")
  @Override
  public @Nullable DeploymentStatusReason getReason() {
    return reason;
  }

  /**
   * The value
   */
  @JsonProperty("value")
  @Override
  public DeploymentStatusValue getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code Status} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Status
        && equalTo((Status) another);
  }

  private boolean equalTo(Status another) {
    return details.equals(another.details)
        && Objects.equals(reason, another.reason)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code details}, {@code reason}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + details.hashCode();
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Status} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Status{"
        + "details=" + details
        + ", reason=" + reason
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Status", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.deployments._Status {
    Map<String, String> details = Collections.emptyMap();
    DeploymentStatusReason reason;
    DeploymentStatusValue value;
    @JsonProperty("details")
    public void setDetails(Map<String, String> details) {
      this.details = details;
    }
    @JsonProperty("reason")
    public void setReason(@Nullable DeploymentStatusReason reason) {
      this.reason = reason;
    }
    @JsonProperty("value")
    public void setValue(DeploymentStatusValue value) {
      this.value = value;
    }
    @Override
    public Map<String, String> getDetails() { throw new UnsupportedOperationException(); }
    @Override
    public DeploymentStatusReason getReason() { throw new UnsupportedOperationException(); }
    @Override
    public DeploymentStatusValue getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Status fromJson(Json json) {
    Status.Builder builder = Status.builder();
    if (json.details != null) {
      builder.putAllDetails(json.details);
    }
    if (json.reason != null) {
      builder.reason(json.reason);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Status Status}.
   * <pre>
   * Status.builder()
   *    .detail|putAllDetails(String =&gt; String) // {@link Status#getDetails() details} mappings
   *    .reason(org.cloudfoundry.client.v3.deployments.DeploymentStatusReason | null) // nullable {@link Status#getReason() reason}
   *    .value(org.cloudfoundry.client.v3.deployments.DeploymentStatusValue) // required {@link Status#getValue() value}
   *    .build();
   * </pre>
   * @return A new Status builder
   */
  public static Status.Builder builder() {
    return new Status.Builder();
  }

  /**
   * Builds instances of type {@link Status Status}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Status", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private Map<String, String> details = new LinkedHashMap<String, String>();
    private DeploymentStatusReason reason;
    private DeploymentStatusValue value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Status} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Status instance) {
      return from((_Status) instance);
    }

    /**
     * Copy abstract value type {@code _Status} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Status instance) {
      Objects.requireNonNull(instance, "instance");
      putAllDetails(instance.getDetails());
      DeploymentStatusReason reasonValue = instance.getReason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      value(instance.getValue());
      return this;
    }

    /**
     * Put one entry to the {@link Status#getDetails() details} map.
     * @param key The key in the details map
     * @param value The associated value in the details map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder detail(String key, String value) {
      this.details.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Status#getDetails() details} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder detail(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.details.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Status#getDetails() details} map. Nulls are not permitted
     * @param entries The entries that will be added to the details map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("details")
    public final Builder details(Map<String, ? extends String> entries) {
      this.details.clear();
      return putAllDetails(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Status#getDetails() details} map. Nulls are not permitted
     * @param entries The entries that will be added to the details map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllDetails(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.details.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Status#getReason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("reason")
    public final Builder reason(@Nullable DeploymentStatusReason reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link Status#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(DeploymentStatusValue value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link Status Status}.
     * @return An immutable instance of Status
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Status build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Status(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build Status, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
