package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Package operation
 */
@Generated(from = "_GetPackageResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetPackageResponse extends org.cloudfoundry.client.v3.packages._GetPackageResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final PackageData data;
  private final @Nullable Metadata metadata;
  private final PackageState state;
  private final PackageType type;
  private final @Nullable PackageRelationships relationships;

  private GetPackageResponse(GetPackageResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.data = builder.data;
    this.metadata = builder.metadata;
    this.state = builder.state;
    this.type = builder.type;
    this.relationships = builder.relationships;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The data for the package
   */
  @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
  @JsonSubTypes({@JsonSubTypes.Type(name = "bits", value = BitsData.class), @JsonSubTypes.Type(name = "docker", value = DockerData.class)})
  @JsonProperty("data")
  @Override
  public PackageData getData() {
    return data;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public PackageState getState() {
    return state;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public PackageType getType() {
    return type;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable PackageRelationships getRelationships() {
    return relationships;
  }

  /**
   * This instance is equal to all instances of {@code GetPackageResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetPackageResponse
        && equalTo((GetPackageResponse) another);
  }

  private boolean equalTo(GetPackageResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && data.equals(another.data)
        && Objects.equals(metadata, another.metadata)
        && state.equals(another.state)
        && type.equals(another.type)
        && Objects.equals(relationships, another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code data}, {@code metadata}, {@code state}, {@code type}, {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + data.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + state.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(relationships);
    return h;
  }

  /**
   * Prints the immutable value {@code GetPackageResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetPackageResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", data=" + data
        + ", metadata=" + metadata
        + ", state=" + state
        + ", type=" + type
        + ", relationships=" + relationships
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetPackageResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.packages._GetPackageResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    PackageData data;
    Metadata metadata;
    PackageState state;
    PackageType type;
    PackageRelationships relationships;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
    @JsonSubTypes({@JsonSubTypes.Type(name = "bits", value = BitsData.class), @JsonSubTypes.Type(name = "docker", value = DockerData.class)})
    @JsonProperty("data")
    public void setData(PackageData data) {
      this.data = data;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("state")
    public void setState(PackageState state) {
      this.state = state;
    }
    @JsonProperty("type")
    public void setType(PackageType type) {
      this.type = type;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable PackageRelationships relationships) {
      this.relationships = relationships;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public PackageData getData() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public PackageState getState() { throw new UnsupportedOperationException(); }
    @Override
    public PackageType getType() { throw new UnsupportedOperationException(); }
    @Override
    public PackageRelationships getRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetPackageResponse fromJson(Json json) {
    GetPackageResponse.Builder builder = GetPackageResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetPackageResponse GetPackageResponse}.
   * <pre>
   * GetPackageResponse.builder()
   *    .createdAt(String) // required {@link GetPackageResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetPackageResponse#getId() id}
   *    .link|putAllLinks(String =&gt; org.cloudfoundry.client.v3.Link) // {@link GetPackageResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetPackageResponse#getUpdatedAt() updatedAt}
   *    .data(org.cloudfoundry.client.v3.packages.PackageData) // required {@link GetPackageResponse#getData() data}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link GetPackageResponse#getMetadata() metadata}
   *    .state(org.cloudfoundry.client.v3.packages.PackageState) // required {@link GetPackageResponse#getState() state}
   *    .type(org.cloudfoundry.client.v3.packages.PackageType) // required {@link GetPackageResponse#getType() type}
   *    .relationships(org.cloudfoundry.client.v3.packages.PackageRelationships | null) // nullable {@link GetPackageResponse#getRelationships() relationships}
   *    .build();
   * </pre>
   * @return A new GetPackageResponse builder
   */
  public static GetPackageResponse.Builder builder() {
    return new GetPackageResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetPackageResponse GetPackageResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetPackageResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_DATA = 0x4L;
    private static final long INIT_BIT_STATE = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private long initBits = 0x1fL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private PackageData data;
    private Metadata metadata;
    private PackageState state;
    private PackageType type;
    private PackageRelationships relationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.packages.Package} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Package instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetPackageResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetPackageResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetPackageResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetPackageResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Package) {
        Package instance = (Package) object;
        PackageRelationships relationshipsValue = instance.getRelationships();
        if (relationshipsValue != null) {
          relationships(relationshipsValue);
        }
        Metadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
          metadata(metadataValue);
        }
        state(instance.getState());
        data(instance.getData());
        type(instance.getType());
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link GetPackageResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetPackageResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetPackageResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetPackageResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetPackageResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetPackageResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetPackageResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link GetPackageResponse#getData() data} attribute.
     * @param data The value for data 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
    @JsonSubTypes({@JsonSubTypes.Type(name = "bits", value = BitsData.class), @JsonSubTypes.Type(name = "docker", value = DockerData.class)})
    @JsonProperty("data")
    public final Builder data(PackageData data) {
      this.data = Objects.requireNonNull(data, "data");
      initBits &= ~INIT_BIT_DATA;
      return this;
    }

    /**
     * Initializes the value for the {@link GetPackageResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link GetPackageResponse#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(PackageState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetPackageResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(PackageType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetPackageResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(@Nullable PackageRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Builds a new {@link GetPackageResponse GetPackageResponse}.
     * @return An immutable instance of GetPackageResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetPackageResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetPackageResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_DATA) != 0) attributes.add("data");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build GetPackageResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
