package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ProcessStatisticsResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ProcessStatisticsResource.builder()}.
 */
@Generated(from = "_ProcessStatisticsResource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ProcessStatisticsResource
    extends org.cloudfoundry.client.v3.processes._ProcessStatisticsResource {
  private final @Nullable String details;
  private final Integer diskQuota;
  private final Integer fileDescriptorQuota;
  private final String host;
  private final Integer index;
  private final List<PortMapping> instancePorts;
  private final @Nullable String isolationSegment;
  private final Integer memoryQuota;
  private final @Nullable ProcessState state;
  private final String type;
  private final Integer uptime;
  private final ProcessUsage usage;

  private ProcessStatisticsResource(ProcessStatisticsResource.Builder builder) {
    this.details = builder.details;
    this.diskQuota = builder.diskQuota;
    this.fileDescriptorQuota = builder.fileDescriptorQuota;
    this.host = builder.host;
    this.index = builder.index;
    this.instancePorts = createUnmodifiableList(true, builder.instancePorts);
    this.isolationSegment = builder.isolationSegment;
    this.memoryQuota = builder.memoryQuota;
    this.state = builder.state;
    this.type = builder.type;
    this.uptime = builder.uptime;
    this.usage = builder.usage;
  }

  /**
   * Information about errors placing the instance
   */
  @JsonProperty("details")
  @Override
  public @Nullable String getDetails() {
    return details;
  }

  /**
   * The disk quota
   */
  @JsonProperty("disk_quota")
  @Override
  public Integer getDiskQuota() {
    return diskQuota;
  }

  /**
   * The file descriptor quota
   */
  @JsonProperty("fds_quota")
  @Override
  public Integer getFileDescriptorQuota() {
    return fileDescriptorQuota;
  }

  /**
   * The host
   */
  @JsonProperty("host")
  @Override
  public String getHost() {
    return host;
  }

  /**
   * The index
   */
  @JsonProperty("index")
  @Override
  public Integer getIndex() {
    return index;
  }

  /**
   * The instance port mappings
   */
  @JsonProperty("instance_ports")
  @Override
  public List<PortMapping> getInstancePorts() {
    return instancePorts;
  }

  /**
   * The isolation segment
   */
  @JsonProperty("isolation_segment")
  @Override
  public @Nullable String getIsolationSegment() {
    return isolationSegment;
  }

  /**
   * The memory quota
   */
  @JsonProperty("mem_quota")
  @Override
  public Integer getMemoryQuota() {
    return memoryQuota;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public @Nullable ProcessState getState() {
    return state;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * The uptime
   */
  @JsonProperty("uptime")
  @Override
  public Integer getUptime() {
    return uptime;
  }

  /**
   * The usage
   */
  @JsonProperty("usage")
  @Override
  public ProcessUsage getUsage() {
    return usage;
  }

  /**
   * This instance is equal to all instances of {@code ProcessStatisticsResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ProcessStatisticsResource
        && equalTo((ProcessStatisticsResource) another);
  }

  private boolean equalTo(ProcessStatisticsResource another) {
    return Objects.equals(details, another.details)
        && diskQuota.equals(another.diskQuota)
        && fileDescriptorQuota.equals(another.fileDescriptorQuota)
        && host.equals(another.host)
        && index.equals(another.index)
        && instancePorts.equals(another.instancePorts)
        && Objects.equals(isolationSegment, another.isolationSegment)
        && memoryQuota.equals(another.memoryQuota)
        && Objects.equals(state, another.state)
        && type.equals(another.type)
        && uptime.equals(another.uptime)
        && usage.equals(another.usage);
  }

  /**
   * Computes a hash code from attributes: {@code details}, {@code diskQuota}, {@code fileDescriptorQuota}, {@code host}, {@code index}, {@code instancePorts}, {@code isolationSegment}, {@code memoryQuota}, {@code state}, {@code type}, {@code uptime}, {@code usage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(details);
    h += (h << 5) + diskQuota.hashCode();
    h += (h << 5) + fileDescriptorQuota.hashCode();
    h += (h << 5) + host.hashCode();
    h += (h << 5) + index.hashCode();
    h += (h << 5) + instancePorts.hashCode();
    h += (h << 5) + Objects.hashCode(isolationSegment);
    h += (h << 5) + memoryQuota.hashCode();
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + uptime.hashCode();
    h += (h << 5) + usage.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessStatisticsResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessStatisticsResource{"
        + "details=" + details
        + ", diskQuota=" + diskQuota
        + ", fileDescriptorQuota=" + fileDescriptorQuota
        + ", host=" + host
        + ", index=" + index
        + ", instancePorts=" + instancePorts
        + ", isolationSegment=" + isolationSegment
        + ", memoryQuota=" + memoryQuota
        + ", state=" + state
        + ", type=" + type
        + ", uptime=" + uptime
        + ", usage=" + usage
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ProcessStatisticsResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._ProcessStatisticsResource {
    String details;
    Integer diskQuota;
    Integer fileDescriptorQuota;
    String host;
    Integer index;
    List<PortMapping> instancePorts = Collections.emptyList();
    String isolationSegment;
    Integer memoryQuota;
    ProcessState state;
    String type;
    Integer uptime;
    ProcessUsage usage;
    @JsonProperty("details")
    public void setDetails(@Nullable String details) {
      this.details = details;
    }
    @JsonProperty("disk_quota")
    public void setDiskQuota(Integer diskQuota) {
      this.diskQuota = diskQuota;
    }
    @JsonProperty("fds_quota")
    public void setFileDescriptorQuota(Integer fileDescriptorQuota) {
      this.fileDescriptorQuota = fileDescriptorQuota;
    }
    @JsonProperty("host")
    public void setHost(String host) {
      this.host = host;
    }
    @JsonProperty("index")
    public void setIndex(Integer index) {
      this.index = index;
    }
    @JsonProperty("instance_ports")
    public void setInstancePorts(List<PortMapping> instancePorts) {
      this.instancePorts = instancePorts;
    }
    @JsonProperty("isolation_segment")
    public void setIsolationSegment(@Nullable String isolationSegment) {
      this.isolationSegment = isolationSegment;
    }
    @JsonProperty("mem_quota")
    public void setMemoryQuota(Integer memoryQuota) {
      this.memoryQuota = memoryQuota;
    }
    @JsonProperty("state")
    public void setState(@Nullable ProcessState state) {
      this.state = state;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("uptime")
    public void setUptime(Integer uptime) {
      this.uptime = uptime;
    }
    @JsonProperty("usage")
    public void setUsage(ProcessUsage usage) {
      this.usage = usage;
    }
    @Override
    public String getDetails() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDiskQuota() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getFileDescriptorQuota() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getIndex() { throw new UnsupportedOperationException(); }
    @Override
    public List<PortMapping> getInstancePorts() { throw new UnsupportedOperationException(); }
    @Override
    public String getIsolationSegment() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryQuota() { throw new UnsupportedOperationException(); }
    @Override
    public ProcessState getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getUptime() { throw new UnsupportedOperationException(); }
    @Override
    public ProcessUsage getUsage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ProcessStatisticsResource fromJson(Json json) {
    ProcessStatisticsResource.Builder builder = ProcessStatisticsResource.builder();
    if (json.details != null) {
      builder.details(json.details);
    }
    if (json.diskQuota != null) {
      builder.diskQuota(json.diskQuota);
    }
    if (json.fileDescriptorQuota != null) {
      builder.fileDescriptorQuota(json.fileDescriptorQuota);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.index != null) {
      builder.index(json.index);
    }
    if (json.instancePorts != null) {
      builder.addAllInstancePorts(json.instancePorts);
    }
    if (json.isolationSegment != null) {
      builder.isolationSegment(json.isolationSegment);
    }
    if (json.memoryQuota != null) {
      builder.memoryQuota(json.memoryQuota);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.uptime != null) {
      builder.uptime(json.uptime);
    }
    if (json.usage != null) {
      builder.usage(json.usage);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ProcessStatisticsResource ProcessStatisticsResource}.
   * <pre>
   * ProcessStatisticsResource.builder()
   *    .details(String | null) // nullable {@link ProcessStatisticsResource#getDetails() details}
   *    .diskQuota(Integer) // required {@link ProcessStatisticsResource#getDiskQuota() diskQuota}
   *    .fileDescriptorQuota(Integer) // required {@link ProcessStatisticsResource#getFileDescriptorQuota() fileDescriptorQuota}
   *    .host(String) // required {@link ProcessStatisticsResource#getHost() host}
   *    .index(Integer) // required {@link ProcessStatisticsResource#getIndex() index}
   *    .instancePort|addAllInstancePorts(org.cloudfoundry.client.v3.processes.PortMapping) // {@link ProcessStatisticsResource#getInstancePorts() instancePorts} elements
   *    .isolationSegment(String | null) // nullable {@link ProcessStatisticsResource#getIsolationSegment() isolationSegment}
   *    .memoryQuota(Integer) // required {@link ProcessStatisticsResource#getMemoryQuota() memoryQuota}
   *    .state(org.cloudfoundry.client.v3.processes.ProcessState | null) // nullable {@link ProcessStatisticsResource#getState() state}
   *    .type(String) // required {@link ProcessStatisticsResource#getType() type}
   *    .uptime(Integer) // required {@link ProcessStatisticsResource#getUptime() uptime}
   *    .usage(org.cloudfoundry.client.v3.processes.ProcessUsage) // required {@link ProcessStatisticsResource#getUsage() usage}
   *    .build();
   * </pre>
   * @return A new ProcessStatisticsResource builder
   */
  public static ProcessStatisticsResource.Builder builder() {
    return new ProcessStatisticsResource.Builder();
  }

  /**
   * Builds instances of type {@link ProcessStatisticsResource ProcessStatisticsResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ProcessStatisticsResource", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DISK_QUOTA = 0x1L;
    private static final long INIT_BIT_FILE_DESCRIPTOR_QUOTA = 0x2L;
    private static final long INIT_BIT_HOST = 0x4L;
    private static final long INIT_BIT_INDEX = 0x8L;
    private static final long INIT_BIT_MEMORY_QUOTA = 0x10L;
    private static final long INIT_BIT_TYPE = 0x20L;
    private static final long INIT_BIT_UPTIME = 0x40L;
    private static final long INIT_BIT_USAGE = 0x80L;
    private long initBits = 0xffL;

    private String details;
    private Integer diskQuota;
    private Integer fileDescriptorQuota;
    private String host;
    private Integer index;
    private List<PortMapping> instancePorts = new ArrayList<PortMapping>();
    private String isolationSegment;
    private Integer memoryQuota;
    private ProcessState state;
    private String type;
    private Integer uptime;
    private ProcessUsage usage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.processes.ProcessStatistics} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessStatistics instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessStatisticsResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessStatisticsResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ProcessStatisticsResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ProcessStatisticsResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ProcessStatistics) {
        ProcessStatistics instance = (ProcessStatistics) object;
        fileDescriptorQuota(instance.getFileDescriptorQuota());
        String isolationSegmentValue = instance.getIsolationSegment();
        if (isolationSegmentValue != null) {
          isolationSegment(isolationSegmentValue);
        }
        usage(instance.getUsage());
        host(instance.getHost());
        index(instance.getIndex());
        String detailsValue = instance.getDetails();
        if (detailsValue != null) {
          details(detailsValue);
        }
        memoryQuota(instance.getMemoryQuota());
        ProcessState stateValue = instance.getState();
        if (stateValue != null) {
          state(stateValue);
        }
        type(instance.getType());
        diskQuota(instance.getDiskQuota());
        addAllInstancePorts(instance.getInstancePorts());
        uptime(instance.getUptime());
      }
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getDetails() details} attribute.
     * @param details The value for details (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("details")
    public final Builder details(@Nullable String details) {
      this.details = details;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disk_quota")
    public final Builder diskQuota(Integer diskQuota) {
      this.diskQuota = Objects.requireNonNull(diskQuota, "diskQuota");
      initBits &= ~INIT_BIT_DISK_QUOTA;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getFileDescriptorQuota() fileDescriptorQuota} attribute.
     * @param fileDescriptorQuota The value for fileDescriptorQuota 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fds_quota")
    public final Builder fileDescriptorQuota(Integer fileDescriptorQuota) {
      this.fileDescriptorQuota = Objects.requireNonNull(fileDescriptorQuota, "fileDescriptorQuota");
      initBits &= ~INIT_BIT_FILE_DESCRIPTOR_QUOTA;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getHost() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("host")
    public final Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getIndex() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("index")
    public final Builder index(Integer index) {
      this.index = Objects.requireNonNull(index, "index");
      initBits &= ~INIT_BIT_INDEX;
      return this;
    }

    /**
     * Adds one element to {@link ProcessStatisticsResource#getInstancePorts() instancePorts} list.
     * @param element A instancePorts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instancePort(PortMapping element) {
      this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
      return this;
    }

    /**
     * Adds elements to {@link ProcessStatisticsResource#getInstancePorts() instancePorts} list.
     * @param elements An array of instancePorts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instancePorts(PortMapping... elements) {
      for (PortMapping element : elements) {
        this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProcessStatisticsResource#getInstancePorts() instancePorts} list.
     * @param elements An iterable of instancePorts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instance_ports")
    public final Builder instancePorts(Iterable<? extends PortMapping> elements) {
      this.instancePorts.clear();
      return addAllInstancePorts(elements);
    }

    /**
     * Adds elements to {@link ProcessStatisticsResource#getInstancePorts() instancePorts} list.
     * @param elements An iterable of instancePorts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllInstancePorts(Iterable<? extends PortMapping> elements) {
      for (PortMapping element : elements) {
        this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getIsolationSegment() isolationSegment} attribute.
     * @param isolationSegment The value for isolationSegment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("isolation_segment")
    public final Builder isolationSegment(@Nullable String isolationSegment) {
      this.isolationSegment = isolationSegment;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getMemoryQuota() memoryQuota} attribute.
     * @param memoryQuota The value for memoryQuota 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mem_quota")
    public final Builder memoryQuota(Integer memoryQuota) {
      this.memoryQuota = Objects.requireNonNull(memoryQuota, "memoryQuota");
      initBits &= ~INIT_BIT_MEMORY_QUOTA;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(@Nullable ProcessState state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getUptime() uptime} attribute.
     * @param uptime The value for uptime 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("uptime")
    public final Builder uptime(Integer uptime) {
      this.uptime = Objects.requireNonNull(uptime, "uptime");
      initBits &= ~INIT_BIT_UPTIME;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessStatisticsResource#getUsage() usage} attribute.
     * @param usage The value for usage 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("usage")
    public final Builder usage(ProcessUsage usage) {
      this.usage = Objects.requireNonNull(usage, "usage");
      initBits &= ~INIT_BIT_USAGE;
      return this;
    }

    /**
     * Builds a new {@link ProcessStatisticsResource ProcessStatisticsResource}.
     * @return An immutable instance of ProcessStatisticsResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ProcessStatisticsResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ProcessStatisticsResource(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DISK_QUOTA) != 0) attributes.add("diskQuota");
      if ((initBits & INIT_BIT_FILE_DESCRIPTOR_QUOTA) != 0) attributes.add("fileDescriptorQuota");
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      if ((initBits & INIT_BIT_INDEX) != 0) attributes.add("index");
      if ((initBits & INIT_BIT_MEMORY_QUOTA) != 0) attributes.add("memoryQuota");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_UPTIME) != 0) attributes.add("uptime");
      if ((initBits & INIT_BIT_USAGE) != 0) attributes.add("usage");
      return "Cannot build ProcessStatisticsResource, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
